/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.Compressor;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class DocumentLists {
    private static final int RANGE = 1024;
    private static final int NConcepts = 16;
    private static final int K = 3;
    private final IntegerArray[] _arrays = new IntegerArray[1024];
    private int _minConcept = 0;
    private int _limit = 1024;
    private final IntegerArray _concepts = new IntegerArray();
    private final IntegerArray _offsets = new IntegerArray();
    private final Compressor _compr = new Compressor();
    private final IntegerArray _diffs = new IntegerArray();
    private final ByteArrayDecompressor _decmp = new ByteArrayDecompressor(null, 0);
    private DataOutputStream _mainFile;
    private int _heapSize = 0;
    private MicroIndex[] _heap;
    private boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentLists(String indexDir) throws Exception {
        int i;
        for (int i2 = 0; i2 < 1024; ++i2) {
            this._arrays[i2] = new IntegerArray();
        }
        this._mainFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexDir + "DOCS")));
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(indexDir + "OFFSETS"));
        IntegerArray array = null;
        IntegerArray offsetArray = null;
        try {
            int k1 = ((InputStream)file).read();
            array = new IntegerArray(4096);
            StreamDecompressor documents = new StreamDecompressor(file);
            documents.ascDecode(k1, array);
            int k2 = ((InputStream)file).read();
            offsetArray = new IntegerArray(array.cardinality() + 1);
            StreamDecompressor offsets = new StreamDecompressor(file);
            offsets.ascDecode(k2, offsetArray);
        }
        finally {
            ((InputStream)file).close();
        }
        File listsFile = new File(indexDir + "POSITIONS");
        byte[] positions = new byte[(int)listsFile.length()];
        FileInputStream in = new FileInputStream(listsFile);
        try {
            in.read(positions);
        }
        finally {
            in.close();
        }
        this._heapSize = array.cardinality();
        this._heap = new MicroIndex[this._heapSize];
        for (i = 0; i < array.cardinality(); ++i) {
            this._heap[i] = new MicroIndex(i, positions, offsetArray.at(i));
        }
        this.debug(array.cardinality() + " documents");
        for (i = this._heapSize / 2; i >= 0; --i) {
            this.heapify(i);
        }
        while (true) {
            if (this._heap[0].process(this)) {
                this.heapify(0);
                continue;
            }
            if (this._heapSize <= 1) break;
            this._heap[0] = this._heap[--this._heapSize];
            this.heapify(0);
        }
        this.flush();
        this._mainFile.close();
        DataOutputStream indexFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexDir + "DOCS.TAB")));
        try {
            indexFile.write(this._compr.compressAscending(this._concepts));
            this._compr.write(indexFile);
            this._compr.clear();
            indexFile.write(this._compr.minimize(this._offsets, 3));
            this._compr.write(indexFile);
        }
        finally {
            indexFile.close();
        }
    }

    public short process(int documentNumber, int[] concepts, int n, short start, boolean firstTime) throws IOException {
        if (firstTime && concepts[start] >= this._limit) {
            this.flush();
        }
        concepts[n] = this._limit;
        while (concepts[start] < this._limit) {
            short s = start;
            start = (short)(start + 1);
            this._arrays[concepts[s] - this._minConcept].add(documentNumber);
        }
        return start;
    }

    private void heapify(int i) {
        int smallest;
        int r = i + 1 << 1;
        int l = r - 1;
        int n = smallest = l < this._heapSize && this._heap[l].smallerThan(this._heap[i]) ? l : i;
        if (r < this._heapSize && this._heap[r].smallerThan(this._heap[smallest])) {
            smallest = r;
        }
        if (smallest != i) {
            MicroIndex temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            this.heapify(smallest);
        }
    }

    private void flush() throws IOException {
        for (int i = 0; i < 1024; ++i) {
            if (this._arrays[i].cardinality() <= 0) continue;
            this._arrays[i].toDifferences(this._diffs);
            this._mainFile.write(this._compr.minimize(this._diffs, 3));
            this._offsets.add(this._compr.byteCount() + 1);
            this._compr.write(this._mainFile);
            this._concepts.add(this._minConcept + i);
            this._arrays[i].clear();
            this._diffs.clear();
            this._compr.clear();
        }
        this._limit += 1024;
        this._minConcept += 1024;
    }

    public static void invert(String indexDir) throws Exception {
        new DocumentLists(indexDir);
    }

    public static void main(String[] args) {
        String indexDir = args[0];
        try {
            new DocumentLists(indexDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("DocumentLists: " + msg);
        }
    }

    private class MicroIndex {
        private int _currentRange;
        private final int _documentNumber;
        private int[] _concepts = new int[17];
        private short _group;
        private short _ix;
        private IntegerArray _kTable = new IntegerArray();
        private IntegerArray _offsets = new IntegerArray();
        private IntegerArray _maxConcepts = new IntegerArray();
        private byte[] _data;
        private int _base;
        private int _limit;
        private int _nc;

        public MicroIndex(int documentNumber, byte[] positions, int index) throws Exception {
            this._documentNumber = documentNumber;
            this._data = positions;
            this._base = index;
            this.openDocumentIndex();
        }

        public boolean smallerThan(MicroIndex other) {
            return this._currentRange < other._currentRange || this._currentRange == other._currentRange && this._documentNumber < other._documentNumber;
        }

        private boolean next() throws Exception {
            if (this._group <= this._limit) {
                int shift;
                int index;
                if (this._group > 0) {
                    index = this._base + this._offsets.at(this._group - 1);
                    shift = this._maxConcepts.at(this._group - 1);
                } else {
                    index = this._base;
                    shift = 0;
                }
                DocumentLists.this._decmp.initReading(this._data, index);
                this._nc = DocumentLists.this._decmp.ascendingDecode(this._kTable.at(this._group * 2), shift, this._concepts);
                if (this._group < this._limit) {
                    this._concepts[this._nc++] = this._maxConcepts.at(this._group);
                }
                this._ix = 0;
                this._currentRange = this._concepts[0] / 1024;
                this._group = (short)(this._group + 1);
                return true;
            }
            return false;
        }

        private void openDocumentIndex() throws Exception {
            int kk = this._data[this._base] & 0xFF;
            switch (kk >> 6) {
                case 0: {
                    DocumentLists.this._decmp.initReading(this._data, this._base += 2);
                    this._nc = DocumentLists.this._decmp.ascendingDecode(kk & 0x3F, 0, this._concepts);
                    this._ix = 0;
                    this._currentRange = this._concepts[0] / 1024;
                    this._limit = 0;
                    this._group = 1;
                    break;
                }
                case 2: {
                    DocumentLists.this._decmp.initReading(this._data, this._base + 1);
                    DocumentLists.this._decmp.decode(kk & 0x3F, this._kTable);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._offsets);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._maxConcepts);
                    this._base += 1 + DocumentLists.this._decmp.bytesRead();
                    this._limit = this._maxConcepts.cardinality();
                    this._group = 0;
                    this.next();
                    break;
                }
                case 1: 
                case 3: {
                    System.err.println("extents not yet implemented\n");
                }
            }
        }

        public boolean process(DocumentLists lists) throws Exception {
            boolean firstTime = true;
            while (true) {
                short stop;
                if ((stop = lists.process(this._documentNumber, this._concepts, this._nc, this._ix, firstTime)) < this._nc) {
                    this._ix = stop;
                    this._currentRange = this._concepts[this._ix] / 1024;
                    return true;
                }
                if (!this.next()) break;
                firstTime = false;
            }
            return false;
        }
    }
}

