/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Schema {
    private String _dirName;
    private URL _hsBase = null;
    private boolean _update;
    private Vector _lines = new Vector();
    private static boolean debugFlag = false;

    public static void main(String[] args) {
        try {
            Schema sch = new Schema(null, "/files/resources/lexicon/LIF_ONT", false);
            Schema.debug(sch.parametersAsString("EDGE"));
            Schema.debug(sch.parametersAsString("TMAP"));
            Hashtable edge = sch.parameters("EDGE");
            Schema.debug(edge == null || !edge.containsKey("rt") ? "null" : edge.get("rt").toString());
            Schema.debug(edge == null || !edge.containsKey("v1") ? "null" : edge.get("vl").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Schema(URL base, String dirName, boolean update) throws Exception {
        this._hsBase = base;
        this._dirName = dirName;
        this._update = update;
        try {
            this.read();
        }
        catch (FileNotFoundException e) {
            Schema.debug("error creating SCHEMA");
        }
        for (int i = 0; i < this._lines.size(); ++i) {
            Schema.debug(this._lines.elementAt(i).toString());
        }
    }

    public void update(String partName, String parameters) {
        for (int i = 0; i < this._lines.size(); ++i) {
            if (!((String)this._lines.elementAt(i)).startsWith(partName)) continue;
            this._lines.removeElementAt(i);
        }
        this._lines.addElement(partName + " " + parameters);
    }

    public String parametersAsString(String name) {
        for (int i = 0; i < this._lines.size(); ++i) {
            if (!((String)this._lines.elementAt(i)).startsWith(name)) continue;
            return ((String)this._lines.elementAt(i)).substring(name.length() + 1);
        }
        return null;
    }

    public Hashtable parameters(String name) {
        for (int i = 0; i < this._lines.size(); ++i) {
            if (!((String)this._lines.elementAt(i)).startsWith(name)) continue;
            Hashtable<String, String> result = new Hashtable<String, String>();
            StringTokenizer tokens = new StringTokenizer((String)this._lines.elementAt(i), " =");
            tokens.nextToken();
            while (tokens.hasMoreTokens()) {
                result.put(tokens.nextToken(), tokens.nextToken());
            }
            return result;
        }
        return null;
    }

    public URL getURL(String name) throws Exception {
        URL baseURL = null;
        Object tmapURL = null;
        Schema.debug("getURL " + name);
        Schema.debug("dirName=" + this._dirName + " hsBase= " + this._hsBase);
        if (this._hsBase == null) {
            File file = new File(this._dirName);
            if (file.exists()) {
                if (File.separatorChar != '/') {
                    this._dirName = this._dirName.replace(File.separatorChar, '/');
                }
                if (this._dirName.lastIndexOf(47) != this._dirName.length() - 1) {
                    this._dirName = this._dirName.concat("/");
                }
                Schema.debug("file:" + this._dirName);
                baseURL = new URL("file", "", this._dirName);
            } else {
                baseURL = new URL(this._dirName);
            }
        }
        if (this._hsBase != null) {
            return new URL(this._hsBase, this._dirName + "/" + name);
        }
        return new URL(baseURL, name);
    }

    public void save() {
        if (this._update) {
            try {
                FileWriter out = new FileWriter(this._dirName + "/SCHEMA");
                try {
                    out.write("JavaSearch 1.0\n");
                    for (int i = 0; i < this._lines.size(); ++i) {
                        out.write((String)this._lines.elementAt(i));
                        out.write(10);
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                System.err.println("SCHEMA save failed " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws Exception {
        URL url = this.getURL("SCHEMA");
        URLConnection connect = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connect.getInputStream()));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this._lines.addElement(line);
            }
        }
        finally {
            in.close();
        }
    }

    private static void debug(String str) {
        if (debugFlag) {
            System.out.println("Schema: " + str);
        }
    }
}

