/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.help.BadIDException;
import javax.help.DefaultHelpHistoryModel;
import javax.help.DefaultHelpModel;
import javax.help.HelpHistoryModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SwingHelpUtilities;
import javax.help.TextHelpModel;
import javax.help.TreeItem;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;
import javax.help.plaf.HelpUI;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JHelp
extends JComponent
implements HelpSetListener,
Accessible {
    protected TextHelpModel helpModel;
    protected HelpHistoryModel historyModel;
    protected Vector navigators;
    protected boolean navDisplayed = true;
    protected boolean toolbarDisplayed = true;
    protected HelpSet.Presentation hsPres;
    protected JHelpContentViewer contentViewer;
    private boolean debug = false;

    public JHelp(HelpSet hs) {
        this(new DefaultHelpModel(hs), null, hs == null ? null : hs.getDefaultPresentation());
    }

    public JHelp() {
        this((TextHelpModel)null);
    }

    public JHelp(TextHelpModel model) {
        this(model, null, null);
    }

    public JHelp(TextHelpModel model, HelpHistoryModel history, HelpSet.Presentation hsPres) {
        this.historyModel = history == null ? new DefaultHelpHistoryModel(this) : history;
        this.hsPres = hsPres;
        this.navigators = new Vector();
        this.navDisplayed = true;
        this.contentViewer = new JHelpContentViewer(model);
        this.setModel(model);
        if (model != null) {
            this.setupNavigators();
        }
        this.updateUI();
    }

    protected void setupNavigators() {
        HelpSet hs = this.helpModel.getHelpSet();
        if (hs == null) {
            return;
        }
        NavigatorView[] views = hs.getNavigatorViews();
        this.debug("views: " + views);
        for (int i = 0; i < views.length; ++i) {
            this.debug("  processing info: " + views[i]);
            JHelpNavigator nav = (JHelpNavigator)views[i].createNavigator(this.helpModel);
            if (nav == null) {
                this.debug("no JHelpNavigator for given info");
                continue;
            }
            this.debug("  adding the navigator");
            this.navigators.addElement(nav);
        }
    }

    public void setModel(TextHelpModel newModel) {
        TextHelpModel oldModel = this.helpModel;
        if (newModel != oldModel) {
            HelpSet hs;
            if (oldModel != null) {
                oldModel.getHelpSet().removeHelpSetListener(this);
            }
            this.helpModel = newModel;
            if (newModel != null && (hs = newModel.getHelpSet()) != null) {
                hs.addHelpSetListener(this);
            }
            this.firePropertyChange("helpModel", oldModel, this.helpModel);
            this.contentViewer.setModel(newModel);
            this.getHistoryModel().setHelpModel(newModel);
            HelpUI help = this.getUI();
            if (help == null) {
                return;
            }
            Enumeration e = this.getHelpNavigators();
            while (e.hasMoreElements()) {
                JHelpNavigator nav = (JHelpNavigator)e.nextElement();
                help.removeNavigator(nav);
            }
            this.navigators.removeAllElements();
            if (this.helpModel != null) {
                this.setupNavigators();
            }
            this.updateUI();
        }
    }

    public TextHelpModel getModel() {
        return this.helpModel;
    }

    public HelpHistoryModel getHistoryModel() {
        return this.historyModel;
    }

    public void setHelpSetPresentation(HelpSet.Presentation hsPres) {
        this.hsPres = hsPres;
    }

    public HelpSet.Presentation getHelpSetPresentation() {
        return this.hsPres;
    }

    public void setHelpSetSpec(String spec) {
        HelpSet hs;
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            URL url = new URL(spec);
            hs = new HelpSet(loader, url);
        }
        catch (Exception ex) {
            System.err.println("Trouble setting HelpSetSpec to spec |" + spec + "|");
            System.err.println("  ex: " + ex);
            hs = null;
        }
        this.contentViewer.setModel(new DefaultHelpModel(hs));
        this.setModel(this.contentViewer.getModel());
        this.updateUI();
    }

    public URL getHelpSetURL() {
        HelpSet hs = this.contentViewer.getModel().getHelpSet();
        if (hs == null) {
            return null;
        }
        return hs.getHelpSetURL();
    }

    public void setUI(HelpUI ui) {
        if ((HelpUI)this.ui != ui) {
            super.setUI(ui);
        }
    }

    public HelpUI getUI() {
        return (HelpUI)this.ui;
    }

    public void updateUI() {
        SwingHelpUtilities.installUIDefaults();
        this.setUI((HelpUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "HelpUI";
    }

    private JHelpNavigator findNavigator(String name) {
        this.debug("findNavigator(" + name + ")");
        Enumeration e = this.getHelpNavigators();
        while (e.hasMoreElements()) {
            JHelpNavigator nav = (JHelpNavigator)e.nextElement();
            this.debug("  nav: " + nav);
            this.debug("  nav.getName: " + nav.getNavigatorName());
            if (!nav.getNavigatorName().equals(name)) continue;
            return nav;
        }
        return null;
    }

    public void helpSetAdded(HelpSetEvent e) {
        this.debug("helpSetAdded(" + e + ")");
        HelpSet ehs = e.getHelpSet();
        this.addHelpSet(ehs);
    }

    private void addHelpSet(HelpSet ehs) {
        this.debug("helpset :" + ehs);
        NavigatorView[] eviews = ehs.getNavigatorViews();
        int count = 0;
        Enumeration e = this.getHelpNavigators();
        while (e.hasMoreElements()) {
            ++count;
            e.nextElement();
        }
        if (count == 0) {
            this.debug("master helpset without navigators");
            DefaultHelpModel newModel = new DefaultHelpModel(ehs);
            this.setModel(newModel);
            this.setupNavigators();
            return;
        }
        for (int i = 0; i < eviews.length; ++i) {
            String n = eviews[i].getName();
            this.debug("addHelpSet: looking for navigator for " + n);
            JHelpNavigator nav = this.findNavigator(n);
            if (nav != null) {
                this.debug("   found");
                if (nav.canMerge(eviews[i])) {
                    this.debug("  canMerge: true; merging...");
                    nav.merge(eviews[i]);
                    continue;
                }
                this.debug("  canMerge: false");
                continue;
            }
            this.debug("   not found");
        }
    }

    public void helpSetRemoved(HelpSetEvent e) {
        this.debug("helpSetRemoved(" + e + ")");
        HelpSet ehs = e.getHelpSet();
        this.removeHelpSet(ehs);
    }

    private void removeHelpSet(HelpSet ehs) {
        NavigatorView[] eviews = ehs.getNavigatorViews();
        for (int i = 0; i < eviews.length; ++i) {
            String n = eviews[i].getName();
            this.debug("removeHelpSet: looking for navigator for " + n);
            JHelpNavigator nav = this.findNavigator(n);
            if (nav != null) {
                this.debug("   found");
                if (nav.canMerge(eviews[i])) {
                    this.debug("  canMerge: true; removing...");
                    nav.remove(eviews[i]);
                    continue;
                }
                this.debug("  canMerge: false");
                continue;
            }
            this.debug("   not found");
        }
        this.getHistoryModel().removeHelpSet(ehs);
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        if (this.helpModel != null) {
            this.helpModel.setCurrentID(id);
        }
    }

    public void setCurrentID(Map.ID id, String historyName, JHelpNavigator navigator) throws InvalidHelpSetContextException {
        if (this.helpModel != null) {
            this.helpModel.setCurrentID(id, historyName, navigator);
        }
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.helpModel.setCurrentID(Map.ID.create(id, this.getModel().getHelpSet()));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            // empty catch block
        }
    }

    public void setCurrentURL(URL url) {
        this.helpModel.setCurrentURL(url);
    }

    public void setCurrentURL(URL url, String historyName, JHelpNavigator navigator) {
        this.helpModel.setCurrentURL(url, historyName, navigator);
    }

    public TreeItem[] getSelectedItems() {
        return this.getCurrentNavigator().getSelectedItems();
    }

    public void addHelpNavigator(JHelpNavigator navigator) {
        this.debug("addHelpNavigator(" + navigator + ")");
        this.navigators.addElement(navigator);
        HelpUI help = this.getUI();
        help.addNavigator(navigator);
        navigator.setModel(this.getModel());
    }

    public void removeHelpNavigator(JHelpNavigator navigator) {
        this.debug("removeHelpNavigator(" + navigator + ")");
        if (navigator == null) {
            throw new NullPointerException("navigator");
        }
        this.navigators.removeElement(navigator);
        HelpUI help = this.getUI();
        help.removeNavigator(navigator);
    }

    public Enumeration getHelpNavigators() {
        return this.navigators.elements();
    }

    public void setCurrentNavigator(JHelpNavigator navigator) {
        HelpUI help = this.getUI();
        help.setCurrentNavigator(navigator);
    }

    public JHelpNavigator getCurrentNavigator() {
        HelpUI help = this.getUI();
        return help.getCurrentNavigator();
    }

    public void setNavigatorDisplayed(boolean displayed) {
        if (this.navDisplayed != displayed) {
            this.navDisplayed = displayed;
            this.firePropertyChange("navigatorDisplayed", !displayed, displayed);
        }
    }

    public boolean isNavigatorDisplayed() {
        return this.navDisplayed;
    }

    public void setToolbarDisplayed(boolean displayed) {
        if (this.toolbarDisplayed != displayed) {
            this.toolbarDisplayed = displayed;
            this.firePropertyChange("toolbarDisplayed", !displayed, displayed);
        }
    }

    public boolean isToolbarDisplayed() {
        return this.toolbarDisplayed;
    }

    public JHelpContentViewer getContentViewer() {
        return this.contentViewer;
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("JHelp: " + msg);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJHelp();
        }
        return this.accessibleContext;
    }

    static {
        SwingHelpUtilities.installLookAndFeelDefaults();
    }

    protected class AccessibleJHelp
    extends JComponent.AccessibleJComponent {
        protected AccessibleJHelp() {
            super(JHelp.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

