/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.help.HelpUtilities;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class SwingHelpUtilities
implements PropertyChangeListener {
    private static UIDefaults uiDefaults = null;
    private static SwingHelpUtilities myLAFListener = new SwingHelpUtilities();
    private static String contentViewerUI = null;
    static Object basicOnItemCursor;
    static Object basicDnDCursor;
    static Object gtkOnItemCursor;
    static Object gtkDnDCursor;
    private static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicHelpUI;
    static /* synthetic */ Class class$javax$help$plaf$gtk$GTKCursorFactory;

    public void propertyChange(PropertyChangeEvent event) {
        String changeName = event.getPropertyName();
        if (changeName.equals("lookAndFeel")) {
            SwingHelpUtilities.installLookAndFeelDefaults();
        }
    }

    static void installUIDefaults() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        if (uiDefaults != table) {
            uiDefaults = table;
            UIManager.removePropertyChangeListener(myLAFListener);
            SwingHelpUtilities.installLookAndFeelDefaults();
            UIManager.addPropertyChangeListener(myLAFListener);
        }
    }

    public static void setContentViewerUI(String cvUI) {
        if (cvUI != null) {
            try {
                Class<?> c = Class.forName(cvUI);
                contentViewerUI = cvUI;
            }
            catch (Throwable e) {
                System.out.println("ContentViewerClass " + cvUI + " doesn't exist");
            }
        }
    }

    static void installLookAndFeelDefaults() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        SwingHelpUtilities.debug("installLookAndFeelDefaults - " + lnf);
        if (lnf != null && table != null) {
            if (lnf.getID().equals("Motif")) {
                SwingHelpUtilities.installMotifDefaults(table);
            } else if (lnf.getID().equals("Windows")) {
                SwingHelpUtilities.installWindowsDefaults(table);
            } else if (lnf.getID().equals("GTK")) {
                SwingHelpUtilities.installGTKDefaults(table);
            } else {
                SwingHelpUtilities.installMetalDefaults(table);
            }
        }
        SwingHelpUtilities.debug("verifing UIDefaults; HelpUI=" + (table == null ? "null" : table.getString("HelpUI")));
    }

    private static Object createIcon(String factoryName, String method) {
        ClassLoader loader = HelpUtilities.class.getClassLoader();
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Class<?> klass = loader == null ? Class.forName(factoryName) : loader.loadClass(factoryName);
            Method m = klass.getMethod(method, types);
            Object back = m.invoke(null, args);
            return back;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Object makeBasicIcon(final String image) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.getImageIcon(class$javax$help$plaf$basic$BasicHelpUI == null ? (class$javax$help$plaf$basic$BasicHelpUI = SwingHelpUtilities.class$("javax.help.plaf.basic.BasicHelpUI")) : class$javax$help$plaf$basic$BasicHelpUI, image);
            }
        };
    }

    private static void installBasicDefaults(UIDefaults table) {
        String basicPackageName = "javax.help.plaf.basic.";
        String basicContentViewerUI = basicPackageName + "BasicContentViewerUI";
        if (contentViewerUI != null) {
            basicContentViewerUI = contentViewerUI;
        }
        Object[] uiDefaults = new Object[]{"HelpUI", basicPackageName + "BasicHelpUI", "HelpTOCNavigatorUI", basicPackageName + "BasicTOCNavigatorUI", "HelpIndexNavigatorUI", basicPackageName + "BasicIndexNavigatorUI", "HelpSearchNavigatorUI", basicPackageName + "BasicSearchNavigatorUI", "HelpGlossaryNavigatorUI", basicPackageName + "BasicGlossaryNavigatorUI", "HelpFavoritesNavigatorUI", basicPackageName + "BasicFavoritesNavigatorUI", "HelpContentViewerUI", basicContentViewerUI, "HelpDnDCursor", basicDnDCursor, "HelpOnItemCursor", basicOnItemCursor, "BackAction.icon", SwingHelpUtilities.makeBasicIcon("images/Back.gif"), "ForwardAction.icon", SwingHelpUtilities.makeBasicIcon("images/Forward.gif"), "PrintAction.icon", SwingHelpUtilities.makeBasicIcon("images/Print.gif"), "PrintSetupAction.icon", SwingHelpUtilities.makeBasicIcon("images/PrintSetup.gif"), "ReloadAction.icon", SwingHelpUtilities.makeBasicIcon("images/Reload.gif"), "FavoritesAction.icon", SwingHelpUtilities.makeBasicIcon("images/Favorites.gif"), "HomeAction.icon", SwingHelpUtilities.makeBasicIcon("images/Home.gif"), "FavoritesNav.icon", SwingHelpUtilities.makeBasicIcon("images/FavoritesNav.gif"), "IndexNav.icon", SwingHelpUtilities.makeBasicIcon("images/IndexNav.gif"), "TOCNav.icon", SwingHelpUtilities.makeBasicIcon("images/TOCNav.gif"), "SearchNav.icon", SwingHelpUtilities.makeBasicIcon("images/SearchNav.gif"), "GlossaryNav.icon", SwingHelpUtilities.makeBasicIcon("images/GlossaryNav.gif"), "HistoryNav.icon", SwingHelpUtilities.makeBasicIcon("images/HistoryNav.gif"), "SearchLow.icon", SwingHelpUtilities.makeBasicIcon("images/SearchLow.gif"), "SearchMedLow.icon", SwingHelpUtilities.makeBasicIcon("images/SearchMedLow.gif"), "SearchMed.icon", SwingHelpUtilities.makeBasicIcon("images/SearchMed.gif"), "SearchMedHigh.icon", SwingHelpUtilities.makeBasicIcon("images/SearchMedHigh.gif"), "SearchHigh.icon", SwingHelpUtilities.makeBasicIcon("images/SearchHigh.gif")};
        table.putDefaults(uiDefaults);
    }

    private static void installMetalDefaults(UIDefaults table) {
        SwingHelpUtilities.installBasicDefaults(table);
    }

    private static void installWindowsDefaults(UIDefaults table) {
        SwingHelpUtilities.installBasicDefaults(table);
    }

    private static void installMotifDefaults(UIDefaults table) {
        SwingHelpUtilities.installBasicDefaults(table);
    }

    private static Object makeGTKIcon(final String image) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.getImageIcon(class$javax$help$plaf$gtk$GTKCursorFactory == null ? (class$javax$help$plaf$gtk$GTKCursorFactory = SwingHelpUtilities.class$("javax.help.plaf.gtk.GTKCursorFactory")) : class$javax$help$plaf$gtk$GTKCursorFactory, image);
            }
        };
    }

    private static void installGTKDefaults(UIDefaults table) {
        String basicPackageName = "javax.help.plaf.basic.";
        String gtkPackageName = "javax.help.plaf.gtk.";
        String basicContentViewerUI = basicPackageName + "BasicContentViewerUI";
        if (contentViewerUI != null) {
            basicContentViewerUI = contentViewerUI;
        }
        Object[] uiDefaults = new Object[]{"HelpUI", basicPackageName + "BasicHelpUI", "HelpTOCNavigatorUI", basicPackageName + "BasicTOCNavigatorUI", "HelpIndexNavigatorUI", basicPackageName + "BasicIndexNavigatorUI", "HelpSearchNavigatorUI", basicPackageName + "BasicSearchNavigatorUI", "HelpGlossaryNavigatorUI", basicPackageName + "BasicGlossaryNavigatorUI", "HelpFavoritesNavigatorUI", basicPackageName + "BasicFavoritesNavigatorUI", "HelpContentViewerUI", basicContentViewerUI, "HelpDnDCursor", gtkDnDCursor, "HelpOnItemCursor", gtkOnItemCursor, "BackAction.icon", SwingHelpUtilities.makeGTKIcon("images/Back.png"), "ForwardAction.icon", SwingHelpUtilities.makeGTKIcon("images/Forward.png"), "PrintAction.icon", SwingHelpUtilities.makeGTKIcon("images/Print.png"), "PrintSetupAction.icon", SwingHelpUtilities.makeGTKIcon("images/PrintSetup.png"), "ReloadAction.icon", SwingHelpUtilities.makeGTKIcon("images/Reload.png"), "FavoritesAction.icon", SwingHelpUtilities.makeGTKIcon("images/Favorites.png"), "HomeAction.icon", SwingHelpUtilities.makeGTKIcon("images/Home.png"), "FavoritesNav.icon", SwingHelpUtilities.makeGTKIcon("images/FavoritesNav.png"), "IndexNav.icon", SwingHelpUtilities.makeGTKIcon("images/IndexNav.gif"), "TOCNav.icon", SwingHelpUtilities.makeGTKIcon("images/TOCNav.gif"), "SearchNav.icon", SwingHelpUtilities.makeGTKIcon("images/SearchNav.gif"), "GlossaryNav.icon", SwingHelpUtilities.makeGTKIcon("images/GlossaryNav.gif"), "HistoryNav.icon", SwingHelpUtilities.makeGTKIcon("images/HistoryNav.gif"), "SearchLow.icon", SwingHelpUtilities.makeGTKIcon("images/SearchLow.gif"), "SearchMedLow.icon", SwingHelpUtilities.makeGTKIcon("images/SearchMedLow.gif"), "SearchMed.icon", SwingHelpUtilities.makeGTKIcon("images/SearchMed.gif"), "SearchMedHigh.icon", SwingHelpUtilities.makeGTKIcon("images/SearchMedHigh.gif"), "SearchHigh.icon", SwingHelpUtilities.makeGTKIcon("images/SearchHigh.gif")};
        table.putDefaults(uiDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(Class baseClass, String image) {
        if (image == null) {
            return null;
        }
        byte[][] buffer = new byte[1][];
        try {
            InputStream resource = baseClass.getResourceAsStream(image);
            if (resource == null) {
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer[0] = new byte[1024];
            try {
                int n;
                while ((n = in.read(buffer[0])) > 0) {
                    out.write(buffer[0], 0, n);
                }
            }
            finally {
                in.close();
            }
            out.flush();
            buffer[0] = out.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return null;
        }
        if (buffer[0] == null) {
            System.err.println(baseClass.getName() + "/" + image + " not found.");
            return null;
        }
        if (buffer[0].length == 0) {
            System.err.println("warning: " + image + " is zero-length");
            return null;
        }
        return new ImageIcon(buffer[0]);
    }

    static void addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        try {
            Class[] types = new Class[]{PropertyChangeListener.class};
            Object[] args = new Object[]{listener};
            object.getClass().getMethod("addPropertyChangeListener", types).invoke(object, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debug(Object msg1) {
    }

    static {
        SwingHelpUtilities.installUIDefaults();
        basicOnItemCursor = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.createIcon("javax.help.plaf.basic.BasicCursorFactory", "getOnItemCursor");
            }
        };
        basicDnDCursor = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.createIcon("javax.help.plaf.basic.BasicCursorFactory", "getDnDCursor");
            }
        };
        gtkOnItemCursor = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.createIcon("javax.help.plaf.gtk.GTKCursorFactory", "getOnItemCursor");
            }
        };
        gtkDnDCursor = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SwingHelpUtilities.createIcon("javax.help.plaf.gtk.GTKCursorFactory", "getDnDCursor");
            }
        };
    }
}

