/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.PDFUtils;
import com.orsonpdf.Page;
import com.orsonpdf.Stream;
import com.orsonpdf.util.Args;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

public class GraphicsStream
extends Stream {
    private Page page;
    private ByteArrayOutputStream content;
    private Font font;
    private AffineTransform prevTransInv;
    private DecimalFormat geometryFormat = new DecimalFormat("0.##");
    private DecimalFormat transformFormat = new DecimalFormat("0.######");

    GraphicsStream(int number, Page page) {
        super(number);
        this.page = page;
        this.content = new ByteArrayOutputStream();
        this.font = new Font("Dialog", 0, 12);
    }

    private void addContent(String s) {
        try {
            this.content.write(PDFUtils.toBytes(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void pushGraphicsState() {
        this.addContent("q\n");
    }

    void popGraphicsState() {
        this.addContent("Q\n");
    }

    void applyTransform(AffineTransform t) {
        StringBuilder b = new StringBuilder();
        b.append(this.transformDP(t.getScaleX())).append(" ");
        b.append(this.transformDP(t.getShearY())).append(" ");
        b.append(this.transformDP(t.getShearX())).append(" ");
        b.append(this.transformDP(t.getScaleY())).append(" ");
        b.append(this.transformDP(t.getTranslateX())).append(" ");
        b.append(this.transformDP(t.getTranslateY())).append(" cm\n");
        this.addContent(b.toString());
    }

    void setTransform(AffineTransform t) {
        AffineTransform tt = new AffineTransform(t);
        try {
            AffineTransform comb;
            AffineTransform inv = tt.createInverse();
            if (this.prevTransInv != null) {
                comb = new AffineTransform(this.prevTransInv);
                comb.concatenate(tt);
            } else {
                comb = tt;
            }
            this.prevTransInv = inv;
            this.applyTransform(comb);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    void applyTextTransform(AffineTransform t) {
        StringBuilder b = new StringBuilder();
        b.append(t.getScaleX()).append(" ");
        b.append(t.getShearY()).append(" ");
        b.append(t.getShearX()).append(" ");
        b.append(t.getScaleY()).append(" ");
        b.append(t.getTranslateX()).append(" ");
        b.append(t.getTranslateY()).append(" Tm\n");
        this.addContent(b.toString());
    }

    void applyClip(Shape clip) {
        Args.nullNotPermitted(clip, "clip");
        StringBuilder b = new StringBuilder();
        Path2D.Double p = new Path2D.Double(clip);
        b.append(this.getPDFPath(p));
        b.append("W n\n");
        this.addContent(b.toString());
    }

    void applyStroke(Stroke s) {
        if (!(s instanceof BasicStroke)) {
            return;
        }
        BasicStroke bs = (BasicStroke)s;
        StringBuilder b = new StringBuilder();
        b.append(bs.getLineWidth()).append(" ").append("w\n");
        b.append(bs.getEndCap()).append(" J\n");
        b.append(bs.getLineJoin()).append(" j\n");
        float[] dashArray = bs.getDashArray();
        if (dashArray != null) {
            b.append(PDFUtils.toPDFArray(dashArray)).append(" 0 d\n");
        } else {
            b.append("[] 0 d\n");
        }
        this.addContent(b.toString());
    }

    void applyStrokeColor(Color c) {
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        StringBuilder b = new StringBuilder();
        b.append(red).append(" ").append(green).append(" ").append(blue).append(" RG\n");
        this.addContent(b.toString());
    }

    void applyFillColor(Color c) {
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        StringBuilder b = new StringBuilder();
        b.append(red).append(" ").append(green).append(" ").append(blue).append(" rg\n");
        this.addContent(b.toString());
    }

    void applyStrokeGradient(GradientPaint gp) {
        String patternName = this.page.findOrCreatePattern(gp);
        StringBuilder b = new StringBuilder("/Pattern CS\n");
        b.append(patternName).append(" SCN\n");
        this.addContent(b.toString());
    }

    void applyStrokeGradient(RadialGradientPaint rgp) {
        String patternName = this.page.findOrCreatePattern(rgp);
        StringBuilder b = new StringBuilder("/Pattern CS\n");
        b.append(patternName).append(" SCN\n");
        this.addContent(b.toString());
    }

    void applyFillGradient(GradientPaint gp) {
        String patternName = this.page.findOrCreatePattern(gp);
        StringBuilder b = new StringBuilder("/Pattern cs\n");
        b.append(patternName).append(" scn\n");
        this.addContent(b.toString());
    }

    void applyFillGradient(RadialGradientPaint rgp) {
        String patternName = this.page.findOrCreatePattern(rgp);
        StringBuilder b = new StringBuilder("/Pattern cs\n");
        b.append(patternName).append(" scn\n");
        this.addContent(b.toString());
    }

    void applyComposite(AlphaComposite alphaComp) {
        String name = this.page.findOrCreateGSDictionary(alphaComp);
        StringBuilder b = new StringBuilder();
        b.append(name).append(" gs\n");
        this.addContent(b.toString());
    }

    private String geomDP(double d) {
        if (this.geometryFormat != null) {
            return this.geometryFormat.format(d);
        }
        return String.valueOf(d);
    }

    private String transformDP(double d) {
        if (this.transformFormat != null) {
            return this.transformFormat.format(d);
        }
        return String.valueOf(d);
    }

    void drawLine(Line2D line) {
        StringBuilder b = new StringBuilder();
        b.append(this.geomDP(line.getX1())).append(" ").append(this.geomDP(line.getY1())).append(" ").append("m\n");
        b.append(this.geomDP(line.getX2())).append(" ").append(this.geomDP(line.getY2())).append(" ").append("l\n");
        b.append("S\n");
        this.addContent(b.toString());
    }

    void drawPath2D(Path2D path) {
        StringBuilder b = new StringBuilder();
        b.append(this.getPDFPath(path)).append("S\n");
        this.addContent(b.toString());
    }

    void fillPath2D(Path2D path) {
        StringBuilder b = new StringBuilder();
        b.append(this.getPDFPath(path)).append("f\n");
        this.addContent(b.toString());
    }

    void applyFont(Font font) {
        this.font = font;
    }

    void drawString(String text, float x, float y) {
        String fontRef = this.page.findOrCreateFontReference(this.font);
        this.addContent("BT ");
        AffineTransform t = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(y * 2.0f));
        this.applyTextTransform(t);
        StringBuilder b = new StringBuilder();
        b.append(fontRef).append(" ").append(this.font.getSize()).append(" Tf ");
        b.append(this.geomDP(x)).append(" ").append(this.geomDP(y)).append(" Td (").append(text).append(") Tj ET\n");
        this.addContent(b.toString());
    }

    void drawImage(Image img, int x, int y, int w, int h) {
        String imageRef = this.page.addImage(img);
        StringBuilder b = new StringBuilder();
        b.append("q\n");
        b.append(this.geomDP(w)).append(" 0 0 ").append(this.geomDP(h)).append(" ");
        b.append(this.geomDP(x)).append(" ").append(this.geomDP(y)).append(" cm\n");
        b.append(imageRef).append(" Do\n");
        b.append("Q\n");
        this.addContent(b.toString());
    }

    private String getPDFPath(Path2D path) {
        StringBuilder b = new StringBuilder();
        float[] coords = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    b.append(this.geomDP(coords[0])).append(" ");
                    b.append(this.geomDP(coords[1])).append(" m\n");
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 1: {
                    b.append(this.geomDP(coords[0])).append(" ");
                    b.append(this.geomDP(coords[1])).append(" l\n");
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 2: {
                    float x0 = 0.25f * lastX + 0.75f * coords[0];
                    float y0 = 0.25f * lastY + 0.75f * coords[1];
                    float x1 = 0.5f * coords[0] + 0.5f * coords[2];
                    float y1 = 0.5f * coords[1] + 0.5f * coords[3];
                    b.append(this.geomDP(x0)).append(" ");
                    b.append(this.geomDP(y0)).append(" ");
                    b.append(this.geomDP(x1)).append(" ");
                    b.append(this.geomDP(y1)).append(" ");
                    b.append(this.geomDP(coords[2])).append(" ");
                    b.append(this.geomDP(coords[3])).append(" c\n");
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 3: {
                    b.append(this.geomDP(coords[0])).append(" ");
                    b.append(this.geomDP(coords[1])).append(" ");
                    b.append(this.geomDP(coords[2])).append(" ");
                    b.append(this.geomDP(coords[3])).append(" ");
                    b.append(this.geomDP(coords[4])).append(" ");
                    b.append(this.geomDP(coords[5])).append(" c\n");
                    lastX = coords[4];
                    lastY = coords[5];
                    break;
                }
                case 4: {
                    b.append("h\n");
                    break;
                }
            }
            iterator.next();
        }
        return b.toString();
    }

    @Override
    public byte[] getRawStreamData() {
        return this.content.toByteArray();
    }
}

