/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class DefaultPolarItemRenderer
extends AbstractRenderer
implements PolarItemRenderer {
    private PolarPlot plot;
    private BooleanList seriesFilled = new BooleanList();
    private boolean drawOutlineWhenFilled = true;
    private transient Composite fillComposite = AlphaComposite.getInstance(3, 0.3f);
    private boolean useFillPaint = false;
    private transient Shape legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
    private boolean shapesVisible = true;
    private boolean connectFirstAndLastPoint = true;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private XYSeriesLabelGenerator legendItemToolTipGenerator = null;
    private XYSeriesLabelGenerator legendItemURLGenerator = null;

    @Override
    public void setPlot(PolarPlot plot) {
        this.plot = plot;
    }

    @Override
    public PolarPlot getPlot() {
        return this.plot;
    }

    public boolean getDrawOutlineWhenFilled() {
        return this.drawOutlineWhenFilled;
    }

    public void setDrawOutlineWhenFilled(boolean drawOutlineWhenFilled) {
        this.drawOutlineWhenFilled = drawOutlineWhenFilled;
        this.fireChangeEvent();
    }

    public Composite getFillComposite() {
        return this.fillComposite;
    }

    public void setFillComposite(Composite composite) {
        ParamChecks.nullNotPermitted(composite, "composite");
        this.fillComposite = composite;
        this.fireChangeEvent();
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean visible) {
        this.shapesVisible = visible;
        this.fireChangeEvent();
    }

    public boolean getConnectFirstAndLastPoint() {
        return this.connectFirstAndLastPoint;
    }

    public void setConnectFirstAndLastPoint(boolean connect) {
        this.connectFirstAndLastPoint = connect;
        this.fireChangeEvent();
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        PolarPlot p = this.getPlot();
        if (p != null) {
            result = p.getDrawingSupplier();
        }
        return result;
    }

    public boolean isSeriesFilled(int series) {
        boolean result = false;
        Boolean b = this.seriesFilled.getBoolean(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public void setSeriesFilled(int series, boolean filled) {
        this.seriesFilled.setBoolean(series, BooleanUtilities.valueOf((boolean)filled));
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean flag) {
        this.useFillPaint = flag;
        this.fireChangeEvent();
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape line) {
        ParamChecks.nullNotPermitted(line, "line");
        this.legendLine = line;
        this.fireChangeEvent();
    }

    protected void addEntity(EntityCollection entities, Shape area, XYDataset dataset, int series, int item, double entityX, double entityY) {
        if (!this.getItemCreateEntity(series, item)) {
            return;
        }
        Shape hotspot = area;
        if (hotspot == null) {
            double r = this.getDefaultEntityRadius();
            double w = r * 2.0;
            hotspot = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(entityX - r, entityY - r, w, w) : new Ellipse2D.Double(entityY - r, entityX - r, w, w);
        }
        String tip = null;
        XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
        if (generator != null) {
            tip = generator.generateToolTip(dataset, series, item);
        }
        String url = null;
        if (this.getURLGenerator() != null) {
            url = this.getURLGenerator().generateURL(dataset, series, item);
        }
        XYItemEntity entity = new XYItemEntity(hotspot, dataset, series, item, tip, url);
        entities.add(entity);
    }

    @Override
    public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
        int numPoints = dataset.getItemCount(seriesIndex);
        if (numPoints == 0) {
            return;
        }
        Path2D poly = null;
        ValueAxis axis = plot.getAxisForDataset(plot.indexOf(dataset));
        for (int i = 0; i < numPoints; ++i) {
            double theta = dataset.getXValue(seriesIndex, i);
            double radius = dataset.getYValue(seriesIndex, i);
            Point p = plot.translateToJava2D(theta, radius, axis, dataArea);
            if (poly == null) {
                poly = new GeneralPath();
                ((Path2D.Float)poly).moveTo(p.x, p.y);
                continue;
            }
            ((Path2D.Float)poly).lineTo(p.x, p.y);
        }
        assert (poly != null);
        if (this.getConnectFirstAndLastPoint()) {
            poly.closePath();
        }
        g2.setPaint(this.lookupSeriesPaint(seriesIndex));
        g2.setStroke(this.lookupSeriesStroke(seriesIndex));
        if (this.isSeriesFilled(seriesIndex)) {
            Composite savedComposite = g2.getComposite();
            g2.setComposite(this.fillComposite);
            g2.fill(poly);
            g2.setComposite(savedComposite);
            if (this.drawOutlineWhenFilled) {
                g2.setPaint(this.lookupSeriesOutlinePaint(seriesIndex));
                g2.draw(poly);
            }
        } else {
            g2.draw(poly);
        }
        if (this.shapesVisible) {
            EntityCollection entities = null;
            if (info != null) {
                entities = info.getOwner().getEntityCollection();
            }
            PathIterator pi = ((Path2D.Float)poly).getPathIterator(null);
            int i = 0;
            while (!pi.isDone()) {
                float[] coords = new float[6];
                int segType = pi.currentSegment(coords);
                pi.next();
                if (segType != 1 && segType != 0) continue;
                int x = Math.round(coords[0]);
                int y = Math.round(coords[1]);
                Shape shape = ShapeUtilities.createTranslatedShape((Shape)this.getItemShape(seriesIndex, i++), (double)x, (double)y);
                Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(seriesIndex) : this.lookupSeriesPaint(seriesIndex);
                g2.setPaint(paint);
                g2.fill(shape);
                if (this.isSeriesFilled(seriesIndex) && this.drawOutlineWhenFilled) {
                    g2.setPaint(this.lookupSeriesOutlinePaint(seriesIndex));
                    g2.setStroke(this.lookupSeriesOutlineStroke(seriesIndex));
                    g2.draw(shape);
                }
                if (entities == null || !AbstractXYItemRenderer.isPointInRect(dataArea, x, y)) continue;
                this.addEntity(entities, shape, dataset, seriesIndex, i - 1, x, y);
            }
        }
    }

    @Override
    public void drawAngularGridLines(Graphics2D g2, PolarPlot plot, List ticks, Rectangle2D dataArea) {
        g2.setFont(plot.getAngleLabelFont());
        g2.setStroke(plot.getAngleGridlineStroke());
        g2.setPaint(plot.getAngleGridlinePaint());
        ValueAxis axis = plot.getAxis();
        double centerValue = 0.0;
        double outerValue = 0.0;
        if (axis != null) {
            if (axis.isInverted()) {
                outerValue = axis.getLowerBound();
                centerValue = axis.getUpperBound();
            } else {
                outerValue = axis.getUpperBound();
                centerValue = axis.getLowerBound();
            }
        }
        Point center = plot.translateToJava2D(0.0, centerValue, axis, dataArea);
        for (NumberTick tick : ticks) {
            double tickVal = tick.getNumber().doubleValue();
            Point p = plot.translateToJava2D(tickVal, outerValue, axis, dataArea);
            g2.setPaint(plot.getAngleGridlinePaint());
            g2.drawLine(center.x, center.y, p.x, p.y);
            if (!plot.isAngleLabelsVisible()) continue;
            int x = p.x;
            int y = p.y;
            g2.setPaint(plot.getAngleLabelPaint());
            TextUtilities.drawAlignedString((String)tick.getText(), (Graphics2D)g2, (float)x, (float)y, (TextAnchor)tick.getTextAnchor());
        }
    }

    @Override
    public void drawRadialGridLines(Graphics2D g2, PolarPlot plot, ValueAxis radialAxis, List ticks, Rectangle2D dataArea) {
        ParamChecks.nullNotPermitted(radialAxis, "radialAxis");
        g2.setFont(radialAxis.getTickLabelFont());
        g2.setPaint(plot.getRadiusGridlinePaint());
        g2.setStroke(plot.getRadiusGridlineStroke());
        double centerValue = radialAxis.isInverted() ? radialAxis.getUpperBound() : radialAxis.getLowerBound();
        Point center = plot.translateToJava2D(0.0, centerValue, radialAxis, dataArea);
        for (NumberTick tick : ticks) {
            double angleDegrees = plot.isCounterClockwise() ? plot.getAngleOffset() : -plot.getAngleOffset();
            Point p = plot.translateToJava2D(angleDegrees, tick.getNumber().doubleValue(), radialAxis, dataArea);
            int r = p.x - center.x;
            int upperLeftX = center.x - r;
            int upperLeftY = center.y - r;
            int d = 2 * r;
            Ellipse2D.Double ring = new Ellipse2D.Double(upperLeftX, upperLeftY, d, d);
            g2.setPaint(plot.getRadiusGridlinePaint());
            g2.draw(ring);
        }
    }

    @Override
    public LegendItem getLegendItem(int series) {
        String label;
        PolarPlot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        XYDataset dataset = plot.getDataset(plot.getIndexOf(this));
        if (dataset == null) {
            return null;
        }
        String toolTipText = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            toolTipText = this.getLegendItemToolTipGenerator().generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.getLegendItemURLGenerator() != null) {
            urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
        }
        Comparable seriesKey = dataset.getSeriesKey(series);
        String description = label = seriesKey.toString();
        Shape shape = this.lookupSeriesShape(series);
        Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(series) : this.lookupSeriesPaint(series);
        Stroke stroke = this.lookupSeriesStroke(series);
        Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
        Stroke outlineStroke = this.lookupSeriesOutlineStroke(series);
        boolean shapeOutlined = this.isSeriesFilled(series) && this.drawOutlineWhenFilled;
        LegendItem result = new LegendItem(label, description, toolTipText, urlText, this.getShapesVisible(), shape, true, paint, shapeOutlined, outlinePaint, outlineStroke, true, this.legendLine, stroke, paint);
        result.setToolTipText(toolTipText);
        result.setURLText(urlText);
        result.setDataset(dataset);
        result.setSeriesKey(seriesKey);
        result.setSeriesIndex(series);
        return result;
    }

    @Override
    public XYToolTipGenerator getToolTipGenerator(int series, int item) {
        XYToolTipGenerator generator = (XYToolTipGenerator)this.toolTipGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseToolTipGenerator;
        }
        return generator;
    }

    @Override
    public XYToolTipGenerator getSeriesToolTipGenerator(int series) {
        return (XYToolTipGenerator)this.toolTipGeneratorList.get(series);
    }

    @Override
    public void setSeriesToolTipGenerator(int series, XYToolTipGenerator generator) {
        this.toolTipGeneratorList.set(series, (Object)generator);
        this.fireChangeEvent();
    }

    @Override
    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    @Override
    public void setBaseToolTipGenerator(XYToolTipGenerator generator) {
        this.baseToolTipGenerator = generator;
        this.fireChangeEvent();
    }

    @Override
    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    @Override
    public void setURLGenerator(XYURLGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator generator) {
        this.legendItemToolTipGenerator = generator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator generator) {
        this.legendItemURLGenerator = generator;
        this.fireChangeEvent();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPolarItemRenderer)) {
            return false;
        }
        DefaultPolarItemRenderer that = (DefaultPolarItemRenderer)obj;
        if (!this.seriesFilled.equals((Object)that.seriesFilled)) {
            return false;
        }
        if (this.drawOutlineWhenFilled != that.drawOutlineWhenFilled) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.fillComposite, (Object)that.fillComposite)) {
            return false;
        }
        if (this.useFillPaint != that.useFillPaint) {
            return false;
        }
        if (!ShapeUtilities.equal((Shape)this.legendLine, (Shape)that.legendLine)) {
            return false;
        }
        if (this.shapesVisible != that.shapesVisible) {
            return false;
        }
        if (this.connectFirstAndLastPoint != that.connectFirstAndLastPoint) {
            return false;
        }
        if (!this.toolTipGeneratorList.equals((Object)that.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.baseToolTipGenerator, (Object)that.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.urlGenerator, (Object)that.urlGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.legendItemToolTipGenerator, (Object)that.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.legendItemURLGenerator, (Object)that.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultPolarItemRenderer clone = (DefaultPolarItemRenderer)super.clone();
        if (this.legendLine != null) {
            clone.legendLine = ShapeUtilities.clone((Shape)this.legendLine);
        }
        clone.seriesFilled = (BooleanList)this.seriesFilled.clone();
        clone.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        if (clone.baseToolTipGenerator instanceof PublicCloneable) {
            clone.baseToolTipGenerator = (XYToolTipGenerator)ObjectUtilities.clone((Object)this.baseToolTipGenerator);
        }
        if (clone.urlGenerator instanceof PublicCloneable) {
            clone.urlGenerator = (XYURLGenerator)ObjectUtilities.clone((Object)this.urlGenerator);
        }
        if (clone.legendItemToolTipGenerator instanceof PublicCloneable) {
            clone.legendItemToolTipGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone((Object)this.legendItemToolTipGenerator);
        }
        if (clone.legendItemURLGenerator instanceof PublicCloneable) {
            clone.legendItemURLGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone((Object)this.legendItemURLGenerator);
        }
        return clone;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape((ObjectInputStream)stream);
        this.fillComposite = SerialUtilities.readComposite((ObjectInputStream)stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.legendLine, (ObjectOutputStream)stream);
        SerialUtilities.writeComposite((Composite)this.fillComposite, (ObjectOutputStream)stream);
    }
}

