/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.DocumentParser;

class ScanBuffer {
    char[] buf;
    int buflen;
    int scale = 2;

    ScanBuffer() {
        this.buf = new char[256];
    }

    ScanBuffer(int l, int s) {
        this.buf = new char[l];
        this.scale = s;
    }

    protected void clear() {
        this.buflen = 0;
    }

    protected void reset(int offset) {
        this.buflen = offset;
    }

    protected void flush(DocumentParser owner) {
        if (this.buflen > 0) {
            owner.callFlush(this.buf, 0, this.buflen);
            this.buflen = 0;
        }
    }

    protected void add(char c) {
        if (this.buflen >= this.buf.length) {
            char[] x = new char[this.buf.length * this.scale];
            System.arraycopy(this.buf, 0, x, 0, this.buf.length);
            this.buf = x;
        }
        this.buf[this.buflen++] = c;
    }

    protected int length() {
        return this.buflen;
    }

    public String toString() {
        return "ScanBuffer, buf = " + this.buf + ", buflen = " + this.buflen;
    }

    protected String extract(int offset) {
        return new String(this.buf, offset, this.buflen - offset);
    }
}

