/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.HitStoreNode;
import com.sun.java.help.search.QueryHit;
import java.util.Vector;

class HitStore {
    private static final int ArraySize = 128;
    private static final int DefaultLimit = 300;
    private HitStoreNode _root = new HitStoreNode(128);
    private int _limit;
    private double _standard;
    private Vector _leaves = null;
    private HitStoreNode _current = null;

    public HitStore(double initialStandard) {
        this(initialStandard, 300);
    }

    public HitStore(double initialStandard, int limit) {
        this._limit = limit;
        this._standard = initialStandard;
    }

    public void addQueryHit(QueryHit hit) {
        if (this._root.add(hit)) {
            this.adapt();
        }
    }

    private HitStoreNode getNextNode() {
        if (this._leaves.size() > 0) {
            HitStoreNode node = (HitStoreNode)this._leaves.firstElement();
            this._leaves.removeElementAt(0);
            node.sort();
            return node;
        }
        return null;
    }

    public QueryHit firstBestQueryHit() {
        this._leaves = new Vector();
        this._root.gatherLeaves(this._leaves);
        this._current = this.getNextNode();
        return this._current == null ? null : this._current.getNextHit();
    }

    public QueryHit nextBestQueryHit() {
        if (this._current == null) {
            return null;
        }
        QueryHit result = this._current.getNextHit();
        if (result != null) {
            return result;
        }
        this._current = this.getNextNode();
        if (this._current != null) {
            return this._current.getNextHit();
        }
        return null;
    }

    double getCurrentStandard() {
        return this._standard;
    }

    private void adapt() {
        if (this._root.getCount() > this._limit && !this._root.isLeaf()) {
            HitStoreNode ptr = this._root;
            while (!ptr.getRChild().isLeaf()) {
                ptr = ptr.getRChild();
            }
            this._standard = ptr.getDivider();
            if (ptr == this._root) {
                this._root = ptr.getLChild();
            } else {
                int count = ptr.getRChild().getCount();
                HitStoreNode ptr2 = this._root;
                while (ptr2.getRChild() != ptr) {
                    ptr2.decrementCount(count);
                    ptr2 = ptr2.getRChild();
                }
                ptr2.setRChild(ptr.getLChild());
            }
            ptr.setLChild(null);
        }
    }
}

