/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.HitStore;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.SearchEnvironment;
import java.util.Vector;
import javax.help.search.SearchItem;
import javax.help.search.SearchQuery;

class Query {
    private double _currentStandard;
    private final int _nColumns;
    private double[] _missingPenalty;
    private double[] _upperboundTemplate;
    private double[] _penalties;
    private final SearchEnvironment _env;
    private int _hitCounter;
    private boolean _vote;
    private HitStore _store;

    public Query(SearchEnvironment env, int nColumns, double[] missingPenalties) {
        this._env = env;
        this._nColumns = nColumns;
        this._missingPenalty = new double[nColumns];
        this._upperboundTemplate = new double[nColumns];
        this._penalties = missingPenalties;
        this._hitCounter = 0;
        this._vote = false;
        this._currentStandard = (double)(nColumns - 1) * 10.0 + 9.9999;
        this._store = new HitStore(this._currentStandard);
        for (int i = 0; i < this._nColumns; ++i) {
            this._missingPenalty[i] = missingPenalties != null ? missingPenalties[i] : 10.0;
        }
        this.makePenaltiesTable();
    }

    public void makeEvent(int n, SearchQuery searchQuery) {
        Vector<SearchItem> hits = new Vector<SearchItem>(n);
        if (n > 0) {
            int N = n;
            QueryHit qh = this._store.firstBestQueryHit();
            n = N;
            while (qh != null) {
                try {
                    hits.addElement(this._env.makeItem(qh));
                }
                catch (Exception e) {
                    System.err.println(e + "hit not translated");
                }
                qh = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
        searchQuery.itemsFound(true, hits);
    }

    public double lookupPenalty(int pattern) {
        return this._penalties[pattern];
    }

    public double getOutOufOrderPenalty() {
        return 0.25;
    }

    public double getGapPenalty() {
        return 0.005;
    }

    public int getNColumns() {
        return this._nColumns;
    }

    public boolean goodEnough(double penalty) {
        return penalty <= this._currentStandard;
    }

    public int[] getConceptArrayOfNewHit(double penalty, Location loc) {
        QueryHit hit = new QueryHit(loc, penalty, this._nColumns);
        this._store.addQueryHit(hit);
        ++this._hitCounter;
        return hit.getArray();
    }

    public void resetForNextDocument() {
        this._currentStandard = this._store.getCurrentStandard();
        for (int i = 0; i < this._nColumns; ++i) {
            this._upperboundTemplate[i] = this._missingPenalty[i];
        }
        this._vote = false;
    }

    public boolean vote() {
        double sum = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            sum += this._upperboundTemplate[i];
        }
        this._vote = sum <= this._currentStandard;
        return this._vote;
    }

    public void updateEstimate(int role, double penalty) {
        if (penalty < this._upperboundTemplate[role]) {
            this._upperboundTemplate[role] = penalty;
        }
    }

    public void printHits(int n) {
        if (n > 0) {
            int N = n;
            QueryHit qh = this._store.firstBestQueryHit();
            n = N;
            while (qh != null) {
                try {
                    System.out.println(this._env.hitToString(qh));
                }
                catch (Exception e) {
                    System.err.println(e + "hit not translated");
                }
                qh = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
    }

    private void makePenaltiesTable() {
        int nPatterns = 1 << this._nColumns;
        this._penalties = new double[nPatterns];
        for (int i = 0; i < nPatterns; ++i) {
            this._penalties[i] = this.computePenalty(i);
        }
    }

    private double computePenalty(int n) {
        double penalty = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            if ((n & 1 << i) != 0) continue;
            penalty += this._missingPenalty[i];
        }
        return penalty;
    }
}

