/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.LiteMorph;
import com.sun.java.help.search.Search;
import com.sun.java.help.search.SearchEnvironment;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpUtilities;
import javax.help.search.SearchQuery;

public class QueryEngine {
    private SearchEnvironment _env;

    public QueryEngine(String indexDir, URL hsBase) throws Exception {
        this._env = new SearchEnvironment(indexDir, hsBase);
    }

    public void processQuery(String query, Locale l, SearchQuery searchQuery) throws Exception {
        int i;
        Vector<SearchIds> ids = new Vector<SearchIds>();
        LiteMorph morph = this.getMorphForLocale(l);
        int col = -1;
        try {
            BreakIterator boundary = BreakIterator.getWordInstance(l);
            boundary.setText(query);
            int start = boundary.first();
            int end = boundary.next();
            while (end != -1) {
                int charType;
                String term = new String(query.substring(start, end));
                term = term.trim();
                if ((term = term.toLowerCase(l)).length() > 1) {
                    ++col;
                    int id = this._env.fetch(term);
                    if (id > 0) {
                        ids.addElement(new SearchIds(col, id, 0.0));
                    }
                    if (morph != null) {
                        String[] morphs = morph.variantsOf(term);
                        for (i = 0; i < morphs.length; ++i) {
                            int id2 = this._env.fetch(morphs[i]);
                            if (id2 <= 0) continue;
                            ids.addElement(new SearchIds(col, id2, 0.1));
                        }
                    }
                } else if (term.length() == 1 && ((charType = Character.getType(term.charAt(0))) == 9 || charType == 10 || charType == 2 || charType == 5 || charType == 11 || charType == 3 || charType == 0 || charType == 1)) {
                    ++col;
                    int id = this._env.fetch(term);
                    if (id > 0) {
                        ids.addElement(new SearchIds(col, id, 0.0));
                    }
                    if (morph != null) {
                        String[] morphs = morph.variantsOf(term);
                        for (int i2 = 0; i2 < morphs.length; ++i2) {
                            int id2 = this._env.fetch(morphs[i2]);
                            if (id2 <= 0) continue;
                            ids.addElement(new SearchIds(col, id2, 0.1));
                        }
                    }
                }
                start = end;
                end = boundary.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int size = ids.size();
        Search search = new Search(this._env, col + 1);
        IntegerArray children = new IntegerArray();
        for (i = 0; i < size; ++i) {
            SearchIds id = (SearchIds)ids.elementAt(i);
            search.addTerm(id.col, id.concept, id.score, 0);
            children.clear();
            this._env.getChildren(id.concept, children);
            if (children.cardinality() <= 0) continue;
            for (int j = 0; j < children.cardinality(); ++j) {
                search.addTerm(id.col, children.at(j), id.score + 0.1, 0);
                this._env.getChildren(children.at(j), children);
            }
        }
        search.startSearch(searchQuery);
    }

    private LiteMorph getMorphForLocale(Locale l) {
        if (l == null) {
            l = Locale.ENGLISH;
        }
        Enumeration enum1 = HelpUtilities.getCandidates(l);
        String front = "com.sun.java.help.search.LiteMorph";
        ClassLoader cl = QueryEngine.class.getClassLoader();
        while (enum1.hasMoreElements()) {
            String tail = (String)enum1.nextElement();
            String name = new String(front + tail);
            try {
                Class<?> klass = cl == null ? Class.forName(name) : cl.loadClass(name);
                Method method = klass.getMethod("getMorph", null);
                return (LiteMorph)method.invoke(null, (Object[])null);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in), 1);
            String file = new String(args[0]);
            QueryEngine qe = new QueryEngine(file, null);
            System.out.println("initialized; enter query");
            while ((line = in.readLine()) != null && !line.equals(".")) {
                long start = System.currentTimeMillis();
                qe.processQuery(line, Locale.getDefault(), null);
                System.out.println(System.currentTimeMillis() - start + " msec search");
                System.out.println("enter next query or . to quit");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class SearchIds {
        public int col;
        public int concept;
        public double score;

        public SearchIds(int col, int concept, double score) {
            this.col = col;
            this.concept = concept;
            this.score = score;
        }

        public String toString() {
            return "col=" + this.col + " concept=" + this.concept + " score=" + this.score;
        }
    }
}

