/*
 * Decompiled with CFR 0.152.
 */
package javax.help.tagext;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class NavigatorsTag
extends BodyTagSupport {
    private HelpBroker hb;
    private HelpSet hs;
    private String curNav = null;
    private NavigatorView[] views;
    private int i;

    public void setHelpBroker(HelpBroker hb) {
        this.hb = hb;
        this.hs = hb.getHelpSet();
    }

    public void setCurrentNav(String nav) {
        this.curNav = nav;
    }

    public void initialize() {
        this.checkRequestParams();
        this.initCurNav();
        this.views = this.hs.getNavigatorViews();
    }

    public int doStartTag() {
        this.initialize();
        if (this.views.length > 0) {
            this.i = 0;
            this.setNavigatorAttributes(this.views[this.i++]);
            return 2;
        }
        return 0;
    }

    private void checkRequestParams() {
        ServletRequest request = this.pageContext.getRequest();
        String nav = request.getParameter("nav");
        if (nav != null) {
            this.curNav = nav;
        }
    }

    private void initCurNav() {
        if (this.curNav != null) {
            try {
                this.hb.setCurrentView(this.curNav);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.curNav = this.hb.getCurrentView();
        }
    }

    public int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        try {
            body.writeOut((Writer)this.getPreviousOut());
        }
        catch (IOException e) {
            throw new JspTagException("NavigatorsTag: " + e.getMessage());
        }
        body.clearBody();
        if (this.i < this.views.length) {
            this.setNavigatorAttributes(this.views[this.i++]);
            return 2;
        }
        return 0;
    }

    private void setNavigatorAttributes(NavigatorView view) {
        this.pageContext.setAttribute("className", (Object)view.getClass().getName());
        this.pageContext.setAttribute("name", (Object)view.getName());
        this.pageContext.setAttribute("tip", (Object)view.getLabel());
        String icon = this.getIconURL(view);
        this.pageContext.setAttribute("iconURL", (Object)icon);
        this.pageContext.setAttribute("isCurrentNav", (Object)new Boolean(this.curNav.compareTo(view.getName()) == 0));
    }

    private String getIconURL(NavigatorView view) {
        URL url = null;
        Map.ID id = view.getImageID();
        if (id != null) {
            HelpSet hs = id.hs;
            Map map = hs.getLocalMap();
            try {
                url = map.getURLFromID(id);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            return "";
        }
        return url.toExternalForm();
    }
}

