/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;

public class SqlTool {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlTool.class);
    public static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static final String revString = "$Revision: 5736 $";
    private static final int revStringLength = "$Revision: 5736 $".length();
    private static final String revnum = revStringLength - " $".length() > "$Revision: ".length() ? "$Revision: 5736 $".substring("$Revision: ".length(), revStringLength - " $".length()) : "<UNTRACKED>";
    public static final int SQLTOOLERR_EXITVAL = 1;
    public static final int SYNTAXERR_EXITVAL = 11;
    public static final int RCERR_EXITVAL = 2;
    public static final int SQLERR_EXITVAL = 3;
    public static final int IOERR_EXITVAL = 4;
    public static final int FILEERR_EXITVAL = 5;
    public static final int INPUTERR_EXITVAL = 6;
    public static final int CONNECTERR_EXITVAL = 7;
    private static String CMDLINE_ID = "cmdline";
    public static final String LS = System.getProperty("line.separator");
    private static BadCmdline bcl = new BadCmdline();

    private static String promptForPassword(String string) throws PrivateException {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(SqltoolRB.passwordFor_prompt.getString(RCData.expandSysPropVars(string)));
            string2 = bufferedReader.readLine();
            string2 = string2 == null ? "" : string2.trim();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException.getMessage());
        }
        finally {
            Object var1_3 = null;
        }
        return string2;
    }

    private static void varParser(String string, Map<String, String> map, boolean bl) throws PrivateException {
        if (map == null) {
            throw new IllegalArgumentException("varMap is null in SqlTool.varParser call");
        }
        if (string == null) {
            throw new IllegalArgumentException("inVarString is null in SqlTool.varParser call");
        }
        boolean bl2 = string.indexOf("\\,") > -1;
        String string2 = bl2 ? string.replace("\\,", "\u0002") : string;
        for (String string3 : string2.split("\\s*,\\s*")) {
            int n = string3.indexOf(61);
            if (n < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            String string4 = string3.substring(0, n).trim();
            String string5 = string3.substring(n + 1).trim();
            if (bl2) {
                string5 = string5.replace("\u0002", ",");
            }
            if (string4.length() < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            if (bl) {
                string4 = string4.toLowerCase();
            }
            map.put(string4, string5);
        }
    }

    public static void main(String[] stringArray) {
        try {
            SqlTool.objectMain(stringArray);
        }
        catch (SqlToolException sqlToolException) {
            System.err.println(sqlToolException.getMessage() == null ? sqlToolException : sqlToolException.getMessage());
            System.exit(sqlToolException.exitValue);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void objectMain(String[] stringArray) throws SqlToolException {
        Object[] objectArray;
        Object object;
        logger.finer("Invoking SqlTool");
        String string = null;
        PipedReader pipedReader = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        File[] fileArray = null;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Boolean bl7 = null;
        Boolean bl8 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        HashMap<String, String> hashMap = null;
        SqlFile[] sqlFileArray = null;
        Connection connection = null;
        Map<String, String> map = new HashMap<String, String>();
        try {
            block126: {
                try {
                    int n2;
                    while (n + 1 < stringArray.length) {
                        if (stringArray[n + 1].startsWith("--")) {
                            if (stringArray[++n].length() == 2) break;
                            String string12 = stringArray[n].substring(2).toLowerCase();
                            if (string12.equals("help")) {
                                System.out.println(SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                                pipedReader = null;
                                return;
                            }
                            if (string12.equals("abortonerr")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.FALSE;
                                continue;
                            }
                            if (string12.equals("continueonerr")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.TRUE;
                                continue;
                            }
                            if (string12.startsWith("continueonerr=")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.valueOf(stringArray[n].substring("--continueonerr=".length()));
                                continue;
                            }
                            if (string12.equals("list")) {
                                if (bl2) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl2 = true;
                                continue;
                            }
                            if (string12.equals("rcfile")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string = stringArray[n];
                                continue;
                            }
                            if (string12.startsWith("rcfile=")) {
                                if (string != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string = stringArray[n].substring("--rcfile=".length());
                                continue;
                            }
                            if (string12.equals("setvar")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                try {
                                    SqlTool.varParser(stringArray[n], map, false);
                                    continue;
                                }
                                catch (PrivateException privateException) {
                                    throw new SqlToolException(2, privateException.getMessage());
                                }
                            }
                            if (string12.startsWith("setvar=")) {
                                try {
                                    SqlTool.varParser(stringArray[n].substring("--setvar=".length()), map, false);
                                    continue;
                                }
                                catch (PrivateException privateException) {
                                    throw new SqlToolException(2, privateException.getMessage());
                                }
                            }
                            if (string12.equals("sql")) {
                                bl4 = true;
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string2 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string2 = stringArray[n];
                                continue;
                            }
                            if (string12.startsWith("sql=")) {
                                bl4 = true;
                                if (string2 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string2 = stringArray[n].substring("--sql=".length());
                                continue;
                            }
                            if (string12.equals("debug")) {
                                if (bl) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl = true;
                                continue;
                            }
                            if (string12.equals("noautofile")) {
                                if (bl5) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl5 = true;
                                continue;
                            }
                            if (string12.equals("autocommit")) {
                                if (bl6) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl6 = true;
                                continue;
                            }
                            if (string12.equals("stdinput")) {
                                bl4 = false;
                                if (bl8 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl8 = Boolean.TRUE;
                                continue;
                            }
                            if (string12.equals("noinput")) {
                                bl4 = true;
                                if (bl8 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl8 = Boolean.FALSE;
                                continue;
                            }
                            if (string12.equals("driver")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string3 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string3 = stringArray[n];
                                continue;
                            }
                            if (string12.startsWith("driver=")) {
                                if (string3 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string3 = stringArray[n].substring("--driver=".length());
                                continue;
                            }
                            if (string12.equals("inlinerc")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string5 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string5 = stringArray[n];
                                continue;
                            }
                            if (!string12.startsWith("inlinerc=")) throw bcl;
                            if (string5 != null) {
                                throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                            }
                            string5 = stringArray[n].substring("--inlinerc=".length());
                            continue;
                        }
                        if (!stringArray[n + 1].startsWith("-P") && !stringArray[n + 1].startsWith("-p")) break;
                        int n3 = n2 = stringArray[++n].length() < 3 ? 1 : 0;
                        if (n2 != 0 && ++n == stringArray.length) {
                            throw bcl;
                        }
                        int n4 = stringArray[n].indexOf(61);
                        if (n4 < (n2 != 0 ? 1 : 3)) {
                            throw new SqlToolException(2, "Specified var assignment contains no '='");
                        }
                        map.put(stringArray[n].substring(n2 != 0 ? 0 : 2, n4), stringArray[n].substring(n4 + 1));
                    }
                    if (!bl2 && string5 == null && ++n != stringArray.length && (string4 = stringArray[n]).equals("-")) {
                        string4 = null;
                    }
                    n2 = 0;
                    if (string2 != null) {
                        try {
                            pipedReader = new PipedReader();
                            PipedWriter pipedWriter = new PipedWriter(pipedReader);
                            try {
                                pipedWriter.write(string2 + LS);
                                pipedWriter.flush();
                            }
                            finally {
                                try {
                                    pipedWriter.close();
                                }
                                finally {
                                    pipedWriter = null;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            throw new SqlToolException(4, SqltoolRB.sqltempfile_fail.getString(iOException.toString()));
                        }
                    }
                    if (bl8 != null) {
                        bl4 = bl8 == false;
                    }
                    boolean bl9 = bl3 = !bl4 && stringArray.length <= n + 1;
                    if (stringArray.length == n + 2 && stringArray[n + 1].equals("-")) {
                        if (bl8 == null) {
                            bl4 = false;
                        }
                        break block126;
                    }
                    if (stringArray.length <= n + 1) break block126;
                    fileArray = new File[stringArray.length - n - 1 + (bl8 == null || bl8 == false ? 0 : 1)];
                    if (bl) {
                        System.err.println("scriptFiles has " + fileArray.length + " elements");
                    }
                    while (n + 1 < stringArray.length) {
                        fileArray[n2++] = new File(stringArray[++n]);
                    }
                    if (bl8 != null && bl8.booleanValue()) {
                        fileArray[n2++] = null;
                        bl4 = true;
                    }
                }
                catch (BadCmdline badCmdline) {
                    throw new SqlToolException(11, SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                }
            }
            object = null;
            if (string5 != null) {
                hashMap = new HashMap<String, String>();
                try {
                    SqlTool.varParser(string5, hashMap, true);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(11, privateException.getMessage());
                }
                string6 = (String)hashMap.remove("url");
                string7 = (String)hashMap.remove("user");
                string9 = (String)hashMap.remove("charset");
                string10 = (String)hashMap.remove("truststore");
                string8 = (String)hashMap.remove("password");
                string11 = (String)hashMap.remove("transiso");
                if (string6 == null) throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                if (string6.length() < 1) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                }
                if (string8 != null && string8.length() > 0) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_password_visible.getString());
                }
                if (hashMap.size() > 0) {
                    throw new SqlToolException(6, SqltoolRB.rcdata_inline_extravars.getString(hashMap.keySet().toString()));
                }
                if (string7 != null && string8 == null) {
                    try {
                        string8 = SqlTool.promptForPassword(string7);
                    }
                    catch (PrivateException privateException) {
                        throw new SqlToolException(6, SqltoolRB.password_readfail.getString(privateException.getMessage()));
                    }
                }
                try {
                    object = new RCData(CMDLINE_ID, string6, string7, string8, string3, string9, string10, null, string11);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_genfromvalues_fail.getString());
                }
            }
            if (bl2 || string4 != null) {
                try {
                    object = new RCData(new File(string == null ? DEFAULT_RCFILE : string), string4);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, SqltoolRB.conndata_retrieval_fail.getString(string4, exception.getMessage()));
                }
            }
            if (bl2) {
                pipedReader = null;
                return;
            }
            if (bl3) {
                System.out.print("SqlTool v. " + revnum + '.' + LS);
            }
            if (object != null) {
                try {
                    String string13;
                    connection = ((RCData)object).getConnection(string3, System.getProperty("javax.net.ssl.trustStore"));
                    connection.setAutoCommit(bl6);
                    if (bl3 && (string13 = SqlFile.getBanner(connection)) != null) {
                        System.out.println(string13);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    if (bl) {
                        logger.error(exception.getClass().getName(), exception);
                    }
                    String string14 = ((RCData)object).username == null ? "<DFLTUSER>" : ((RCData)object).username;
                    throw new SqlToolException(7, SqltoolRB.connection_fail.getString(((RCData)object).url, string14, exception.getMessage()));
                }
            }
            objectArray = new File[]{};
            File[] fileArray2 = new File[]{null};
            File file = null;
            if (!(!bl3 || bl5 || (file = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && file.canRead())) {
                file = null;
            }
            if (fileArray == null) {
                fileArray = bl4 ? objectArray : fileArray2;
            }
            int n5 = fileArray.length;
            if (pipedReader != null) {
                ++n5;
            }
            if (file != null) {
                ++n5;
            }
            sqlFileArray = new SqlFile[n5];
            int n6 = -1;
            String string15 = object == null ? null : ((RCData)object).charset;
            try {
                int n7 = 0;
                if (file != null) {
                    sqlFileArray[n7++] = new SqlFile(file, string15);
                }
                if (pipedReader != null) {
                    sqlFileArray[n7++] = new SqlFile(pipedReader, "--sql", System.out, null, false, null);
                }
                for (File file2 : fileArray) {
                    if (n6 < 0 && bl3) {
                        n6 = n7;
                    }
                    sqlFileArray[n7++] = file2 == null ? new SqlFile(string15, bl3) : new SqlFile(file2, string15, bl3);
                }
            }
            catch (IOException iOException) {
                try {
                    if (connection == null) throw new SqlToolException(5, iOException.getMessage());
                    connection.close();
                    throw new SqlToolException(5, iOException.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SqlToolException(5, iOException.getMessage());
            }
        }
        finally {
            pipedReader = null;
        }
        object = null;
        try {
            objectArray = sqlFileArray;
            int n8 = objectArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Object object2 = objectArray[n9];
                if (connection != null) {
                    ((SqlFile)object2).setConnection(connection);
                }
                if (map.size() > 0) {
                    ((SqlFile)object2).addUserVars(map);
                }
                if (object != null) {
                    ((SqlFile)object2).addMacros((Map<String, Token>)object);
                }
                if (bl7 != null) {
                    ((SqlFile)object2).setContinueOnError(bl7);
                }
                ((SqlFile)object2).execute();
                map = ((SqlFile)object2).getUserVars();
                object = ((SqlFile)object2).getMacros();
                connection = ((SqlFile)object2).getConnection();
                ++n9;
            }
            return;
        }
        catch (SqlToolError sqlToolError) {
            throw new SqlToolException(1);
        }
        catch (SQLException sQLException) {
            throw new SqlToolException(3);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class SqlToolException
    extends Exception {
        static final long serialVersionUID = 1424909871915188519L;
        int exitValue = 1;

        SqlToolException(String string, int n) {
            super(string);
            this.exitValue = n;
        }

        SqlToolException(int n, String string) {
            this(string, n);
        }

        SqlToolException(int n) {
            this.exitValue = n;
        }
    }

    private static class PrivateException
    extends Exception {
        static final long serialVersionUID = -7765061479594523462L;

        PrivateException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        static final long serialVersionUID = -2134764796788108325L;

        BadCmdline() {
        }
    }
}

