/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jzlib.ZStream;

class test_large_deflate_inflate {
    static final byte[] hello = "hello, hello! ".getBytes();

    static {
        test_large_deflate_inflate.hello[test_large_deflate_inflate.hello.length - 1] = 0;
    }

    test_large_deflate_inflate() {
    }

    public static void main(String[] arg) {
        int comprLen;
        int uncomprLen = comprLen = 40000;
        byte[] compr = new byte[comprLen];
        byte[] uncompr = new byte[uncomprLen];
        ZStream c_stream = new ZStream();
        int err = c_stream.deflateInit(1);
        test_large_deflate_inflate.CHECK_ERR(c_stream, err, "deflateInit");
        c_stream.next_out = compr;
        c_stream.next_out_index = 0;
        c_stream.avail_out = comprLen;
        c_stream.next_in = uncompr;
        c_stream.avail_in = uncomprLen;
        err = c_stream.deflate(0);
        test_large_deflate_inflate.CHECK_ERR(c_stream, err, "deflate");
        if (c_stream.avail_in != 0) {
            System.out.println("deflate not greedy");
            System.exit(1);
        }
        c_stream.deflateParams(0, 0);
        c_stream.next_in = compr;
        c_stream.next_in_index = 0;
        c_stream.avail_in = comprLen / 2;
        err = c_stream.deflate(0);
        test_large_deflate_inflate.CHECK_ERR(c_stream, err, "deflate");
        c_stream.deflateParams(9, 1);
        c_stream.next_in = uncompr;
        c_stream.next_in_index = 0;
        c_stream.avail_in = uncomprLen;
        err = c_stream.deflate(0);
        test_large_deflate_inflate.CHECK_ERR(c_stream, err, "deflate");
        err = c_stream.deflate(4);
        if (err != 1) {
            System.out.println("deflate should report Z_STREAM_END");
            System.exit(1);
        }
        err = c_stream.deflateEnd();
        test_large_deflate_inflate.CHECK_ERR(c_stream, err, "deflateEnd");
        ZStream d_stream = new ZStream();
        d_stream.next_in = compr;
        d_stream.next_in_index = 0;
        d_stream.avail_in = comprLen;
        err = d_stream.inflateInit();
        test_large_deflate_inflate.CHECK_ERR(d_stream, err, "inflateInit");
        while (true) {
            d_stream.next_out = uncompr;
            d_stream.next_out_index = 0;
            d_stream.avail_out = uncomprLen;
            err = d_stream.inflate(0);
            if (err == 1) break;
            test_large_deflate_inflate.CHECK_ERR(d_stream, err, "inflate large");
        }
        err = d_stream.inflateEnd();
        test_large_deflate_inflate.CHECK_ERR(d_stream, err, "inflateEnd");
        if (d_stream.total_out != (long)(2 * uncomprLen + comprLen / 2)) {
            System.out.println("bad large inflate: " + d_stream.total_out);
            System.exit(1);
        } else {
            System.out.println("large_inflate(): OK");
        }
    }

    static void CHECK_ERR(ZStream z, int err, String msg) {
        if (err != 0) {
            if (z.msg != null) {
                System.out.print(String.valueOf(z.msg) + " ");
            }
            System.out.println(String.valueOf(msg) + " error: " + err);
            System.exit(1);
        }
    }
}

