/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.CompressorIterator;
import com.sun.java.help.search.IntegerArray;

abstract class Decompressor {
    private static final int BitsInByte = 8;
    private static final int NBits = 32;
    private int _readByte;
    private int _toRead = 0;
    private int _path = 0;

    Decompressor() {
    }

    protected abstract int getNextByte() throws Exception;

    protected void initReading() {
        this._toRead = 0;
    }

    private int countZeroes() throws Exception {
        int count = 0;
        while (true) {
            if (this._toRead-- > 0) {
                if ((this._readByte & 1 << this._toRead) != 0) {
                    return count;
                }
                ++count;
                continue;
            }
            this._readByte = this.getNextByte();
            this._toRead = 8;
        }
    }

    private int read() throws Exception {
        if (this._toRead-- > 0) {
            return this._readByte & 1 << this._toRead;
        }
        this._toRead = 7;
        this._readByte = this.getNextByte();
        return this._readByte & 0x80;
    }

    public int read(int kBits) throws Exception {
        int shift = 8 - this._toRead;
        if (kBits <= this._toRead) {
            return (this._readByte << shift & 0xFF) >>> shift + (this._toRead -= kBits);
        }
        int result = this._toRead > 0 ? (this._readByte << shift & 0xFF) >>> shift : 0;
        kBits -= this._toRead;
        while (kBits >= 8) {
            result = result << 8 | this.getNextByte();
            kBits -= 8;
        }
        if (kBits > 0) {
            this._readByte = this.getNextByte();
            this._toRead = 8 - kBits;
            return result << kBits | this._readByte >>> this._toRead;
        }
        this._toRead = 0;
        return result;
    }

    public void beginIteration() {
        this._path = 0;
    }

    public boolean readNext(int k, CompressorIterator it) throws Exception {
        if (this.read() != 0) {
            it.value(this._path | this.read(k));
            return true;
        }
        int count = 1;
        while (true) {
            if (this._toRead-- > 0) {
                if ((this._readByte & 1 << this._toRead) != 0) {
                    int saved = this._path;
                    this._path = (this._path >>> k + count << count | this.read(count)) << k;
                    if (this._path != saved) {
                        it.value(this._path | this.read(k));
                        return true;
                    }
                    return false;
                }
                ++count;
                continue;
            }
            this._readByte = this.getNextByte();
            this._toRead = 8;
        }
    }

    public void decode(int k, IntegerArray array) throws Exception {
        int path = 0;
        while (true) {
            if (this.read() != 0) {
                array.add(path | this.read(k));
                continue;
            }
            int count = this.countZeroes() + 1;
            int saved = path;
            if ((path = (path >>> k + count << count | this.read(count)) << k) == saved) break;
            array.add(path | this.read(k));
        }
    }

    public void ascDecode(int k, IntegerArray array) throws Exception {
        int path = 0;
        int start = 0;
        while (true) {
            if (this.read() != 0) {
                array.add(start += path | this.read(k));
                continue;
            }
            int count = this.countZeroes() + 1;
            int saved = path;
            if ((path = (path >>> k + count << count | this.read(count)) << k) == saved) break;
            array.add(start += path | this.read(k));
        }
    }

    public int ascendingDecode(int k, int start, int[] array) throws Exception {
        int path = 0;
        int index = 0;
        block0: while (true) {
            if (this.read() != 0) {
                array[index++] = start += path | this.read(k);
                continue;
            }
            int cnt = 0;
            while (true) {
                if (this._toRead-- > 0) {
                    if ((this._readByte & 1 << this._toRead) != 0) {
                        int Path;
                        if ((Path = (path >>> k + ++cnt << cnt | this.read(cnt)) << k) != path) {
                            int n = index++;
                            path = Path;
                            array[n] = start += path | this.read(k);
                            continue block0;
                        }
                        return index;
                    }
                    ++cnt;
                    continue;
                }
                this._readByte = this.getNextByte();
                this._toRead = 8;
            }
            break;
        }
    }
}

