/*****************************************************************************
 *
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2018 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *  version: QAT1.7.L.4.5.0-00034
 *
 *****************************************************************************/

/*****************************************************************************
 * @file icp_sal_kpt.h
 *
 * @description
 *      File contains Public ICP API Definitions for the kpt functions.
 *
 *****************************************************************************/
#ifndef __ICP_SAL_KPT_H__
#define __ICP_SAL_KPT_H__

#include "cpa_cy_kpt.h"
/**
 *****************************************************************************
 * @ingroup SalKpt
 * @description
 *  KPT ECDSA DRBG PTT operation function definition, its implementation
 *  always depends on third party library like TSS2.0 and PTT driver.
 *  For KPT ECDSA DRNG seed initialization case, this function will realize
 *  below functions:
 *  Step1: Generate a random data within PTT.
 *  Step2: Push this random data to QAT with TSS2.0 AC Send family APIs.
 *****************************************************************************/
typedef Cpa32U (*PTTFunc)(Cpa64U opdata);

/**
 *****************************************************************************
 * @ingroup SalKpt
 * @description
 *    Implement DRBG reseed/initialization function with KPT KSP, it
 *    follows three-step handshake protocol to transfer the DRNG seed
 *    generated by PTT from PTT to QAT.
 * @context
 *    This functions is called from user context.
 * @assumptions
 *      None
 * @sideEffects
 *      None
 * @reentrant
 *      No
 * @threadSafe
 *      Yes
 *
 * @param[in]  instanceHandle_in   Instance handle.
 * @param[in]  pttFunc             PTT operation function.
 * @param[out] pKptStatus          One of the status codes denoted in the
 *                                 enumerate type CpaCyKptKeyManagementStatus.
 * @retval CPA_STATUS_SUCCESS      Successfully initialize/reseed a KPT ECDASA
 *                                 DRBG seed.
 * @retval CPA_STATUS_FAIL         Indicates a failure
 * @retval CPA_STATUS_UNSUPPORTED  Indicates KPT is unsupported in instance.
 *****************************************************************************/
CpaStatus icp_sal_kpt_drbg_reseed(const CpaInstanceHandle instanceHandle_in,
                                  PTTFunc pttFunc,
                                  CpaCyKptKeyManagementStatus *pkptstatus);
#endif
