# Copyright © 2015-2019 Intel Corporation.
[CmdletBinding(DefaultParameterSetName='None')]
Param([string]$Path)

if(!(Test-Path $Path)){
	Write-Error "Failed to find '$Path'"
    $host.SetShouldExit(2) 
	exit
}

$PolicyXML = Get-Content -Path $Path | Out-String
$PolicyXML = $PolicyXML -replace "`n|`r|`t", ""

if ($PolicyXML -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to load XML profile. $mg"
	$host.SetShouldExit(2) 
	exit
}

$PolicyInstance = $( Get-WMIObject -Namespace Root\IntelAuthenticate -Class Policy) 

if ($PolicyInstance -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to load: $mg"
	$host.SetShouldExit(1) 
	exit
}

$method = "EnforcePolicy"
$params = $PolicyInstance.GetMethodParameters($method)
$params.policy = $PolicyXML

function SetPolicy
{
    try {

	    $ret = $PolicyInstance.InvokeMethod($method, $params, $null)
    
    } catch [Exception] {
	    Write-Error "Failed executing the $method command with message: $_.Exception.Message"
	    $host.SetShouldExit($_.Exception.ErrorCode)
		exit
    }
    return $ret
}

$ret = SetPolicy

$exitcode = $ret.ReturnValue
if ($exitcode -ne 0){
    $errorNum = $ret.errorcode.ToString()
    if($errorNum -eq "0xA0000047"){
        $restIAPath = $ExecutionContext.SessionState.Path.GetUnresolvedProviderPathFromPSPath('.\') + "\ResetIA.ps1"
        Invoke-Expression $restIAPath
        $ret = SetPolicy
        $exitcode = $ret.ReturnValue
    }
    if ($exitcode -ne 0){
        $errorString = $ret.error.ToString()
        $errorNum = $ret.errorcode.ToString()
        Write-Host "Error: $errorString, Errorcode: $errorNum"
	    return
    }
}
Write-Host "Policy Enforced Successfully"
$host.SetShouldExit($exitcode)
exit
