# Copyright © 2015-2019 Intel Corporation.
# This script invokes the ResetIA method of the Policy WMI class.

$PolicyInstance = $( Get-WMIObject -Namespace Root\IntelAuthenticate -Class Administration) 

if ($PolicyInstance -eq $null) {
	if($err.Count -gt 0) {$mg=$err[0];} else { $mg="";}
	Write-Error "Failed to load: $mg"
	$host.SetShouldExit(1) 
	exit
}
$method = "ResetIA"
try {

	$ret = $PolicyInstance.InvokeMethod($method, $params, $null)
    
} catch [Exception] {
	Write-Error "Failed executing the $method command with message: $_.Exception.Message"
	$host.SetShouldExit($_.Exception.ErrorCode)
	exit
}

$exitcode = $ret.ReturnValue
if ($exitcode -eq $null){
	Write-Host "Error: could not reset policy"
	exit
}
if (($exitcode -ne 0) -AND ($exitcode -ne "0x00000000")){
    $errorString = $ret.error.ToString()
    Write-Host "Error: $errorString, Errorcode: $exitcode"
}	
 else {
    Write-Host "Policy reset successfully"
}


exit
