# Copyright (c) 2015-2019 Intel Corporation. All rights reserved.


$MsiSuccessRebootRequired = 3010
$MsiSuccess = 0


# Shows the user a reboot required message
function ShowRebootRequirement()
{
	$pInfo = Get-Process | Select-Object ID,SessionId | Where-Object { $_.ID -eq $PID }
	if($pInfo.SessionId -ne 0){
		$wshell = New-Object -ComObject Wscript.Shell	
		$wshell.Popup("Please restart your computer to complete the update of Intel(R) Authenticate.",0,"Restart Required",0x0)
	}
}

# Function to run the command line execution process and wait for the return code
function ExecuteMsiInstallCommand([string] $installerFullPath) 
{
    $processInfo = New-Object System.Diagnostics.ProcessStartInfo
    $processInfo.UseShellExecute = $false

    $processInfo.FileName = $installerFullPath
    $processInfo.Arguments = '/s /v"/L*V '+$env:TEMP +'\IA_Install.log" /v"/qn /norestart BYPASSMEFIRMWARECHECK=0"'

    $process = New-Object System.Diagnostics.Process
    $process.StartInfo = $processInfo
    $process.Start() | Out-Null
    $process.WaitForExit()

    return $process.ExitCode
}


function GetUpgradeCodeRegistryEntry
{
    $upgradeCodeIA = 'E75B204ABC3185546AA926D8DC7F5F7A'
    $upgradeCodes = 'HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\'
    return Get-ChildItem $upgradeCodes | Where-Object{$_.Name -like '*' + $upgradeCodeIA}
}

function IsUpgrade
{
    $upgradeRegistryIA = 'HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\E75B204ABC3185546AA926D8DC7F5F7A'
    return Test-Path ($upgradeRegistryIA)
}

function GetPrevVersion
{
    $upgradeReg = GetUpgradeCodeRegistryEntry
    $productId = $upgradeReg.Property
    $version = (Get-ItemProperty ('HKLM:\SOFTWARE\Classes\Installer\Products\' + $productId))
    #used premitive way to perform shift right to support powershell 2.0
    $maj=($version.Version -band 0xFF000000)/ [math]::pow(2,24) #majpr version is the msd of high Dword
    $min=($version.Version -band 0x00FF0000)/ [math]::pow(2,16) #minor version is the lsd of high Dword
    $bui=($version.Version -band 0x0000FFFF)  #build version is the low Dword
    $versionNumber =[string]::Format("{0}.{1}.{2}.0",[math]::floor($maj),[math]::floor($min),$bui)
    return $versionNumber
}

#Function to prevent downgrading
function PreventDowngrade([string]$latestVersion, [string]$PrevVersionNumber)
{
    #add version check here and execute the installer based on that
    #we have the version that is going to be installed
    $regEx = "(\d{0,2})\.(\d{0,2})\.(\d{0,2})\.(\d{0,4})"
    $version_to_install = $latestVersion -match $regEx #msi just cares for x.y.z
    if($version_to_install){
        $version_to_install_major = $Matches[1]
        $version_to_install_minor = $Matches[2]
        $version_to_install_build = $Matches[3]
    }

    $installed_version = $PrevVersionNumber -match $regEx
    
    $installed_version_major = 0
    $installed_version_minor = 0
    $installed_version_build = 0
    if(!$installed_version)
    {
    	write "Unable to get version from registry"
    }
    else 
    {
        $installed_version_major = $Matches[1]
        $installed_version_minor = $Matches[2]
        $installed_version_build = $Matches[3]
    }
    if ($version_to_install_major -gt $installed_version_major)
    {
        write "Major uprade detected"
    }else{
        if($version_to_install_major -lt $installed_version_major){
            write "Downgrade not allowed"
            exit(1)
        }
        if ($version_to_install_minor -gt $installed_version_minor){
            write "Minor uprade detected"
        }else{
            if($version_to_install_minor -lt $installed_version_minor){
                write "Minor downgrade not allowed"
                exit(1)
            }
            if ($version_to_install_build -le $installed_version_build){
                write "Installation cancelled because the same version, or a higher version, is already installed"
                exit(1)
            }
        }
    }
}


#Returns the installer name
function GetInstallerName()
{
	$OsBit = [Environment]::Is64BitOperatingSystem
	if($OsBit)
	{
        return [System.IO.FileSystemInfo](get-childItem  -filter "Setup_x64.exe")
	}
	return [System.IO.FileSystemInfo](get-childItem  -filter "Setup_x86.exe")
}


#Main program
$installer = GetInstallerName
$installerVersion= $installer.VersionInfo.FileVersion	
$IsUpgradeFlow = 0
	
if (IsUpgrade)
{
	#If it detects that a downgrade is being performed, it will EXIT
	$IsUpgradeFlow = 1
    $prevVersion = GetPrevVersion     
    PreventDowngrade $installerVersion $prevVersion
}

$exitCode = ExecuteMsiInstallCommand $installer.FullName	
	
if($IsUpgradeFlow -eq 1)
{	
	if($exitCode -eq $MsiSuccessRebootRequired -Or $exitCode -eq $MsiSuccess)
	{
		ShowRebootRequirement
	}
}
exit $exitCode