/********************************************************************************
*
* INTEL CONFIDENTIAL
*
* Copyright 2011-2018 Intel Corporation All Rights Reserved.
*
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Intel or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, modified,
* published, uploaded, posted, transmitted, distributed, or disclosed in any way
* without Intel's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery of
* the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be express
* and approved by Intel in writing.
*
* Other names and brands may be claimed as the property of others.
*
********************************************************************************/
/*
 * @file	installTables.sql
 *
 * @brief	Install tables for Intel Identity Protection Technology with Multi Factor Authentication
 *
 */

-- Intel Authenticate Properties table--
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[MFAbProperties]') AND  OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN
CREATE TABLE MFAbProperties (
	Id bigint Identity(1,1) NOT NULL,
	ParentId int NOT NULL,
	TenantId bigint DEFAULT 1 NOT NULL,
	VolumeID nvarchar(256),
	OSSupported tinyint,
	OSTypeSupported tinyint,
	HECIPresent tinyint,
	JHIService tinyint,
	TLSResistor tinyint,
	MEVersion nvarchar(256),
	MEVersionSupported tinyint,
	MESystemManageability tinyint,
	PTDSupported tinyint,
	DALEnabled tinyint,
	BluetoothAvailable tinyint,
	BluetoothEnabled tinyint,
	DALBackupTimeStamp datetime,
	DALBackup tinyint,
	DALRestores smallint,
	AgentGuid uniqueidentifier,
	SystemId nvarchar(256) NOT NULL,
	PlatformCode nvarchar(128),
	LastCommunication datetime NOT NULL DEFAULT (GETUTCDATE())
)
ALTER TABLE MFAbProperties ADD CONSTRAINT PK_MFAbProperties PRIMARY KEY CLUSTERED (Id)
ALTER TABLE MFAbProperties ADD CONSTRAINT UQ_MFAbProperties_SystemId UNIQUE (SystemId)
ALTER TABLE MFAbProperties ADD CONSTRAINT FK_MFAbProperties_EPOProductProperties FOREIGN KEY (Parentid) REFERENCES EPOProductProperties([AutoID]) ON DELETE CASCADE
CREATE INDEX IDX_MFAbProperties_SystemID ON MFAbProperties (SystemId ASC) WITH (FILLFACTOR = 75)
END
GO

-- Intel Authenticate Users--
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbUsers]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE MFAbUsers (
	Id int Identity(1,1) NOT NULL,
	TenantId bigint DEFAULT 1,
	SystemId nvarchar(256) NOT NULL,
	SID varchar(184) NOT NULL,
	Username nvarchar(256) NOT NULL,
	Type tinyint,
	IsActive bit NOT NULL,
	LastMfabLogin datetime
)
ALTER TABLE MFAbUsers ADD CONSTRAINT UQ_MFAbUsers_Id UNIQUE (Id)
ALTER TABLE MFAbUsers ADD CONSTRAINT PK_MFAbUsers PRIMARY KEY CLUSTERED (Id)
ALTER TABLE MFAbUsers ADD CONSTRAINT FK_MFAbUsers_MFAbProperties FOREIGN KEY (SystemId) REFERENCES MFAbProperties (SystemId) ON DELETE CASCADE
END
GO

-- Intel Authenticate Factors table--


IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbFactors]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE MFAbFactors (
	Id int Identity(1,1) NOT NULL,
	TenantId bigint DEFAULT 1,
	MFAbUsersId int NOT NULL,
	FactorType int NOT NULL,
	EnrollmentState tinyint NOT NULL,
	AttemptCount int,
	EnrollmentCount int
)
ALTER TABLE MFAbFactors	ADD CONSTRAINT UQ_MfabFactors_Id UNIQUE (Id)
ALTER TABLE MFAbFactors ADD CONSTRAINT PK_MFAbFactors PRIMARY KEY CLUSTERED (Id)
ALTER TABLE MFAbFactors ADD CONSTRAINT FK_MFAbFactors_MFAbUsers FOREIGN KEY (MFAbUsersId) REFERENCES MFAbUsers (Id) ON DELETE CASCADE
END
GO

--MFAbCertificates table--
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbCertificates]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE MFAbCertificates (
	Id bigint identity(1,1) NOT NULL,
	TenantId bigint DEFAULT 1 NOT NULL,
	Name nvarchar(50) NOT NULL,
	PublicKey varbinary(max) NOT NULL,
	PrivateKey varbinary(max) NOT NULL,
	PublicCertificate varbinary(max) NOT NULL,
	FullCertificate varbinary(max),
	Created datetime NOT NULL,
	Source tinyint NOT NULL,
    Thumbprint varbinary(max) NOT NULL
)
ALTER TABLE MFAbCertificates ADD CONSTRAINT PK_MFAbCertificates PRIMARY KEY CLUSTERED (Id)
END
GO

--MFAb UserFactors view--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbUserFactorsView]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP  VIEW MFAbUserFactorsView
GO
CREATE VIEW MFAbUserFactorsView
AS
    SELECT MFAbUsers.Id,
           MFAbUsers.SystemId,
           MFAbUsers.SID,
           MFAbUsers.Username,
           MFAbUsers.Type,
           MFAbUsers.IsActive,
           MFAbUsers.LastMfabLogin,
           MFAbFactors.Id AS FactorId,
           MFAbFactors.FactorType,
           MFAbFactors.EnrollmentState,
           MFAbFactors.AttemptCount AS AttemptCount,
           MFAbFactors.EnrollmentCount,
           MFAbProperties.AgentGuid
           FROM MFAbUsers
               INNER JOIN MFAbFactors ON MFAbUsers.Id = MFAbFactors.MFAbUsersId
               INNER JOIN MFAbProperties ON MFAbUsers.SystemId = MFAbProperties.SystemId
GO
