/*
 * @file	uninstallTables.sql
 *
 * @brief	Uninstall tables for Intel Identity Protection Technology with Multi Factor Authentication
 *
 */
/********************************************************************************
*
* INTEL CONFIDENTIAL
*
* Copyright 2015-2018, Intel Corporation. All Rights Reserved.
*
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Intel or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, modified,
* published, uploaded, posted, transmitted, distributed, or disclosed in any way
* without Intel's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery of
* the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be express
* and approved by Intel in writing.
*
********************************************************************************/

--For testing only - should not be invoked by install.xml - uncomment next line to use--
-- raiserror('Install.xml cannot use uninstallTables.sql', 20, -1) with log

--MFAb Factors table--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbFactors]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
DROP TABLE MFAbFactors
END
GO

--MFAb Users--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbUsers]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
DROP TABLE MFAbUsers
END
GO

--MFAb Properties table--
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[MFAbProperties]') AND  OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN
DROP TABLE MFAbProperties
END
GO

--MFAbCertificates table--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbCertificates]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
DROP TABLE MFAbCertificates
END
GO

--MFAb UserFactors view--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = OBJECT_ID(N'[dbo].[MFAbUserFactorsView]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP  VIEW MFAbUserFactorsView
