/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.IOException;

class Block {
    public static final int HEADERLEN = 8;
    public static final int IDLEN = 4;
    public int number;
    public boolean isLeaf = true;
    public int free = 0;
    public byte[] data = null;
    private static boolean debug = false;

    public Block(int blocksize) {
        this.data = new byte[blocksize - 8];
    }

    public void setBlockNumber(int n) {
        this.number = n;
    }

    public void setFree(int free) {
    }

    public int integerAt(int i) {
        return (((this.data[i++] & 0xFF) << 8 | this.data[i++] & 0xFF) << 8 | this.data[i++] & 0xFF) << 8 | this.data[i] & 0xFF;
    }

    public void setIntegerAt(int i, int value) {
        int j = i + 3;
        while (j >= i) {
            this.data[j] = (byte)(value & 0xFF);
            --j;
            value >>>= 8;
        }
    }

    public static Block readIn(RAFFile in, Block block) throws IOException {
        Block.debug("readIn");
        block.number = in.readInt();
        int twoFields = in.readInt();
        block.isLeaf = (twoFields & Integer.MIN_VALUE) != 0;
        block.free = twoFields & Integer.MAX_VALUE;
        in.readFully(block.data);
        return block;
    }

    public void writeOut(RAFFile out) throws IOException {
        out.writeInt(this.number);
        out.writeInt(this.free | (this.isLeaf ? Integer.MIN_VALUE : 0));
        out.write(this.data);
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("Block: " + msg);
        }
    }
}

