/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class FullBtreeDict
extends BtreeDict {
    protected BtreeDictParameters params;
    private boolean update = false;
    private boolean debug = false;

    protected FullBtreeDict() {
    }

    public FullBtreeDict(BtreeDictParameters params, boolean update) throws Exception {
        this.init(params, update, new BlockFactory(){

            public Block makeBlock() {
                return new FullDictBlock();
            }
        });
        this.blocks = new int[300000];
        this.params = params;
        this.update = update;
    }

    public void close(int freeID) throws Exception {
        this.params.setFreeID(freeID);
        if (this.update) {
            this.params.updateSchema();
        }
        super.close();
    }

    public void store(String key, int id) throws Exception {
        byte[] bytes = key.getBytes("UTF8");
        Entry entry = this.insert((FullDictBlock)this.accessBlock(this.root), new Entry(bytes, bytes.length, id));
        if (entry != null) {
            FullDictBlock nbl = this.getNewBlock();
            nbl.initInternal(this.root, entry);
            this.blocks[entry.id] = this.root = nbl.number;
            this.params.setRoot(this.root);
        }
    }

    private void setModified(Block bl) {
        this.blockManager.setModified(bl.number);
    }

    private FullDictBlock getNewBlock() throws Exception {
        FullDictBlock nbl = (FullDictBlock)this.blockManager.getNewBlock();
        this.setModified(nbl);
        return nbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry insert(FullDictBlock bl, Entry ent) throws Exception {
        if (bl.isLeaf) {
            return this.insertHere(bl, ent);
        }
        int index = bl.insertInternal(ent);
        if (index != -1) {
            try {
                this.lock(bl);
                ent = this.insert((FullDictBlock)this.child(bl, index), ent);
                Entry entry = ent == null ? null : this.insertHere(bl, ent);
                return entry;
            }
            finally {
                this.unlock(bl);
            }
        }
        return null;
    }

    private Entry insertHere(FullDictBlock bl, Entry ent) throws Exception {
        this.setModified(bl);
        if (bl.insert(ent)) {
            return null;
        }
        FullDictBlock nbl = this.getNewBlock();
        Entry middle = bl.split(nbl);
        nbl.setBlockNumbers(this.blocks);
        if (!(middle.smallerThan(ent) ? nbl : bl).insert(ent)) {
            throw new Exception("entry didn't fit into a freshly split block");
        }
        return middle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InputStreamReader fr = null;
        try {
            String line;
            Schema schema = new Schema(null, args[0], true);
            BtreeDictParameters tmapParams = new BtreeDictParameters(schema, "TMAP");
            if (!tmapParams.readState()) {
                tmapParams.setBlockSize(2048);
                tmapParams.setRoot(0);
                tmapParams.setFreeID(1);
            }
            FullBtreeDict dict = new FullBtreeDict(tmapParams, true);
            int freeID = tmapParams.getFreeID();
            fr = new FileReader(args[1]);
            LineNumberReader in = new LineNumberReader(new BufferedReader(fr));
            while ((line = in.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " ");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (token.equals("storing")) {
                        dict.store(tokens.nextToken(), freeID++);
                        continue;
                    }
                    if (!token.equals("fetching")) continue;
                    dict.fetch(tokens.nextToken());
                }
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("FullBtreeDict: " + msg);
        }
    }

    protected class FullDictBlock
    extends BtreeDict.DictBlock {
        protected FullDictBlock() {
        }

        public void setFree(int free) {
            this.free = free - this.firstEntry();
            this.data[free + 1] = 0;
            this.data[free] = 0;
        }

        public void setNumberOfEntries(int n) {
            this.setIntegerAt(0, n);
        }

        protected void setChildIndex(int index, int value) {
            this.setIntegerAt(4 * (508 - index + 1), value);
        }

        public void setEntryID(int i, int id) {
            this.setIntegerAt(i + 2, id);
        }

        private boolean insert(Entry entry) {
            byte[] inkey = entry.key;
            int inputKeyLen = inkey.length - 1;
            int freeSpace = this.free();
            int entryPtr = this.firstEntry();
            int nCharsEqual = 0;
            int prevNCEqual = 0;
            int compression = 0;
            int entryIndex = 0;
            while (entryPtr != freeSpace) {
                if (compression == nCharsEqual) {
                    int i;
                    int keyLen = this.entryKeyLength(entryPtr);
                    int keyPtr = this.entryKey(entryPtr);
                    prevNCEqual = nCharsEqual;
                    for (i = 0; i < keyLen && inkey[nCharsEqual] == this.data[keyPtr + i]; ++i) {
                        ++nCharsEqual;
                    }
                    if (i == keyLen) {
                        if (nCharsEqual == inputKeyLen) {
                            this.setEntryID(entryPtr, entry.id);
                            return true;
                        }
                    } else if ((inkey[nCharsEqual] & 0xFF) < (this.data[keyPtr + i] & 0xFF)) {
                        return this.insert(entry, entryPtr, prevNCEqual, nCharsEqual, entryIndex);
                    }
                } else if (compression < nCharsEqual) {
                    return this.insert(entry, entryPtr, nCharsEqual, compression, entryPtr == freeSpace ? this.numberOfEntries() : entryIndex);
                }
                do {
                    entryPtr = this.nextEntry(entryPtr);
                    ++entryIndex;
                } while (this.entryCompression(entryPtr) > nCharsEqual);
                compression = this.entryCompression(entryPtr);
            }
            return this.insert(entry, entryPtr, nCharsEqual, 0, this.numberOfEntries());
        }

        public void makeEntry(int entry, byte[] key, int id, int length, int compr) {
            this.data[entry] = (byte)length;
            this.data[entry + 1] = (byte)compr;
            this.setEntryID(entry, id);
            System.arraycopy(key, compr, this.data, this.entryKey(entry), length);
        }

        private boolean insert(Entry ent, int entryPtr, int compr1, int compr2, int index) {
            int limit;
            byte[] key = ent.key;
            int keyLen = key.length - 1 - compr1;
            int freeSpace = this.free();
            int demand = 6 + keyLen;
            int increase = 0;
            if (entryPtr < freeSpace && this.entryCompression(entryPtr) < compr2) {
                increase = compr2 - this.entryCompression(entryPtr);
            }
            int n = limit = this.isLeaf ? 2038 : 4 * (508 - this.numberOfEntries() - 1);
            if (freeSpace + demand - increase <= limit) {
                if (entryPtr < freeSpace) {
                    int toMove = increase > 0 ? entryPtr + 6 + increase : entryPtr;
                    System.arraycopy(this.data, toMove, this.data, toMove + demand - increase, freeSpace - toMove);
                    if (increase > 0) {
                        int n2 = entryPtr;
                        this.data[n2] = (byte)(this.data[n2] - increase);
                        int n3 = entryPtr + 1;
                        this.data[n3] = (byte)(this.data[n3] + increase);
                        System.arraycopy(this.data, entryPtr, this.data, entryPtr + demand, 6);
                    }
                }
                this.makeEntry(entryPtr, key, ent.id, keyLen, compr1);
                if (!this.isLeaf) {
                    int from = 4 * (508 - this.numberOfEntries() + 1);
                    System.arraycopy(this.data, from, this.data, from - 4, 4 * (this.numberOfEntries() - index));
                    this.setChildIndex(index + 1, ent.block);
                }
                this.setFree(freeSpace + demand - increase);
                this.setNumberOfEntries(this.numberOfEntries() + 1);
                return true;
            }
            return false;
        }

        public int insertInternal(Entry entry) {
            byte[] inkey = entry.key;
            int inputKeyLen = inkey.length - 1;
            int entryPtr = this.firstEntry();
            int freeSpace = this.free();
            int nCharsEqual = 0;
            int compression = 0;
            int entryIndex = 0;
            while (entryPtr != freeSpace) {
                if (compression == nCharsEqual) {
                    int i;
                    int keyLen = this.entryKeyLength(entryPtr);
                    int keyPtr = this.entryKey(entryPtr);
                    for (i = 0; i < keyLen && inkey[nCharsEqual] == this.data[keyPtr + i]; ++i) {
                        ++nCharsEqual;
                    }
                    if (i == keyLen) {
                        if (nCharsEqual == inputKeyLen) {
                            this.setEntryID(entryPtr, entry.id);
                            return -1;
                        }
                    } else if ((inkey[nCharsEqual] & 0xFF) < (this.data[keyPtr + i] & 0xFF)) {
                        return entryIndex;
                    }
                } else if (compression < nCharsEqual) {
                    return entryPtr >= freeSpace ? this.numberOfEntries() : entryIndex;
                }
                do {
                    entryPtr = this.nextEntry(entryPtr);
                    ++entryIndex;
                } while (this.entryCompression(entryPtr) > nCharsEqual);
                compression = this.entryCompression(entryPtr);
            }
            return this.numberOfEntries();
        }

        private Entry split(FullDictBlock newbl) {
            byte[] buffer = new byte[255];
            int freeSpace = this.free();
            int half = freeSpace / 2;
            int index = 0;
            newbl.isLeaf = this.isLeaf;
            int ent = this.firstEntry();
            while (ent < half) {
                this.restoreKeyInBuffer(ent, buffer);
                ++index;
                ent = this.nextEntry(ent);
            }
            int entriesToMove = this.numberOfEntries() - index - 1;
            this.restoreKeyInBuffer(ent, buffer);
            int len = this.entryKeyLength(ent) + this.entryCompression(ent);
            Entry result = new Entry(buffer, len, this.entryID(ent));
            result.block = newbl.number;
            int newFree = ent;
            ent = this.nextEntry(ent);
            this.restoreKeyInBuffer(ent, buffer);
            len = this.entryKeyLength(ent) + this.entryCompression(ent);
            int nptr = this.firstEntry();
            newbl.makeEntry(nptr, buffer, this.entryID(ent), len, 0);
            ent = this.nextEntry(ent);
            System.arraycopy(this.data, ent, newbl.data, newbl.nextEntry(nptr), freeSpace - ent);
            newbl.setNumberOfEntries(entriesToMove);
            newbl.setFree(newbl.nextEntry(nptr) + freeSpace - ent);
            if (!this.isLeaf) {
                int from = 4 * (508 - this.numberOfEntries() + 1);
                System.arraycopy(this.data, from, newbl.data, from + 4 * (index + 1), 4 * (entriesToMove + 1));
            }
            this.setFree(newFree);
            this.setNumberOfEntries(index);
            return result;
        }

        public void initInternal(int leftBlock, Entry entry) {
            this.isLeaf = false;
            this.setNumberOfEntries(1);
            this.setChildIndex(0, leftBlock);
            this.setChildIndex(1, entry.block);
            int ent = this.firstEntry();
            this.makeEntry(ent, entry.key, entry.id, entry.key.length - 1, 0);
            this.setFree(this.nextEntry(ent));
        }
    }

    private final class Entry {
        public byte[] key;
        public int id;
        public int block = -1;

        public Entry(byte[] key, int length, int id) {
            this.key = new byte[length + 1];
            System.arraycopy(key, 0, this.key, 0, length);
            this.key[length] = 0;
            this.id = id;
        }

        public boolean smallerThan(Entry other) {
            for (int i = 0; i < Math.min(this.key.length, other.key.length); ++i) {
                if (this.key[i] == other.key[i]) continue;
                return (this.key[i] & 0xFF) < (other.key[i] & 0xFF);
            }
            return false;
        }
    }
}

