/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class MemoryRAFFile
extends RAFFile {
    private URL url;
    private byte[] data;
    private int size;
    private int filePointer;
    private static boolean debugFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryRAFFile(URLConnection connection) throws IOException {
        this.url = connection.getURL();
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[512];
            int i = 0;
            while ((i = ((InputStream)in).read(buf)) != -1) {
                data.write(buf, 0, i);
            }
            this.data = data.toByteArray();
            this.size = data.size();
            this.filePointer = 0;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public long length() {
        return this.size;
    }

    public void close() throws IOException {
        this.filePointer = 0;
        this.data = null;
        this.size = 0;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos > (long)this.size) {
            throw new IOException();
        }
        this.filePointer = (int)pos;
    }

    public int read() throws IOException {
        if (this.filePointer >= this.size) {
            return -1;
        }
        ++this.filePointer;
        return this.data[this.filePointer - 1] & 0xFF;
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        MemoryRAFFile.debug("readBytes");
        if (this.filePointer + off + len > this.size) {
            throw new IOException();
        }
        this.filePointer += off;
        System.arraycopy(this.data, this.filePointer, b, 0, len);
        this.filePointer += len;
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int readInt() throws IOException {
        MemoryRAFFile.debug("readInt");
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public void writeInt(int v) throws IOException {
        throw new IOException("Unsupported Operation");
    }

    public void write(byte[] b) throws IOException {
        throw new IOException("Unsupported Operation");
    }

    private static void debug(String str) {
        if (debugFlag) {
            System.out.println("MemoryRAFFile: " + str);
        }
    }
}

