/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.DefaultIndexerKit;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;

public class PlainTextIndexerKit
extends DefaultIndexerKit {
    private boolean debugFlag = false;

    public PlainTextIndexerKit() {
        this.locale = Locale.getDefault();
    }

    public Object clone() {
        return new PlainTextIndexerKit();
    }

    public String getContentType() {
        return "text/plain";
    }

    public void parse(Reader in, String file, boolean ignoreCharset, IndexBuilder builder, ConfigFile config) throws IOException {
        int nch;
        this.debug("parsing " + file);
        this.builder = builder;
        this.config = config;
        this.file = file;
        this.documentStarted = false;
        int currentPos = 1;
        char[] buff = new char[4096];
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            currentPos = this.parseIntoTokens(new String(buff), currentPos);
        }
        try {
            this.storeTitle("No Title");
            this.endStoreDocument();
        }
        catch (Exception e2) {
            throw new IOException("Can't store title");
        }
        this.builder = null;
        this.config = null;
    }

    private void debug(String msg) {
        if (this.debugFlag) {
            System.err.println("PlainTextIndexerKit: " + msg);
        }
    }
}

