/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Decompressor;
import com.sun.java.help.search.IntegerArray;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class StreamDecompressor
extends Decompressor {
    private InputStream _input;

    public StreamDecompressor(InputStream input) {
        this.initReading(input);
    }

    public void initReading(InputStream input) {
        this._input = input;
        this.initReading();
    }

    public int getNextByte() throws IOException {
        return this._input.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            FileInputStream file = new FileInputStream(args[0]);
            try {
                int k1 = file.read();
                long start = System.currentTimeMillis();
                System.out.println("k1 = " + k1);
                IntegerArray concepts = new IntegerArray();
                StreamDecompressor documents = new StreamDecompressor(file);
                try {
                    documents.ascDecode(k1, concepts);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                System.out.println("index1 = " + concepts.cardinality());
                int k2 = file.read();
                System.out.println("k2 = " + k2);
                IntegerArray offs = new IntegerArray(concepts.cardinality());
                StreamDecompressor offsets = new StreamDecompressor(file);
                try {
                    offsets.decode(k2, offs);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                System.out.println("index2 = " + offs.cardinality());
                System.out.println(System.currentTimeMillis() - start + " msec");
            }
            catch (IOException e) {
                System.err.println(e);
            }
            finally {
                try {
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
    }
}

