/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.TextHelpModel;

public abstract class Presentation {
    private HelpSet helpset = null;
    private TextHelpModel model = null;
    private Locale locale = null;
    private Font font = null;
    private int width = 645;
    private int height = 495;
    private static final boolean debug = false;

    public static Presentation getPresentation(HelpSet hs, String name) {
        return null;
    }

    public void setHelpSetPresentation(HelpSet.Presentation hsPres) {
        Presentation.debug("setHelpSetPresentation");
        if (hsPres == null) {
            return;
        }
        Dimension size = hsPres.getSize();
        if (size != null) {
            this.setSize(size);
        }
    }

    public Map.ID getCurrentID() {
        Presentation.debug("getCurrentID");
        if (this.model != null) {
            return this.model.getCurrentID();
        }
        return null;
    }

    public void setCurrentID(String id) throws BadIDException {
        Presentation.debug("setCurrentID - String");
        try {
            this.setCurrentID(Map.ID.create(id, this.helpset));
        }
        catch (InvalidHelpSetContextException ex) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        Presentation.debug("setCurrentID - ID");
        this.createHelpModel();
        this.model.setCurrentID(id);
    }

    public URL getCurrentURL() {
        Presentation.debug("getCurrentURL");
        if (this.model != null) {
            return this.model.getCurrentURL();
        }
        return null;
    }

    public void setCurrentURL(URL url) {
        Presentation.debug("setCurrentURL");
        this.createHelpModel();
        this.model.setCurrentURL(url);
    }

    public HelpSet getHelpSet() {
        Presentation.debug("getHelpSet");
        return this.helpset;
    }

    public void setHelpSet(HelpSet hs) {
        Presentation.debug("setHelpSet");
        if (hs != null && this.helpset != hs) {
            this.model = new DefaultHelpModel(hs);
            this.helpset = hs;
        }
    }

    public abstract void setDisplayed(boolean var1);

    public abstract boolean isDisplayed();

    public Font getFont() {
        Presentation.debug("getFont");
        return this.font;
    }

    public void setFont(Font f) {
        Presentation.debug("setFont");
        this.font = f;
    }

    public Locale getLocale() {
        Presentation.debug("getLocale");
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale l) {
        Presentation.debug("setLocale");
        this.locale = l;
    }

    public Dimension getSize() {
        Presentation.debug("getSize");
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        Presentation.debug("setSize");
        this.width = d.width;
        this.height = d.height;
    }

    private void createHelpModel() {
        if (this.model == null) {
            this.model = new DefaultHelpModel(this.helpset);
        }
    }

    protected TextHelpModel getHelpModel() {
        if (this.model == null) {
            this.createHelpModel();
        }
        return this.model;
    }

    private static void debug(Object msg) {
    }
}

