/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.GlossaryView;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.IndexItem;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.JHelpGlossaryNavigator;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.TreeItem;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicIndexCellRenderer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicGlossaryNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ActionListener,
Serializable {
    protected JHelpGlossaryNavigator glossary;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JTextField searchField;
    protected RuleBasedCollator rbc;
    protected String oldText;
    protected DefaultMutableTreeNode currentFindNode;
    protected JHelpContentViewer viewer;
    private static boolean debug = false;

    public static ComponentUI createUI(JComponent x) {
        return new BasicGlossaryNavigatorUI((JHelpGlossaryNavigator)x);
    }

    public BasicGlossaryNavigatorUI(JHelpGlossaryNavigator b) {
        ImageIcon icon = this.getImageIcon(b.getNavigatorView());
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setIcon(UIManager.getIcon("GlossaryNav.icon"));
        }
    }

    public void installUI(JComponent c) {
        BasicGlossaryNavigatorUI.debug("installUI");
        this.glossary = (JHelpGlossaryNavigator)c;
        HelpModel model = this.glossary.getModel();
        if (model == null) {
            throw new NullPointerException("Model is null!");
        }
        this.glossary.setLayout(new BorderLayout());
        this.glossary.addPropertyChangeListener(this);
        if (model != null) {
            // empty if block
        }
        this.topNode = new DefaultMutableTreeNode();
        JLabel search = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(c), "index.findLabel"));
        this.searchField = new JTextField();
        search.setLabelFor(this.searchField);
        this.searchField.addActionListener(this);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        box.add(search);
        box.add(this.searchField);
        this.glossary.add("North", box);
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.glossary.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        JSplitPane splitPane = new JSplitPane(0, false);
        splitPane.setOneTouchExpandable(true);
        splitPane.setTopComponent(this.sp);
        this.viewer = new JHelpContentViewer(model.getHelpSet());
        this.viewer.setSynch(false);
        splitPane.setBottomComponent(this.viewer);
        this.glossary.add("Center", splitPane);
        splitPane.setDividerLocation(180);
        this.reloadData();
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        tree.setCellRenderer(new BasicIndexCellRenderer());
    }

    public void uninstallUI(JComponent c) {
        BasicGlossaryNavigatorUI.debug("uninstallUI");
        HelpModel model = this.glossary.getModel();
        this.glossary.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.glossary.setLayout(null);
        this.glossary.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.glossary = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicGlossaryNavigatorUI.debug("reloadData");
        GlossaryView view = (GlossaryView)this.glossary.getNavigatorView();
        this.loadData(view);
    }

    private void loadData(GlossaryView view) {
        if (view == null) {
            return;
        }
        this.topNode.removeAllChildren();
        String mergeType = view.getMergeType();
        Locale locale = view.getHelpSet().getLocale();
        DefaultMutableTreeNode node = view.getDataAsTree();
        MergeHelpUtilities.mergeNodeChildren(mergeType, node);
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        this.addSubHelpSets(view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void reloadData(HelpModel model) {
        BasicGlossaryNavigatorUI.debug("reloadData in using new model");
        GlossaryView glossaryView = null;
        HelpSet newHelpSet = model.getHelpSet();
        GlossaryView oldView = (GlossaryView)this.glossary.getNavigatorView();
        String oldName = oldView.getName();
        NavigatorView[] navViews = newHelpSet.getNavigatorViews();
        for (int i = 0; i < navViews.length; ++i) {
            NavigatorView tempView;
            if (!navViews[i].getName().equals(oldName) || !((tempView = navViews[i]) instanceof GlossaryView)) continue;
            glossaryView = (GlossaryView)tempView;
            break;
        }
        this.loadData(glossaryView);
    }

    protected void addSubHelpSets(HelpSet hs) {
        BasicGlossaryNavigatorUI.debug("addSubHelpSets");
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                if (!this.glossary.canMerge(views[i])) continue;
                this.merge(views[i]);
            }
            this.addSubHelpSets(ehs);
        }
    }

    private void expand(String target) {
        BasicGlossaryNavigatorUI.debug("expand called");
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicGlossaryNavigatorUI.debug("expandPath :" + node);
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                path = new TreePath(child.getPath());
                this.tree.makeVisible(path);
                continue;
            }
            Object[] treeNode = node.getPath();
            path = new TreePath(treeNode);
            this.tree.makeVisible(path);
        }
    }

    private Vector findNodes(String target) {
        Enumeration<TreeNode> nodes = this.topNode.preorderEnumeration();
        DefaultMutableTreeNode node = null;
        Vector<DefaultMutableTreeNode> nodeFound = new Vector<DefaultMutableTreeNode>();
        while (nodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicGlossaryNavigatorUI.debug(" node :" + node.toString());
            if (node == null) continue;
            IndexItem indexItem = (IndexItem)node.getUserObject();
            if (indexItem == null) {
                BasicGlossaryNavigatorUI.debug("indexItem is null");
                continue;
            }
            Map.ID id = indexItem.getID();
            if (id == null) continue;
            BasicGlossaryNavigatorUI.debug("id name :" + id.id);
            BasicGlossaryNavigatorUI.debug("target :" + target);
            Map.ID itemID = null;
            try {
                itemID = Map.ID.create(target, this.glossary.getModel().getHelpSet());
            }
            catch (BadIDException exp) {
                System.err.println("Not valid ID :" + target);
                break;
            }
            if (!id.equals(itemID)) continue;
            nodeFound.addElement(node);
        }
        return nodeFound;
    }

    private void collapse(String target) {
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        BasicGlossaryNavigatorUI.debug("collapse called");
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (node.getChildCount() > 0) {
                Object[] treeNode = node.getPath();
                path = new TreePath(treeNode);
                this.tree.collapsePath(path);
                this.tree.collapseRow(this.tree.getRowForPath(path));
                continue;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            path = new TreePath(parent.getPath());
            this.tree.collapseRow(this.tree.getRowForPath(path));
        }
    }

    public void doMerge(NavigatorView view) {
        BasicGlossaryNavigatorUI.debug("merging data");
        Merge mergeObject = Merge.DefaultMergeFactory.getMerge(this.glossary.getNavigatorView(), view);
        if (mergeObject != null) {
            mergeObject.processMerge(this.topNode);
        }
    }

    public void merge(NavigatorView view) {
        BasicGlossaryNavigatorUI.debug("merging data");
        this.doMerge(view);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void remove(NavigatorView view) {
        BasicGlossaryNavigatorUI.debug("removing " + view);
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        BasicGlossaryNavigatorUI.debug("remove(" + node + ", " + hs + ")");
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicGlossaryNavigatorUI.debug("  considering " + child);
            IndexItem item = (IndexItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            BasicGlossaryNavigatorUI.debug("chs=" + chs + " hs.contains(chs)=" + hs.contains(chs));
            if (chs != null && hs.contains(chs)) {
                if (child.isLeaf()) {
                    BasicGlossaryNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                this.remove(child, hs);
                if (child.isLeaf()) {
                    BasicGlossaryNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                DefaultMutableTreeNode childOne = (DefaultMutableTreeNode)child.getFirstChild();
                IndexItem itemOne = (IndexItem)childOne.getUserObject();
                item.setHelpSet(itemOne.getHelpSet());
                BasicGlossaryNavigatorUI.debug("  orphaned children - changing hs: " + child);
                continue;
            }
            this.remove(child, hs);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            BasicGlossaryNavigatorUI.debug("  removing " + toRemove.elementAt(i));
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        IndexItem item = (IndexItem)node.getUserObject();
        if (node == this.topNode || item != null && item.getExpansionType() != 0) {
            this.tree.expandPath(new TreePath(node.getPath()));
            if (!node.isLeaf()) {
                int max = node.getChildCount();
                for (int i = 0; i < max; ++i) {
                    this.setVisibility((DefaultMutableTreeNode)node.getChildAt(i));
                }
            }
        }
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        IndexItem item;
        Object o;
        TreePath s;
        Map.ID id = e.getID();
        HelpModel helpModel = this.glossary.getModel();
        BasicGlossaryNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (id == null) {
            // empty if block
        }
        if ((s = this.tree.getSelectionPath()) != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (IndexItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        this.selectNode(node);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicGlossaryNavigatorUI.debug("findID: (" + id + ")");
        BasicGlossaryNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        IndexItem item = (IndexItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            BasicGlossaryNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    protected JHelpContentViewer getContentViewer() {
        return this.viewer;
    }

    private void selectNode(DefaultMutableTreeNode node) {
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.glossary;
    }

    public void valueChanged(TreeSelectionEvent e) {
        IndexItem item;
        JHelpNavigator navigator = this.getHelpNavigator();
        HelpModel helpmodel = navigator.getModel();
        BasicGlossaryNavigatorUI.debug("ValueChanged: " + e);
        BasicGlossaryNavigatorUI.debug("  model: " + helpmodel);
        TreeItem[] items = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            items = new TreeItem[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                items[i] = (TreeItem)node.getUserObject();
            }
        }
        navigator.setSelectedItems(items);
        if (items != null && items.length == 1 && (item = (IndexItem)items[0]) != null && item.getID() != null) {
            try {
                this.getContentViewer().getModel().setCurrentID(item.getID(), item.getName(), navigator);
            }
            catch (InvalidHelpSetContextException ex) {
                System.err.println("BadID: " + item.getID());
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicGlossaryNavigatorUI.debug("propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.glossary) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                BasicGlossaryNavigatorUI.debug("model changed");
                this.reloadData((HelpModel)event.getNewValue());
            } else if (changeName.equals("font")) {
                BasicGlossaryNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            } else if (changeName.equals("expand")) {
                BasicGlossaryNavigatorUI.debug("Expand change");
                this.expand((String)event.getNewValue());
            } else if (changeName.equals("collapse")) {
                BasicGlossaryNavigatorUI.debug("Collapse change");
                this.collapse((String)event.getNewValue());
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.searchField) {
            this.rbc = (RuleBasedCollator)Collator.getInstance(this.glossary.getLocale());
            String text = this.searchField.getText();
            if (text != null) {
                text = text.toLowerCase();
            }
            if (this.oldText != null && this.oldText.compareTo(text) != 0) {
                this.currentFindNode = null;
            }
            this.oldText = text;
            DefaultMutableTreeNode node = this.searchName(this.topNode, text);
            if (node == null) {
                this.currentFindNode = null;
                this.glossary.getToolkit().beep();
                return;
            }
            this.currentFindNode = node;
            TreePath path = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(path);
            this.tree.expandPath(path);
            this.tree.setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode searchName(DefaultMutableTreeNode node, String name) {
        if (this.currentFindNode == null) {
            String itemName;
            IndexItem item = (IndexItem)node.getUserObject();
            if (item != null && (itemName = item.getName()) != null && (itemName = itemName.toLowerCase()).startsWith(name)) {
                return node;
            }
        } else if (this.currentFindNode == node) {
            this.currentFindNode = null;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.searchName(tmp, name);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicGlossaryNavigatorUI: " + str);
        }
    }
}

