/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.SwingHelpUtilities;
import javax.help.WindowPresentation;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public class CSH {
    private static Map comps;
    private static Map parents;
    private static Vector managers;
    private static final boolean debug = false;

    public static void addManager(Manager m) {
        managers.add(m);
    }

    public static void addManager(int i, Manager m) {
        managers.add(i, m);
    }

    public static boolean removeManager(Manager m) {
        return managers.remove(m);
    }

    public static void removeManager(int i) {
        managers.remove(i);
    }

    public static void removeAllManagers() {
        managers.clear();
    }

    public static Manager getManager(int i) {
        return (Manager)managers.get(i);
    }

    public static Manager[] getManagers() {
        return managers.toArray(new Manager[0]);
    }

    public static int getManagerCount() {
        return managers.size();
    }

    private static void _setHelpIDString(Object comp, String helpID) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("HelpID", helpID);
        } else if (comp instanceof Component || comp instanceof MenuItem) {
            Hashtable<String, String> clientProps;
            if (comps == null) {
                comps = new WeakHashMap(5);
            }
            if ((clientProps = (Hashtable<String, String>)comps.get(comp)) != null) {
                if (helpID != null) {
                    clientProps.put("HelpID", helpID);
                } else {
                    clientProps.remove("HelpID");
                    if (clientProps.isEmpty()) {
                        comps.remove(comp);
                    }
                }
            } else if (helpID != null) {
                clientProps = new Hashtable<String, String>(2);
                clientProps.put("HelpID", helpID);
                comps.put(comp, clientProps);
            }
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
    }

    private static String _getHelpIDString(Object comp) {
        String helpID = null;
        if (comp != null) {
            if (comp instanceof JComponent) {
                helpID = (String)((JComponent)comp).getClientProperty("HelpID");
            } else if (comp instanceof Component || comp instanceof MenuItem) {
                Hashtable clientProps;
                if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null) {
                    helpID = (String)clientProps.get("HelpID");
                }
            } else {
                throw new IllegalArgumentException("Invalid Component");
            }
        }
        return helpID;
    }

    private static String _getHelpIDString(Object comp, AWTEvent evt) {
        String helpID = null;
        if (comp != null) {
            Manager[] managers = CSH.getManagers();
            for (int i = 0; i < managers.length; ++i) {
                helpID = managers[i].getHelpIDString(comp, evt);
                if (helpID == null) continue;
                return helpID;
            }
        }
        return null;
    }

    private static Object getParent(Object comp) {
        if (comp == null) {
            return null;
        }
        MenuContainer parent = null;
        if (comp instanceof MenuComponent) {
            parent = ((MenuComponent)comp).getParent();
        } else if (comp instanceof JPopupMenu) {
            parent = ((JPopupMenu)comp).getInvoker();
        } else if (comp instanceof Component) {
            parent = ((Component)comp).getParent();
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (parent == null && parents != null) {
            parent = parents.get(comp);
        }
        return parent;
    }

    public static void setHelpIDString(Component comp, String helpID) {
        CSH._setHelpIDString(comp, helpID);
    }

    public static void setHelpIDString(MenuItem comp, String helpID) {
        CSH._setHelpIDString(comp, helpID);
    }

    public static String getHelpIDString(Object comp, AWTEvent evt) {
        if (comp == null) {
            return null;
        }
        String helpID = CSH._getHelpIDString(comp, evt);
        if (helpID == null) {
            helpID = CSH._getHelpIDString(comp);
        }
        if (helpID == null) {
            helpID = CSH.getHelpIDString(CSH.getParent(comp), evt);
        }
        return helpID;
    }

    public static String getHelpIDString(Component comp) {
        return CSH.getHelpIDString(comp, null);
    }

    public static String getHelpIDString(MenuItem comp) {
        return CSH.getHelpIDString(comp, null);
    }

    private static void _setHelpSet(Object comp, HelpSet hs) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("HelpSet", hs);
        } else if (comp instanceof Component || comp instanceof MenuItem) {
            Hashtable<String, HelpSet> clientProps;
            if (comps == null) {
                comps = new WeakHashMap(5);
            }
            if ((clientProps = (Hashtable<String, HelpSet>)comps.get(comp)) != null) {
                if (hs != null) {
                    clientProps.put("HelpSet", hs);
                } else {
                    clientProps.remove("HelpSet");
                    if (clientProps.isEmpty()) {
                        comps.remove(comp);
                    }
                }
            } else if (hs != null) {
                clientProps = new Hashtable<String, HelpSet>(2);
                clientProps.put("HelpSet", hs);
                comps.put(comp, clientProps);
            }
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
    }

    private static HelpSet _getHelpSet(Object comp) {
        HelpSet hs = null;
        if (comp != null) {
            if (comp instanceof JComponent) {
                hs = (HelpSet)((JComponent)comp).getClientProperty("HelpSet");
            } else if (comp instanceof Component || comp instanceof MenuItem) {
                Hashtable clientProps;
                if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null) {
                    hs = (HelpSet)clientProps.get("HelpSet");
                }
            } else {
                throw new IllegalArgumentException("Invalid Component");
            }
        }
        return hs;
    }

    private static HelpSet _getHelpSet(Object comp, AWTEvent evt) {
        HelpSet hs = null;
        if (comp != null) {
            Manager[] managers = CSH.getManagers();
            for (int i = 0; i < managers.length; ++i) {
                hs = managers[i].getHelpSet(comp, evt);
                if (hs == null) continue;
                return hs;
            }
        }
        return hs;
    }

    public static void setHelpSet(Component comp, HelpSet hs) {
        CSH._setHelpSet(comp, hs);
    }

    public static void setHelpSet(MenuItem comp, HelpSet hs) {
        CSH._setHelpSet(comp, hs);
    }

    public static HelpSet getHelpSet(Object comp, AWTEvent evt) {
        if (comp == null) {
            return null;
        }
        String helpID = CSH._getHelpIDString(comp, evt);
        if (helpID == null) {
            helpID = CSH._getHelpIDString(comp);
        }
        if (helpID != null) {
            HelpSet hs = CSH._getHelpSet(comp, evt);
            if (hs == null) {
                hs = CSH._getHelpSet(comp);
            }
            return hs;
        }
        return CSH.getHelpSet(CSH.getParent(comp), evt);
    }

    public static HelpSet getHelpSet(Component comp) {
        return CSH.getHelpSet(comp, null);
    }

    public static HelpSet getHelpSet(MenuItem comp) {
        return CSH.getHelpSet(comp, null);
    }

    public static Object trackCSEvents() {
        MouseEvent e = CSH.getMouseEvent();
        if (e != null) {
            return CSH.getDeepestObjectAt(e.getSource(), e.getX(), e.getY());
        }
        return null;
    }

    private static void displayHelp(HelpBroker hb, HelpSet hs, String presentation, String presentationName, Object obj, Object source, AWTEvent event) {
        Presentation pres = null;
        if (hb != null) {
            if (hb instanceof DefaultHelpBroker) {
                ((DefaultHelpBroker)hb).setActivationObject(source);
            }
        } else {
            Class[] types = new Class[]{HelpSet.class, String.class};
            Object[] args = new Object[]{hs, presentationName};
            try {
                ClassLoader loader = hs.getLoader();
                Class<?> klass = loader == null ? Class.forName(presentation) : loader.loadClass(presentation);
                Method m = klass.getMethod("getPresentation", types);
                pres = (Presentation)m.invoke(null, args);
            }
            catch (Exception ex) {
                throw new RuntimeException("error invoking presentation");
            }
            if (pres == null) {
                return;
            }
            if (pres instanceof WindowPresentation) {
                ((WindowPresentation)pres).setActivationObject(source);
            }
            if (pres instanceof Popup && obj instanceof Component) {
                ((Popup)pres).setInvoker((Component)obj);
            }
        }
        String helpID = null;
        HelpSet objHS = null;
        helpID = CSH.getHelpIDString(obj, event);
        objHS = CSH.getHelpSet(obj, event);
        if (objHS == null) {
            objHS = hb != null ? hb.getHelpSet() : hs;
        }
        try {
            Map.ID id = Map.ID.create(helpID, objHS);
            if (id == null) {
                id = objHS.getHomeID();
            }
            if (hb != null) {
                hb.setCurrentID(id);
                hb.setDisplayed(true);
            } else {
                pres.setCurrentID(id);
                pres.setDisplayed(true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static MouseEvent getMouseEvent() {
        block14: {
            try {
                if (!EventQueue.isDispatchThread()) break block14;
                EventQueue eq = null;
                try {
                    eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception ee) {
                    CSH.debug(ee);
                }
                if (eq == null) {
                    return null;
                }
                int eventNumber = -1;
                while (true) {
                    ++eventNumber;
                    AWTEvent event = eq.getNextEvent();
                    Object src = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (src instanceof Component) {
                        InputEvent e;
                        if (event instanceof KeyEvent) {
                            e = (KeyEvent)event;
                            if (((KeyEvent)e).getKeyCode() == 3 || ((KeyEvent)e).getKeyCode() == 27) {
                                e.consume();
                                return null;
                            }
                            e.consume();
                            continue;
                        }
                        if (event instanceof MouseEvent) {
                            e = (MouseEvent)event;
                            int eID = e.getID();
                            if ((eID == 500 || eID == 501 || eID == 502) && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                                if (eID == 500 && eventNumber == 0) {
                                    CSH.dispatchEvent(event);
                                    continue;
                                }
                                e.consume();
                                return e;
                            }
                            e.consume();
                            continue;
                        }
                        CSH.dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        if (!(event instanceof InputEvent)) continue;
                        ((InputEvent)event).consume();
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + event);
                }
            }
            catch (InterruptedException e) {
                CSH.debug(e);
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    private static void dispatchEvent(AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else {
            System.err.println("unable to dispatch event: " + event);
        }
    }

    private static Object getDeepestObjectAt(Object parent, int x, int y) {
        Container cont;
        Component child;
        if (parent instanceof Container && (child = CSH.findComponentAt(cont = (Container)parent, cont.getWidth(), cont.getHeight(), x, y)) != null && child != cont) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = (Component)CSH.getDeepestObjectAt(lp, x - b.x, y - b.y);
            }
            if (child != null) {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findComponentAt(Container cont, int width, int height, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            Component c;
            Rectangle rect;
            Component comp;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height || !cont.isVisible() || !cont.isEnabled()) {
                return null;
            }
            Component[] component = cont.getComponents();
            int ncomponents = cont.getComponentCount();
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp instanceof CellRendererPane && (c = CSH.getComponentAt((CellRendererPane)comp, x, y)) != null) {
                    rect = CSH.getRectangleAt((CellRendererPane)comp, x, y);
                    comp = c;
                }
                if (comp == null || comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if ((comp = comp instanceof Container ? CSH.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp instanceof CellRendererPane && (c = CSH.getComponentAt((CellRendererPane)comp, x, y)) != null) {
                    rect = CSH.getRectangleAt((CellRendererPane)comp, x, y);
                    comp = c;
                }
                if (comp == null || !comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if ((comp = comp instanceof Container ? CSH.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            return cont;
        }
    }

    private static Rectangle getRectangleAt(CellRendererPane cont, int x, int y) {
        Rectangle rect = null;
        Container c = cont.getParent();
        if (c instanceof JTable) {
            rect = CSH.getRectangleAt((JTable)c, x, y);
        } else if (c instanceof JTableHeader) {
            rect = CSH.getRectangleAt((JTableHeader)c, x, y);
        } else if (c instanceof JTree) {
            rect = CSH.getRectangleAt((JTree)c, x, y);
        } else if (c instanceof JList) {
            rect = CSH.getRectangleAt((JList)c, x, y);
        }
        return rect;
    }

    private static Component getComponentAt(CellRendererPane cont, int x, int y) {
        Component comp = null;
        Container c = cont.getParent();
        if (c instanceof JTable) {
            comp = CSH.getComponentAt((JTable)c, x, y);
        } else if (c instanceof JTableHeader) {
            comp = CSH.getComponentAt((JTableHeader)c, x, y);
        } else if (c instanceof JTree) {
            comp = CSH.getComponentAt((JTree)c, x, y);
        } else if (c instanceof JList) {
            comp = CSH.getComponentAt((JList)c, x, y);
        }
        if (comp != null) {
            if (parents == null) {
                parents = new WeakHashMap(4){

                    public Object put(Object key, Object value) {
                        return super.put(key, new WeakReference<Object>(value));
                    }

                    public Object get(Object key) {
                        WeakReference wr = (WeakReference)super.get(key);
                        if (wr != null) {
                            return wr.get();
                        }
                        return null;
                    }
                };
            }
            parents.put(comp, cont);
        }
        return comp;
    }

    private static Rectangle getRectangleAt(JTableHeader header, int x, int y) {
        Rectangle rect = null;
        try {
            int column = header.columnAtPoint(new Point(x, y));
            rect = header.getHeaderRect(column);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    private static Component getComponentAt(JTableHeader header, int x, int y) {
        try {
            int columnIndex;
            if (!(header.contains(x, y) && header.isVisible() && header.isEnabled())) {
                return null;
            }
            TableColumnModel columnModel = header.getColumnModel();
            TableColumn column = columnModel.getColumn(columnIndex = columnModel.getColumnIndexAtX(x));
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = header.getDefaultRenderer();
            }
            return renderer.getTableCellRendererComponent(header.getTable(), column.getHeaderValue(), false, false, -1, columnIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JTable table, int x, int y) {
        Rectangle rect = null;
        try {
            Point point = new Point(x, y);
            int row = table.rowAtPoint(point);
            int column = table.columnAtPoint(point);
            rect = table.getCellRect(row, column, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    private static Component getComponentAt(JTable table, int x, int y) {
        try {
            if (!(table.contains(x, y) && table.isVisible() && table.isEnabled())) {
                return null;
            }
            Point point = new Point(x, y);
            int row = table.rowAtPoint(point);
            int column = table.columnAtPoint(point);
            if (table.isEditing() && table.getEditingRow() == row && table.getEditingColumn() == column) {
                return null;
            }
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            return table.prepareRenderer(renderer, row, column);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JTree tree, int x, int y) {
        Rectangle rect = null;
        try {
            TreePath path = tree.getPathForLocation(x, y);
            rect = tree.getPathBounds(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    private static Component getComponentAt(JTree tree, int x, int y) {
        try {
            TreePath path = tree.getPathForLocation(x, y);
            if (tree.isEditing() && tree.getSelectionPath() == path) {
                return null;
            }
            int row = tree.getRowForPath(path);
            Object value = path.getLastPathComponent();
            boolean isSelected = tree.isRowSelected(row);
            boolean isExpanded = tree.isExpanded(path);
            boolean isLeaf = tree.getModel().isLeaf(value);
            boolean hasFocus = tree.hasFocus() && tree.getLeadSelectionRow() == row;
            return tree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JList list, int x, int y) {
        Rectangle rect = null;
        try {
            int index = list.locationToIndex(new Point(x, y));
            rect = list.getCellBounds(index, index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    private static Component getComponentAt(JList list, int x, int y) {
        try {
            int index = list.locationToIndex(new Point(x, y));
            Object value = list.getModel().getElementAt(index);
            boolean isSelected = list.isSelectedIndex(index);
            boolean hasFocus = list.hasFocus() && list.getLeadSelectionIndex() == index;
            return list.getCellRenderer().getListCellRendererComponent(list, value, index, isSelected, hasFocus);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static JPopupMenu getRootPopupMenu(JPopupMenu popup) {
        while (popup != null && popup.getInvoker() instanceof JMenu && popup.getInvoker().getParent() instanceof JPopupMenu) {
            popup = (JPopupMenu)popup.getInvoker().getParent();
        }
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findFocusOwner(JPopupMenu popup) {
        if (popup == null) {
            return null;
        }
        Object object = popup.getTreeLock();
        synchronized (object) {
            if (!popup.isVisible()) {
                return null;
            }
            Component comp = null;
            int n = popup.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = popup.getComponent(i);
                if (c.hasFocus()) {
                    comp = c;
                    break;
                }
                if (c instanceof JMenu && ((JMenu)c).isPopupMenuVisible()) {
                    comp = c;
                }
                if (!(c instanceof JMenuItem) || !((JMenuItem)c).isArmed()) continue;
                comp = c;
            }
            if (comp instanceof JMenu) {
                comp = CSH.findFocusOwner(((JMenu)comp).getPopupMenu());
            }
            if (comp != null) {
                return comp;
            }
        }
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findFocusOwner(Component c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            if (c instanceof JPopupMenu) {
                return CSH.findFocusOwner(CSH.getRootPopupMenu((JPopupMenu)c));
            }
            if (c.hasFocus()) {
                return c;
            }
            if (c instanceof Container) {
                int n = ((Container)c).getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component focusOwner = CSH.findFocusOwner(((Container)c).getComponent(i));
                    if (focusOwner == null) continue;
                    return focusOwner;
                }
            }
            return null;
        }
    }

    private static void debug(Object msg) {
    }

    static {
        managers = new Vector();
    }

    public static interface Manager {
        public HelpSet getHelpSet(Object var1, AWTEvent var2);

        public String getHelpIDString(Object var1, AWTEvent var2);
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;

        public DisplayHelpFromSource(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public DisplayHelpFromSource(HelpSet hs, String presentation, String presentationName) {
            if (hs == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader loader = hs.getLoader();
                if (loader == null) {
                    Class<?> klass = Class.forName(presentation);
                } else {
                    Class<?> klass = loader.loadClass(presentation);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(presentation + "presentation  invalid");
            }
            this.presentation = presentation;
            this.presentationName = presentationName;
            this.hs = hs;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, source, source, e);
        }
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb = null;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;
        private Hashtable cursors;

        public DisplayHelpAfterTracking(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public DisplayHelpAfterTracking(HelpSet hs, String presentation, String presentationName) {
            if (hs == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader loader = hs.getLoader();
                if (loader == null) {
                    Class<?> klass = Class.forName(presentation);
                } else {
                    Class<?> klass = loader.loadClass(presentation);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(presentation + "presentation  invalid");
            }
            this.presentation = presentation;
            this.presentationName = presentationName;
            this.hs = hs;
        }

        public void actionPerformed(ActionEvent e) {
            SwingHelpUtilities.installUIDefaults();
            Cursor onItemCursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (onItemCursor == null) {
                return;
            }
            Vector topComponents = null;
            this.cursors = null;
            if (onItemCursor != null) {
                this.cursors = new Hashtable();
                topComponents = DisplayHelpAfterTracking.getTopContainers(e.getSource());
                Enumeration enum1 = topComponents.elements();
                while (enum1.hasMoreElements()) {
                    this.setAndStoreCursors((Container)enum1.nextElement(), onItemCursor);
                }
            }
            MouseEvent event = CSH.getMouseEvent();
            CSH.debug("CSH.getMouseEvent() >>> " + event);
            if (event != null) {
                Object obj = CSH.getDeepestObjectAt(event.getSource(), event.getX(), event.getY());
                CSH.debug("CSH.getDeepestObjectAt() >>> " + obj);
                if (obj != null) {
                    CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, obj, e.getSource(), event);
                }
            }
            if (topComponents != null) {
                Enumeration containers = topComponents.elements();
                while (containers.hasMoreElements()) {
                    this.resetAndRestoreCursors((Container)containers.nextElement());
                }
            }
            this.cursors = null;
        }

        private static Vector getTopContainers(Object source) {
            Vector<Component> containers = new Vector<Component>();
            Component topComponent = null;
            topComponent = DisplayHelpAfterTracking.getRoot(source);
            if (topComponent instanceof Applet) {
                try {
                    Enumeration<Applet> applets = ((Applet)topComponent).getAppletContext().getApplets();
                    while (applets.hasMoreElements()) {
                        containers.add(applets.nextElement());
                    }
                }
                catch (NullPointerException npe) {
                    containers.add(topComponent);
                }
            }
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                Window[] windows = frames[i].getOwnedWindows();
                for (int j = 0; j < windows.length; ++j) {
                    containers.add(windows[j]);
                }
                if (containers.contains(frames[i])) continue;
                containers.add(frames[i]);
            }
            return containers;
        }

        private static Component getRoot(Object comp) {
            Object parent = comp;
            while (parent != null) {
                comp = parent;
                if (comp instanceof MenuComponent) {
                    parent = ((MenuComponent)comp).getParent();
                    continue;
                }
                if (!(comp instanceof Component) || comp instanceof Window || comp instanceof Applet) break;
                parent = ((Component)comp).getParent();
            }
            if (comp instanceof Component) {
                return (Component)comp;
            }
            return null;
        }

        private void setAndStoreCursors(Component comp, Cursor cursor) {
            if (comp == null) {
                return;
            }
            Cursor compCursor = comp.getCursor();
            if (compCursor != cursor) {
                this.cursors.put(comp, compCursor);
                CSH.debug("set cursor on " + comp);
                comp.setCursor(cursor);
            }
            if (comp instanceof Container) {
                Component[] component = ((Container)comp).getComponents();
                for (int i = 0; i < component.length; ++i) {
                    this.setAndStoreCursors(component[i], cursor);
                }
            }
        }

        private void resetAndRestoreCursors(Component comp) {
            if (comp == null) {
                return;
            }
            Cursor oldCursor = (Cursor)this.cursors.get(comp);
            if (oldCursor != null) {
                CSH.debug("restored cursor " + oldCursor + " on " + comp);
                comp.setCursor(oldCursor);
            }
            if (comp instanceof Container) {
                Component[] component = ((Container)comp).getComponents();
                for (int i = 0; i < component.length; ++i) {
                    this.resetAndRestoreCursors(component[i]);
                }
            }
        }
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb = null;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;

        public DisplayHelpFromFocus(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public DisplayHelpFromFocus(HelpSet hs, String presentation, String presentationName) {
            if (hs == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader loader = hs.getLoader();
                if (loader == null) {
                    Class<?> klass = Class.forName(presentation);
                } else {
                    Class<?> klass = loader.loadClass(presentation);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(presentation + "presentation  invalid");
            }
            this.presentation = presentation;
            this.presentationName = presentationName;
            this.hs = hs;
        }

        public void actionPerformed(ActionEvent e) {
            Component src = (Component)e.getSource();
            if (this.hb instanceof DefaultHelpBroker) {
                ((DefaultHelpBroker)this.hb).setActivationObject(src);
            }
            Component comp = CSH.findFocusOwner(src);
            CSH.debug("focusOwner:" + comp);
            if (comp == null) {
                comp = src;
            }
            CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, comp, comp, e);
        }
    }
}

