/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.MainWindow;
import javax.help.Map;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.SwingHelpUtilities;
import javax.help.UnsupportedOperationException;
import javax.help.WindowPresentation;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class DefaultHelpBroker
implements HelpBroker,
KeyListener {
    private MainWindow mw = null;
    private HelpSet helpKeyHS = null;
    private String helpKeyPresentation = null;
    private String helpKeyPresentationName = null;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;
    private static final boolean debug = false;

    public DefaultHelpBroker(HelpSet hs) {
        this.mw = (MainWindow)MainWindow.getPresentation(hs, null);
    }

    public DefaultHelpBroker() {
        this.mw = (MainWindow)MainWindow.getPresentation(null, null);
    }

    public WindowPresentation getWindowPresentation() {
        return this.mw;
    }

    public HelpSet getHelpSet() {
        return this.mw.getHelpSet();
    }

    public void setHelpSet(HelpSet hs) {
        DefaultHelpBroker.debug("setHelpSet");
        this.mw.setHelpSet(hs);
    }

    public void setHelpSetPresentation(HelpSet.Presentation hsPres) {
        DefaultHelpBroker.debug("setHelpSetPresentation");
        this.mw.setHelpSetPresentation(hsPres);
    }

    public Locale getLocale() {
        return this.mw.getLocale();
    }

    public void setLocale(Locale l) {
        this.mw.setLocale(l);
    }

    public Font getFont() {
        return this.mw.getFont();
    }

    public void setFont(Font f) {
        this.mw.setFont(f);
    }

    public void setCurrentView(String name) {
        this.mw.setCurrentView(name);
    }

    public String getCurrentView() {
        return this.mw.getCurrentView();
    }

    public void initPresentation() {
        this.mw.createHelpWindow();
    }

    public void setDisplayed(boolean b) {
        DefaultHelpBroker.debug("setDisplayed");
        this.mw.setDisplayed(b);
    }

    public boolean isDisplayed() {
        return this.mw.isDisplayed();
    }

    public void setLocation(Point p) {
        this.mw.setLocation(p);
    }

    public Point getLocation() {
        return this.mw.getLocation();
    }

    public void setSize(Dimension d) {
        this.mw.setSize(d);
    }

    public Dimension getSize() throws UnsupportedOperationException {
        return this.mw.getSize();
    }

    public void setScreen(int screen) {
        this.mw.setScreen(screen);
    }

    public int getScreen() throws UnsupportedOperationException {
        return this.mw.getScreen();
    }

    public void setViewDisplayed(boolean displayed) {
        this.mw.setViewDisplayed(displayed);
    }

    public boolean isViewDisplayed() {
        return this.mw.isViewDisplayed();
    }

    public void showID(String id, String presentation, String presentationName) throws BadIDException {
        DefaultHelpBroker.debug("showID - string");
        Presentation pres = this.getPresentation(presentation, presentationName);
        if (pres != null) {
            pres.setCurrentID(id);
            pres.setDisplayed(true);
        }
    }

    public void showID(Map.ID id, String presentation, String presentationName) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("showID - ID");
        Presentation pres = this.getPresentation(presentation, presentationName);
        if (pres != null) {
            pres.setCurrentID(id);
            pres.setDisplayed(true);
        }
    }

    private Presentation getPresentation(String presentation, String presentationName) {
        Presentation pres;
        HelpSet hs = this.mw.getHelpSet();
        if (hs == null) {
            return null;
        }
        Class[] types = new Class[]{HelpSet.class, String.class};
        Object[] args = new Object[]{hs, presentationName};
        try {
            ClassLoader loader = hs.getLoader();
            Class<?> klass = loader == null ? Class.forName(presentation) : loader.loadClass(presentation);
            Method m = klass.getMethod("getPresentation", types);
            pres = (Presentation)m.invoke(null, args);
        }
        catch (ClassNotFoundException cnfex) {
            throw new IllegalArgumentException(presentation + "presentation  invalid");
        }
        catch (Exception ex) {
            throw new RuntimeException("error invoking presentation");
        }
        if (pres == null) {
            return null;
        }
        if (pres instanceof Popup) {
            return null;
        }
        return pres;
    }

    public void setCurrentID(String id) throws BadIDException {
        DefaultHelpBroker.debug("setCurrentID - string");
        this.mw.setCurrentID(id);
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("setCurrentID - ID");
        this.mw.setCurrentID(id);
    }

    public Map.ID getCurrentID() {
        return this.mw.getCurrentID();
    }

    public void setCurrentURL(URL url) {
        DefaultHelpBroker.debug("setCurrentURL");
        this.mw.setCurrentURL(url);
    }

    public URL getCurrentURL() {
        return this.mw.getCurrentURL();
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs) {
        this.enableHelpKey(comp, id, hs, null, null);
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs, String presentation, String presentationName) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (presentation != null && hs == null) {
            throw new IllegalArgumentException("hs");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            ActionListener al = null;
            al = presentation == null ? this.getDisplayHelpFromFocus() : new CSH.DisplayHelpFromFocus(hs, presentation, presentationName);
            root.registerKeyboardAction(al, KeyStroke.getKeyStroke(156, 0), 1);
            root.registerKeyboardAction(al, KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            this.helpKeyHS = hs;
            this.helpKeyPresentation = presentation;
            this.helpKeyPresentationName = presentationName;
            comp.addKeyListener(this);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 112 || code == 156) {
            ActionListener al = null;
            al = this.helpKeyHS != null ? new CSH.DisplayHelpFromFocus(this.helpKeyHS, this.helpKeyPresentation, this.helpKeyPresentationName) : this.getDisplayHelpFromFocus();
            al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
        }
    }

    public void enableHelp(Component comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
    }

    public void enableHelp(MenuItem comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
    }

    public void enableHelpOnButton(Component comp, String id, HelpSet hs) {
        if (!(comp instanceof AbstractButton) && !(comp instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        } else if (comp instanceof Button) {
            Button button = (Button)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem comp, String id, HelpSet hs) {
        if (comp == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        comp.addActionListener(this.getDisplayHelpFromSource());
    }

    public void enableHelpOnButton(Object obj, String id, HelpSet hs, String presentation, String presentationName) {
        if (!(obj instanceof AbstractButton || obj instanceof Button || obj instanceof MenuItem)) {
            throw new IllegalArgumentException("Invalid Object");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (obj instanceof AbstractButton || obj instanceof Button) {
            CSH.setHelpIDString((Component)obj, id);
            if (hs != null) {
                CSH.setHelpSet((Component)obj, hs);
            }
        } else {
            CSH.setHelpIDString((MenuItem)obj, id);
            if (hs != null) {
                CSH.setHelpSet((MenuItem)obj, hs);
            }
        }
        if (presentation == null) {
            if (obj instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)obj;
                button.addActionListener(this.getDisplayHelpFromSource());
            } else if (obj instanceof Button) {
                Button button = (Button)obj;
                button.addActionListener(this.getDisplayHelpFromSource());
            } else if (obj instanceof MenuItem) {
                MenuItem item = (MenuItem)obj;
                item.addActionListener(this.getDisplayHelpFromSource());
            }
        } else if (obj instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)obj;
            button.addActionListener(new CSH.DisplayHelpFromSource(hs, presentation, presentationName));
        } else if (obj instanceof Button) {
            Button button = (Button)obj;
            button.addActionListener(new CSH.DisplayHelpFromSource(hs, presentation, presentationName));
        } else if (obj instanceof MenuItem) {
            MenuItem item = (MenuItem)obj;
            item.addActionListener(new CSH.DisplayHelpFromSource(hs, presentation, presentationName));
        }
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    public void setActivationObject(Object comp) {
        this.mw.setActivationObject(comp);
    }

    public void setActivationWindow(Window window) {
        this.mw.setActivationWindow(window);
    }

    private static void debug(Object msg) {
    }

    static {
        SwingHelpUtilities.installLookAndFeelDefaults();
    }
}

