/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.UnsupportedOperationException;

public class ServletHelpBroker
implements HelpBroker {
    protected HelpSet helpset = null;
    protected DefaultHelpModel model = null;
    protected NavigatorView curNav = null;
    protected boolean viewDisplayed = true;
    protected Locale locale = null;
    protected Font font;
    private static final boolean debug = false;

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public void setHelpSet(HelpSet hs) {
        if (hs != null && this.helpset != hs) {
            this.model = new DefaultHelpModel(hs);
            this.helpset = hs;
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setCurrentView(String name) {
        NavigatorView[] views = this.helpset.getNavigatorViews();
        for (int i = 0; i < views.length; ++i) {
            if (!views[i].getName().equals(name)) continue;
            this.curNav = views[i];
            return;
        }
        throw new IllegalArgumentException("Invalid view name");
    }

    public String getCurrentView() {
        if (this.curNav == null) {
            if (this.helpset != null) {
                NavigatorView[] views = this.helpset.getNavigatorViews();
                this.curNav = views[0];
            } else {
                return null;
            }
        }
        return this.curNav.getName();
    }

    public NavigatorView getCurrentNavigatorView() {
        if (this.curNav == null) {
            if (this.helpset != null) {
                NavigatorView[] views = this.helpset.getNavigatorViews();
                this.curNav = views[0];
            } else {
                return null;
            }
        }
        return this.curNav;
    }

    public void initPresentation() {
    }

    public void setDisplayed(boolean b) {
    }

    public boolean isDisplayed() {
        return true;
    }

    public void setLocation(Point p) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public Point getLocation() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public void setSize(Dimension d) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public Dimension getSize() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public void setScreen(int screen) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public int getScreen() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    public void setViewDisplayed(boolean displayed) {
        this.viewDisplayed = displayed;
    }

    public boolean isViewDisplayed() {
        return this.viewDisplayed;
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create(id, this.helpset));
        }
        catch (InvalidHelpSetContextException ex) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        ServletHelpBroker.debug("setCurrentID");
        this.model.setCurrentID(id);
    }

    public Map.ID getCurrentID() {
        return this.model.getCurrentID();
    }

    public void setCurrentURL(URL url) {
        this.model.setCurrentURL(url);
    }

    public URL getCurrentURL() {
        return this.model.getCurrentURL();
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs) {
    }

    public void enableHelp(Component comp, String id, HelpSet hs) {
    }

    public void enableHelp(MenuItem comp, String id, HelpSet hs) {
    }

    public void enableHelpOnButton(Component comp, String id, HelpSet hs) {
    }

    public void enableHelpOnButton(MenuItem comp, String id, HelpSet hs) {
    }

    public void setHelpSetPresentation(HelpSet.Presentation pres) {
    }

    public void showID(String id, String presentation, String presentationName) throws BadIDException {
    }

    public void showID(Map.ID id, String presentation, String presentationName) throws InvalidHelpSetContextException {
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs, String presentation, String presentationName) {
    }

    public void enableHelpOnButton(Object obj, String id, HelpSet hs, String presentation, String presentationName) {
    }

    private static void debug(Object msg) {
    }
}

