/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;

public abstract class IndexerKit
implements Cloneable {
    protected IndexBuilder builder;
    protected ConfigFile config;
    protected String file;
    protected Locale locale;
    private boolean debugFlag = false;

    public abstract Object clone();

    public abstract String getContentType();

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String lang) {
        Locale newlocale;
        if (lang == null) {
            this.setLocale((Locale)null);
            return;
        }
        String variant = null;
        int lpt = lang.indexOf("_");
        if (lpt == -1) {
            String language = lang;
            String country = "";
            newlocale = new Locale(language, country);
        } else {
            String language = lang.substring(0, lpt);
            int cpt = lang.indexOf("_", lpt + 1);
            if (cpt == -1) {
                String country = lang.substring(lpt + 1);
                newlocale = new Locale(language, country);
            } else {
                String country = lang.substring(lpt + 1, cpt);
                variant = lang.substring(cpt + 1);
                newlocale = new Locale(language, country, variant);
            }
        }
        this.setLocale(newlocale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract void parse(Reader var1, String var2, boolean var3, IndexBuilder var4, ConfigFile var5) throws IOException;

    public abstract int parseIntoTokens(String var1, int var2);

    protected abstract void startStoreDocument(String var1) throws Exception;

    protected abstract void endStoreDocument() throws Exception;

    protected abstract void storeToken(String var1, int var2) throws Exception;

    protected abstract void storeTitle(String var1) throws Exception;

    private void debug(String msg) {
        if (this.debugFlag) {
            System.err.println("IndexerKit: " + msg);
        }
    }
}

