/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ChangedCharSetException;
import com.sun.java.help.search.DefaultIndexerKit;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLIndexerKit
extends DefaultIndexerKit {
    private static HTMLEditorKit.Parser defaultParser = null;
    private static HTMLParserCallback defaultCallback = null;
    private static char[] NEWLINE = new char[1];
    private boolean debugFlag = false;

    public Object clone() {
        return new HTMLIndexerKit();
    }

    public String getContentType() {
        return "text/html";
    }

    public void parse(Reader in, String file, boolean ignoreCharset, IndexBuilder builder, ConfigFile config) throws IOException {
        this.builder = builder;
        this.config = config;
        this.file = file;
        this.documentStarted = false;
        HTMLEditorKit.Parser p = this.getParser();
        if (p == null) {
            throw new IOException("Can't load parser");
        }
        if (defaultCallback == null) {
            defaultCallback = this.getParserCallback(this);
        }
        defaultCallback.initialize();
        try {
            p.parse(in, defaultCallback, ignoreCharset);
        }
        catch (javax.swing.text.ChangedCharSetException e4) {
            throw new ChangedCharSetException(e4.getCharSetSpec(), e4.keyEqualsCharSet());
        }
        try {
            defaultCallback.flush();
        }
        catch (BadLocationException e3) {
            throw new IOException("Can't flush parser");
        }
        try {
            this.storeTitle(defaultCallback.getTitle());
            this.endStoreDocument();
        }
        catch (Exception e2) {
            throw new IOException("Can't store title");
        }
        this.builder = null;
        this.config = null;
    }

    protected HTMLEditorKit.Parser getParser() {
        if (defaultParser == null) {
            try {
                Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (HTMLEditorKit.Parser)c.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return defaultParser;
    }

    public HTMLParserCallback getParserCallback(IndexerKit kit) {
        return new HTMLParserCallback(kit);
    }

    private void debug(String msg) {
        if (this.debugFlag) {
            System.err.println("HTMLIndexerKit: " + msg);
        }
    }

    static {
        HTMLIndexerKit.NEWLINE[0] = 10;
    }

    public class HTMLParserCallback
    extends HTMLEditorKit.ParserCallback {
        private IndexerKit kit;
        private String title;
        private String header;
        private boolean firstHeader;
        private int currentPos;
        private boolean receivedEndHTML;
        private boolean insertAfterImplied;
        private boolean inParagraph;
        private boolean impliedP;
        private boolean inPre;
        private boolean inTextArea;
        private boolean inTitle;
        private boolean lastWasNewline;
        private boolean emptyAnchor;
        private boolean inBody;
        private boolean foundInsertTag;
        private boolean inHead;
        private boolean inStyle;
        private boolean inOption;
        private boolean inFirstHeader;
        private boolean startTagType;
        private boolean preservesUnknownTags;
        Hashtable tagMap;
        int inBlock;
        Stack tagStack;
        String defaultLang;
        String lastLang;

        public HTMLParserCallback(IndexerKit kit) {
            this.kit = kit;
            this.tagMap = new Hashtable(57);
            TagAction na = new TagAction();
            BlockAction ba = new BlockAction();
            ParagraphAction pa = new ParagraphAction();
            CharacterAction ca = new CharacterAction();
            SpecialAction sa = new SpecialAction();
            FormAction fa = new FormAction();
            HiddenAction ha = new HiddenAction();
            ConvertAction conv = new ConvertAction();
            this.tagMap.put(HTML.Tag.A, new AnchorAction());
            this.tagMap.put(HTML.Tag.ADDRESS, ca);
            this.tagMap.put(HTML.Tag.APPLET, ha);
            this.tagMap.put(HTML.Tag.AREA, new AreaAction());
            this.tagMap.put(HTML.Tag.B, ca);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction());
            this.tagMap.put(HTML.Tag.BASEFONT, ca);
            this.tagMap.put(HTML.Tag.BIG, ca);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, ba);
            this.tagMap.put(HTML.Tag.BODY, ba);
            this.tagMap.put(HTML.Tag.BR, sa);
            this.tagMap.put(HTML.Tag.CAPTION, ba);
            this.tagMap.put(HTML.Tag.CENTER, ba);
            this.tagMap.put(HTML.Tag.CITE, ca);
            this.tagMap.put(HTML.Tag.CODE, ca);
            this.tagMap.put(HTML.Tag.DD, ba);
            this.tagMap.put(HTML.Tag.DFN, ca);
            this.tagMap.put(HTML.Tag.DIR, ba);
            this.tagMap.put(HTML.Tag.DIV, ba);
            this.tagMap.put(HTML.Tag.DL, ba);
            this.tagMap.put(HTML.Tag.DT, pa);
            this.tagMap.put(HTML.Tag.EM, ca);
            this.tagMap.put(HTML.Tag.FONT, conv);
            this.tagMap.put(HTML.Tag.FORM, new FormTagAction());
            this.tagMap.put(HTML.Tag.FRAME, sa);
            this.tagMap.put(HTML.Tag.FRAMESET, ba);
            this.tagMap.put(HTML.Tag.H1, pa);
            this.tagMap.put(HTML.Tag.H2, pa);
            this.tagMap.put(HTML.Tag.H3, pa);
            this.tagMap.put(HTML.Tag.H4, pa);
            this.tagMap.put(HTML.Tag.H5, pa);
            this.tagMap.put(HTML.Tag.H6, pa);
            this.tagMap.put(HTML.Tag.HEAD, new HeadAction());
            this.tagMap.put(HTML.Tag.HR, sa);
            this.tagMap.put(HTML.Tag.HTML, ba);
            this.tagMap.put(HTML.Tag.I, conv);
            this.tagMap.put(HTML.Tag.IMG, sa);
            this.tagMap.put(HTML.Tag.INPUT, fa);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(HTML.Tag.KBD, ca);
            this.tagMap.put(HTML.Tag.LI, ba);
            this.tagMap.put(HTML.Tag.LINK, new LinkAction());
            this.tagMap.put(HTML.Tag.MAP, new MapAction());
            this.tagMap.put(HTML.Tag.MENU, ba);
            this.tagMap.put(HTML.Tag.META, new MetaAction());
            HTML.Tag tag = HTML.getTag("NOBR");
            if (tag != null) {
                this.tagMap.put(tag, ca);
            }
            this.tagMap.put(HTML.Tag.NOFRAMES, ba);
            this.tagMap.put(HTML.Tag.OBJECT, sa);
            this.tagMap.put(HTML.Tag.OL, ba);
            this.tagMap.put(HTML.Tag.OPTION, fa);
            this.tagMap.put(HTML.Tag.P, pa);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(HTML.Tag.PRE, new PreAction());
            this.tagMap.put(HTML.Tag.SAMP, ca);
            this.tagMap.put(HTML.Tag.SCRIPT, ha);
            this.tagMap.put(HTML.Tag.SELECT, fa);
            this.tagMap.put(HTML.Tag.SMALL, ca);
            this.tagMap.put(HTML.Tag.STRIKE, conv);
            this.tagMap.put(HTML.Tag.S, ca);
            this.tagMap.put(HTML.Tag.STRONG, ca);
            this.tagMap.put(HTML.Tag.STYLE, new StyleAction());
            this.tagMap.put(HTML.Tag.SUB, conv);
            this.tagMap.put(HTML.Tag.SUP, conv);
            this.tagMap.put(HTML.Tag.TABLE, ba);
            this.tagMap.put(HTML.Tag.TD, ba);
            this.tagMap.put(HTML.Tag.TEXTAREA, fa);
            this.tagMap.put(HTML.Tag.TH, ba);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(HTML.Tag.TR, ba);
            this.tagMap.put(HTML.Tag.TT, ca);
            this.tagMap.put(HTML.Tag.U, conv);
            this.tagMap.put(HTML.Tag.UL, ba);
            this.tagMap.put(HTML.Tag.VAR, ca);
        }

        public void initialize() {
            this.title = null;
            this.header = null;
            this.firstHeader = true;
            this.currentPos = 0;
            this.receivedEndHTML = false;
            this.insertAfterImplied = false;
            this.inParagraph = false;
            this.impliedP = false;
            this.inPre = false;
            this.inTitle = false;
            this.inOption = false;
            this.inFirstHeader = false;
            this.startTagType = false;
            this.emptyAnchor = false;
            this.inBlock = 0;
            this.tagStack = new Stack();
            this.lastLang = this.defaultLang = this.kit.getLocale().toString();
            this.inTextArea = false;
            this.lastWasNewline = false;
            this.inBody = false;
            this.foundInsertTag = true;
            this.preservesUnknownTags = true;
            this.inHead = false;
            this.inStyle = false;
        }

        public String getTitle() {
            if (this.title == null || this.title.length() < 1) {
                this.title = this.header;
                if (this.title == null || this.title.length() < 1) {
                    this.title = "No Title";
                }
            }
            return this.title;
        }

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] data, int pos) {
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inTextArea) {
                if (this.inPre) {
                    this.preContent(data);
                } else if (this.inTitle) {
                    this.titleContent(new String(data));
                } else if (!this.inOption && !this.inStyle && this.inBlock > 0) {
                    if (this.inFirstHeader) {
                        this.headerContent(new String(data));
                    }
                    if (!this.foundInsertTag && this.insertAfterImplied) {
                        this.foundInsertTag(false);
                        this.foundInsertTag = true;
                        this.impliedP = true;
                        this.inParagraph = true;
                    }
                    if (data.length >= 1) {
                        this.addContent(data, 0, data.length);
                    }
                }
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            TagAction action;
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inBody && t == HTML.Tag.BODY) {
                this.inBody = true;
            }
            if ((action = (TagAction)this.tagMap.get(t)) != null) {
                action.start(t, a);
            }
        }

        public void handleComment(char[] data, int pos) {
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inStyle && this.preservesUnknownTags) {
                if (this.inBlock == 0) {
                    return;
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                sas.addAttribute(HTML.Attribute.COMMENT, new String(data));
                this.addSpecialElement(HTML.Tag.COMMENT, sas);
                HTMLIndexerKit.this.debug("comment added currentPos=" + this.currentPos);
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            TagAction action;
            if (this.receivedEndHTML) {
                return;
            }
            if (t == HTML.Tag.HTML) {
                this.receivedEndHTML = true;
            }
            if (t == HTML.Tag.BODY) {
                this.inBody = false;
            }
            if ((action = (TagAction)this.tagMap.get(t)) != null) {
                action.end(t);
            }
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (this.receivedEndHTML) {
                return;
            }
            TagAction action = (TagAction)this.tagMap.get(t);
            if (action != null) {
                action.start(t, a);
                action.end(t);
            } else if (this.preservesUnknownTags) {
                this.addSpecialElement(t, a);
            }
        }

        protected void registerTag(HTML.Tag t, TagAction a) {
            this.tagMap.put(t, a);
        }

        protected void titleContent(String s) {
            if (this.title == null) {
                this.title = new String(s);
            } else {
                this.title.concat(s);
            }
        }

        protected void headerContent(String s) {
            if (this.header == null) {
                this.header = new String(s);
            } else {
                this.header.concat(s);
            }
        }

        protected void preContent(char[] data) {
            int last = 0;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != '\n') continue;
                HTMLIndexerKit.this.debug("preContent currentPos=" + this.currentPos);
                this.addContent(data, last, i - last + 1);
                this.blockClose(HTML.Tag.IMPLIED);
                SimpleAttributeSet a = new SimpleAttributeSet();
                a.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                this.blockOpen(HTML.Tag.IMPLIED, a);
                last = i + 1;
            }
            if (last < data.length) {
                HTMLIndexerKit.this.debug("preContent currentPos=" + this.currentPos);
                this.addContent(data, last, data.length - last);
            }
        }

        protected void blockOpen(HTML.Tag t, MutableAttributeSet attr) {
            HTMLIndexerKit.this.debug("blockOpen");
            if (this.impliedP) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(t, attr, true)) {
                return;
            }
            this.startTagType = true;
            this.lastWasNewline = false;
        }

        protected void blockClose(HTML.Tag t) {
            HTMLIndexerKit.this.debug("blockClose");
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                HTMLIndexerKit.this.debug("blockClose adding NEWLINE currentPos=" + this.currentPos);
                this.addContent(NEWLINE, 0, 1, false);
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                if (t != HTML.Tag.IMPLIED) {
                    this.blockClose(HTML.Tag.IMPLIED);
                }
            }
            if (this.startTagType) {
                char[] one = new char[]{' '};
                HTMLIndexerKit.this.debug("blockclose open/close nocontent currentPos=" + this.currentPos);
                this.addContent(one, 0, 1);
            }
            this.startTagType = false;
        }

        protected void addContent(char[] data, int offs, int length) {
            this.addContent(data, offs, length, true);
        }

        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            HTMLIndexerKit.this.debug("addContent");
            if (!this.foundInsertTag) {
                return;
            }
            if (generateImpliedPIfNecessary && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            HTMLIndexerKit.this.debug("Pre parseIntoTokens String=" + new String(data, offs, length) + " currentPos=" + this.currentPos);
            this.startTagType = false;
            this.currentPos = this.kit.parseIntoTokens(new String(data, offs, length), this.currentPos);
            HTMLIndexerKit.this.debug("Post parseIntoTokens currentPos=" + this.currentPos);
            if (length > 0) {
                this.lastWasNewline = data[offs + length - 1] == '\n';
            }
        }

        protected void addSpecialElement(HTML.Tag t, MutableAttributeSet a) {
            if (t != HTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(t, a, true)) {
                return;
            }
            this.emptyAnchor = false;
            ++this.currentPos;
            HTMLIndexerKit.this.debug("addingSpecialElement tag=" + t + " currentPos=" + this.currentPos);
            this.startTagType = false;
            if (t == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        private boolean canInsertTag(HTML.Tag t, AttributeSet attr, boolean isBlockTag) {
            if (!this.foundInsertTag) {
                this.foundInsertTag(isBlockTag);
                return false;
            }
            return true;
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return false;
        }

        private void foundInsertTag(boolean isBlockTag) {
            this.foundInsertTag = true;
        }

        protected void addTag(HTML.Tag tag, String lang) {
            LangElement el = new LangElement(tag, lang);
            this.tagStack.push(el);
            if (this.lastLang.compareTo(lang) != 0) {
                this.kit.setLocale(lang);
                this.lastLang = lang;
            }
        }

        protected void removeTag(HTML.Tag tag) {
            String name = tag.toString();
            String newLang = this.defaultLang;
            while (!this.tagStack.empty()) {
                LangElement el = (LangElement)this.tagStack.pop();
                if (el.getTag().toString().compareTo(name) != 0) continue;
                if (this.tagStack.empty()) {
                    newLang = this.defaultLang;
                    break;
                }
                el = (LangElement)this.tagStack.peek();
                newLang = el.getLang();
                break;
            }
            if (this.lastLang.compareTo(newLang) != 0) {
                this.kit.setLocale(newLang);
                this.lastLang = newLang;
            }
        }

        public class FormAction
        extends SpecialAction {
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (t == HTML.Tag.TEXTAREA) {
                    HTMLParserCallback.this.inTextArea = true;
                }
                if (t != HTML.Tag.OPTION) {
                    super.start(t, attr);
                }
            }

            public void end(HTML.Tag t) {
                if (t == HTML.Tag.TEXTAREA) {
                    HTMLParserCallback.this.inTextArea = false;
                }
                if (t != HTML.Tag.OPTION) {
                    super.end(t);
                }
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (t != HTML.Tag.PARAM) {
                    super.start(t, a);
                }
            }

            public void end(HTML.Tag t) {
                if (t != HTML.Tag.PARAM) {
                    super.end(t);
                }
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLParserCallback.this.inTitle = true;
                super.start(t, attr);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.inTitle = false;
                super.end(t);
            }
        }

        class AnchorAction
        extends CharacterAction {
            private boolean post4207472;

            AnchorAction() {
                this.post4207472 = this.isPost4207472();
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLParserCallback.this.emptyAnchor = true;
                super.start(t, attr);
            }

            public void end(HTML.Tag t) {
                if (HTMLParserCallback.this.emptyAnchor) {
                    char[] one = new char[]{this.post4207472 ? (char)'\n' : ' '};
                    HTMLIndexerKit.this.debug("emptyAnchor currentPos=" + HTMLParserCallback.this.currentPos);
                    HTMLParserCallback.this.addContent(one, 0, 1);
                }
                super.end(t);
            }

            private boolean isPost4207472() {
                try {
                    String ver = System.getProperty("java.version");
                    int major = Integer.parseInt(ver.substring(2, 3));
                    int minor = 0;
                    if (ver.length() > 6) {
                        minor = Integer.parseInt(ver.substring(6, 8));
                    }
                    return major > 5 || major == 5 && minor >= 4;
                }
                catch (Exception e) {
                    HTMLIndexerKit.this.debug("Exception in isPost4207472 : " + e);
                    return true;
                }
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }
        }

        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                String lang = (String)a.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.removeTag(t);
            }
        }

        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLParserCallback.this.inPre = true;
                HTMLParserCallback.this.blockOpen(t, attr);
                attr.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLParserCallback.this.blockOpen(HTML.Tag.IMPLIED, attr);
                String lang = (String)attr.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.blockClose(HTML.Tag.IMPLIED);
                HTMLParserCallback.this.inPre = false;
                HTMLParserCallback.this.blockClose(t);
                HTMLParserCallback.this.removeTag(t);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (HTMLParserCallback.this.inHead) {
                    HTMLParserCallback.this.inStyle = true;
                }
                super.start(t, a);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.inStyle = false;
                super.end(t);
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                super.start(t, a);
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLParserCallback.this.inHead = true;
                super.start(t, a);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.inHead = (HTMLParserCallback.this.inStyle = false);
                super.end(t);
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                super.start(t, a);
            }

            private boolean isEmpty(HTML.Tag t) {
                return true;
            }
        }

        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                String lang = (String)a.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
                HTMLParserCallback.this.addSpecialElement(t, a);
            }

            public void end(HTML.Tag t) {
                if (!this.isEmpty(t)) {
                    SimpleAttributeSet a = new SimpleAttributeSet();
                    a.addAttribute(HTML.Attribute.ENDTAG, "true");
                    HTMLParserCallback.this.addSpecialElement(t, a);
                }
                HTMLParserCallback.this.removeTag(t);
            }

            private boolean isEmpty(HTML.Tag t) {
                return t != HTML.Tag.APPLET && t != HTML.Tag.TITLE && t != HTML.Tag.SCRIPT;
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLParserCallback.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLParserCallback.this.addSpecialElement(t, a);
                HTMLParserCallback.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                String lang = (String)a.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
                HTMLParserCallback.this.addSpecialElement(t, a);
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (HTMLParserCallback.this.firstHeader && (t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.H5 || t == HTML.Tag.H6)) {
                    HTMLParserCallback.this.inFirstHeader = true;
                }
                super.start(t, a);
                HTMLParserCallback.this.inParagraph = true;
            }

            public void end(HTML.Tag t) {
                if (HTMLParserCallback.this.firstHeader && (t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.H5 || t == HTML.Tag.H6)) {
                    HTMLParserCallback.this.inFirstHeader = false;
                    HTMLParserCallback.this.firstHeader = false;
                }
                super.end(t);
                HTMLParserCallback.this.inParagraph = false;
            }
        }

        private class FormTagAction
        extends BlockAction {
            private FormTagAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                super.start(t, attr);
            }

            public void end(HTML.Tag t) {
                super.end(t);
            }
        }

        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLParserCallback.this.blockOpen(t, attr);
                String lang = (String)attr.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.blockClose(t);
                HTMLParserCallback.this.removeTag(t);
            }
        }

        public class TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                String lang = (String)a.getAttribute(HTML.Attribute.LANG);
                if (lang == null) {
                    lang = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(t, lang);
            }

            public void end(HTML.Tag t) {
                HTMLParserCallback.this.removeTag(t);
            }
        }

        private class LangElement {
            HTML.Tag tag;
            String lang;

            public LangElement(HTML.Tag tag, String lang) {
                this.tag = tag;
                this.lang = lang;
            }

            public HTML.Tag getTag() {
                return this.tag;
            }

            public String getLang() {
                return this.lang;
            }
        }
    }
}

