/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.LiteMorph;
import java.util.StringTokenizer;
import java.util.Vector;

public class Rule {
    private String[] pattern;
    private int killnum = 0;
    private String[] expansions;
    private Vector words;
    private LiteMorph morph;
    private static final boolean debugFlag = false;

    public Rule(String expression, String expansionString, LiteMorph morph) {
        StringTokenizer temp;
        boolean passedPlus = false;
        this.morph = morph;
        if (expression.length() > 0) {
            Vector<String> patternBuffer = new Vector<String>(expression.length());
            temp = new StringTokenizer(expression, " \t\n\r");
            while (temp.hasMoreTokens()) {
                String chars;
                if (passedPlus) {
                    ++this.killnum;
                }
                if ((chars = temp.nextToken()).equals("+")) {
                    passedPlus = true;
                    continue;
                }
                patternBuffer.addElement(chars);
            }
            this.pattern = new String[patternBuffer.size()];
            patternBuffer.copyInto(this.pattern);
        } else {
            this.pattern = new String[0];
        }
        if (expansionString.length() > 0) {
            Vector<String> expansionsBuffer = new Vector<String>(expansionString.length());
            temp = new StringTokenizer(expansionString, ", \t\n\r");
            while (temp.hasMoreTokens()) {
                expansionsBuffer.addElement(temp.nextToken());
            }
            this.expansions = new String[expansionsBuffer.size()];
            expansionsBuffer.copyInto(this.expansions);
        } else {
            this.expansions = new String[0];
        }
    }

    public String[] match(String word, int depth, int skipnum) {
        this.words = new Vector();
        boolean matched = true;
        int position = word.length() - 1 - skipnum;
        int i = this.pattern.length - 1 - skipnum;
        while (i > -1) {
            Rule.debug("   trying " + this.pattern[i] + " at " + position + " for i = " + i);
            if (position < 0) {
                matched = false;
                break;
            }
            if (this.pattern[i].equals("&")) {
                if (position < 1 || word.charAt(position) != word.charAt(position - 1)) {
                    matched = false;
                    break;
                }
                --i;
            } else if (this.pattern[i].startsWith(".")) {
                if (this.pattern[i].indexOf(word.charAt(position), 1) >= 0) {
                    --i;
                }
            } else {
                if (this.pattern[i].indexOf(word.charAt(position)) < 0) {
                    matched = false;
                    break;
                }
                --i;
            }
            --position;
        }
        if (matched) {
            String stem = word.substring(0, word.length() - this.killnum);
            for (i = 0; i < this.expansions.length; ++i) {
                this.makeForm(stem, this.expansions[i], depth);
            }
        }
        Object[] result = new String[this.words.size()];
        this.words.copyInto(result);
        this.words = null;
        return result;
    }

    private void makeForm(String stem, String expansion, int depth) {
        switch (expansion.charAt(0)) {
            case '_': {
                this.words.addElement(stem);
                break;
            }
            case '&': {
                this.words.addElement(stem + stem.charAt(stem.length() - 1) + expansion.substring(1));
                break;
            }
            case '*': {
                Rule.debug(" starting redo: with " + stem + " + " + expansion + " from depth " + depth);
                if (expansion.charAt(1) == '_') {
                    this.morph.morphWord(stem, depth + 1);
                    break;
                }
                this.morph.morphWord(stem + expansion.substring(1), depth + 1);
                break;
            }
            default: {
                this.words.addElement(stem + expansion);
            }
        }
    }

    private static void debug(String str) {
    }
}

