/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jzlib.ZStream;

class test_dict_deflate_inflate {
    static final byte[] dictionary = "hello ".getBytes();
    static final byte[] hello = "hello, hello! ".getBytes();

    static {
        test_dict_deflate_inflate.dictionary[test_dict_deflate_inflate.dictionary.length - 1] = 0;
        test_dict_deflate_inflate.hello[test_dict_deflate_inflate.hello.length - 1] = 0;
    }

    test_dict_deflate_inflate() {
    }

    public static void main(String[] arg) {
        int comprLen;
        int uncomprLen = comprLen = 40000;
        byte[] uncompr = new byte[uncomprLen];
        byte[] compr = new byte[comprLen];
        ZStream c_stream = new ZStream();
        int err = c_stream.deflateInit(9);
        test_dict_deflate_inflate.CHECK_ERR(c_stream, err, "deflateInit");
        err = c_stream.deflateSetDictionary(dictionary, dictionary.length);
        test_dict_deflate_inflate.CHECK_ERR(c_stream, err, "deflateSetDictionary");
        long dictId = c_stream.adler;
        c_stream.next_out = compr;
        c_stream.next_out_index = 0;
        c_stream.avail_out = comprLen;
        c_stream.next_in = hello;
        c_stream.next_in_index = 0;
        c_stream.avail_in = hello.length;
        err = c_stream.deflate(4);
        if (err != 1) {
            System.out.println("deflate should report Z_STREAM_END");
            System.exit(1);
        }
        err = c_stream.deflateEnd();
        test_dict_deflate_inflate.CHECK_ERR(c_stream, err, "deflateEnd");
        ZStream d_stream = new ZStream();
        d_stream.next_in = compr;
        d_stream.next_in_index = 0;
        d_stream.avail_in = comprLen;
        err = d_stream.inflateInit();
        test_dict_deflate_inflate.CHECK_ERR(d_stream, err, "inflateInit");
        d_stream.next_out = uncompr;
        d_stream.next_out_index = 0;
        d_stream.avail_out = uncomprLen;
        while ((err = d_stream.inflate(0)) != 1) {
            if (err == 2) {
                if ((int)d_stream.adler != (int)dictId) {
                    System.out.println("unexpected dictionary");
                    System.exit(1);
                }
                err = d_stream.inflateSetDictionary(dictionary, dictionary.length);
            }
            test_dict_deflate_inflate.CHECK_ERR(d_stream, err, "inflate with dict");
        }
        err = d_stream.inflateEnd();
        test_dict_deflate_inflate.CHECK_ERR(d_stream, err, "inflateEnd");
        int j = 0;
        while (j < uncompr.length) {
            if (uncompr[j] == 0) break;
            ++j;
        }
        System.out.println("after inflateSync(): hel" + new String(uncompr, 0, j));
    }

    static void CHECK_ERR(ZStream z, int err, String msg) {
        if (err != 0) {
            if (z.msg != null) {
                System.out.print(String.valueOf(z.msg) + " ");
            }
            System.out.println(String.valueOf(msg) + " error: " + err);
            System.exit(1);
        }
    }
}

