/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.FavoritesItem;
import javax.help.FavoritesNode;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelpFavoritesNavigator;
import javax.help.NavigatorView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;

public class FavoritesView
extends NavigatorView {
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp Favorites Version 2.0//EN";
    private static boolean warningOfFailures = false;
    private HelpSet hs;
    private boolean enabledSave = true;
    private static final boolean debug = false;

    public FavoritesView(HelpSet hs, String name, String label, Hashtable params) {
        super(hs, name, label, hs.getLocale(), params);
    }

    public FavoritesView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    public Component createNavigator(HelpModel model) {
        return new JHelpFavoritesNavigator(this, model);
    }

    public String getMergeType() {
        String mergeType = super.getMergeType();
        if (mergeType == null) {
            return "javax.help.NoMerge";
        }
        return mergeType;
    }

    public FavoritesNode getDataAsTree() {
        HelpSet hs = this.getHelpSet();
        FavoritesView.debug("helpSet in " + this + hs.toString());
        return this.parse(hs, hs.getLocale(), new DefaultFavoritesFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FavoritesNode parse(HelpSet hs, Locale locale, TreeItemFactory factory) {
        FavoritesNode node = null;
        URL url = null;
        try {
            String user_dir = System.getProperty("user.home");
            File file = new File(user_dir + File.separator + ".JavaHelp" + File.separator + "Favorites.xml");
            if (!file.exists()) {
                return new FavoritesNode(new FavoritesItem("Favorites"));
            }
            try {
                url = file.toURL();
                URLConnection uc = url.openConnection();
                Reader src = XmlReader.createReader(uc);
                try {
                    factory.parsingStarted(url);
                    node = new FavoritesParser(factory).parse(src, hs, locale);
                }
                finally {
                    src.close();
                }
            }
            catch (MalformedURLException e) {
                System.err.println(e);
            }
        }
        catch (Exception e) {
            factory.reportMessage("Exception caught while parsing " + url + e.toString(), false);
        }
        return (FavoritesNode)factory.parsingEnded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFavorites(FavoritesNode node) {
        if (!this.enabledSave) {
            return;
        }
        try {
            FileOutputStream out = null;
            String user_dir = System.getProperty("user.home");
            File file = new File(user_dir + File.separator + ".JavaHelp");
            file.mkdirs();
            String userFile = file.getPath() + File.separator + "Favorites.xml";
            FavoritesView.debug("new file:" + userFile);
            try {
                out = new FileOutputStream(userFile);
                node.export(out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (SecurityException se) {
            this.enabledSave = false;
            se.printStackTrace();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    private static void debug(String msg) {
    }

    private static class FavoritesParser
    implements ParserListener {
        private HelpSet currentParseHS;
        private Stack nodeStack;
        private Stack itemStack;
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private boolean startedfavorites;
        private TreeItemFactory factory;

        FavoritesParser(TreeItemFactory factory) {
            this.factory = factory;
        }

        synchronized FavoritesNode parse(Reader src, HelpSet context, Locale locale) throws IOException {
            this.nodeStack = new Stack();
            this.itemStack = new Stack();
            this.tagStack = new Stack();
            this.defaultLocale = locale == null ? Locale.getDefault() : locale;
            this.lastLocale = this.defaultLocale;
            FavoritesNode node = new FavoritesNode(new FavoritesItem("Favorites"));
            this.nodeStack.push(node);
            this.currentParseHS = context;
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
            return node;
        }

        public void tagFound(ParserEvent e) {
            Locale locale = null;
            Tag tag = e.getTag();
            TagProperties attr = tag.atts;
            if (attr != null) {
                String lang = attr.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(lang);
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (tag.name.equals("favoriteitem")) {
                if (!this.startedfavorites) {
                    this.factory.reportMessage(HelpUtilities.getText("favorites.invalidFavoritesFormat"), false);
                }
                if (tag.isEnd && !tag.isEmpty) {
                    this.nodeStack.pop();
                    this.itemStack.pop();
                    this.removeTag(tag);
                    return;
                }
                TreeItem item = null;
                try {
                    Hashtable t = null;
                    if (attr != null) {
                        t = attr.getHashtable();
                    }
                    item = this.factory.createItem("favoriteitem", t, this.currentParseHS, locale);
                }
                catch (Exception ex) {
                    if (warningOfFailures) {
                        String id = null;
                        if (attr != null) {
                            id = attr.getProperty("target");
                        }
                        System.err.println("Failure in FavoritesItem Creation; ");
                        System.err.println("  id: " + id);
                        System.err.println("  hs: " + this.currentParseHS);
                        ex.printStackTrace();
                    }
                    FavoritesView.debug("empty item !");
                    item = this.factory.createItem();
                }
                FavoritesNode node = new FavoritesNode((FavoritesItem)item);
                FavoritesNode parent = (FavoritesNode)this.nodeStack.peek();
                parent.add(node);
                if (!tag.isEmpty) {
                    this.itemStack.push(item);
                    this.nodeStack.push(node);
                    this.addTag(tag, locale);
                }
            } else if (tag.name.equals("favorites")) {
                if (!tag.isEnd) {
                    String version;
                    if (attr != null && (version = attr.getProperty("version")) != null && version.compareTo("2.0") != 0) {
                        this.factory.reportMessage(HelpUtilities.getText("favorites.unknownVersion", version), false);
                    }
                    if (this.startedfavorites) {
                        this.factory.reportMessage(HelpUtilities.getText("favorites.invalidFavoritesFormat"), false);
                    }
                    this.startedfavorites = true;
                    this.addTag(tag, locale);
                } else {
                    if (this.startedfavorites) {
                        this.startedfavorites = false;
                    }
                    this.removeTag(tag);
                }
                return;
            }
        }

        public void piFound(ParserEvent e) {
        }

        public void doctypeFound(ParserEvent e) {
            this.factory.processDOCTYPE(e.getRoot(), e.getPublicId(), e.getSystemId());
        }

        public void textFound(ParserEvent e) {
            if (this.tagStack.empty()) {
                return;
            }
            LangElement le = (LangElement)this.tagStack.peek();
            Tag tag = le.getTag();
            if (tag.name.equals("favoriteitem")) {
                FavoritesItem item = (FavoritesItem)this.itemStack.peek();
                String oldName = item.getName();
                if (oldName == null) {
                    item.setName(e.getText().trim());
                } else {
                    item.setName(oldName.concat(e.getText()).trim());
                }
            }
        }

        public void commentFound(ParserEvent e) {
        }

        public void errorFound(ParserEvent e) {
            this.factory.reportMessage(e.getText(), false);
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement el = new LangElement(tag, locale);
            this.tagStack.push(el);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            String name = tag.name;
            Locale newLocale = null;
            while (!this.tagStack.empty()) {
                LangElement el = (LangElement)this.tagStack.pop();
                if (el.getTag().name.equals(name)) continue;
                if (this.tagStack.empty()) {
                    newLocale = this.defaultLocale;
                    break;
                }
                el = (LangElement)this.tagStack.peek();
                newLocale = el.getLocale();
                break;
            }
            if (this.lastLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (newLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (!this.lastLocale.equals(newLocale)) {
                this.lastLocale = newLocale;
            }
        }
    }

    public static class DefaultFavoritesFactory
    implements TreeItemFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        public void parsingStarted(URL source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.source = source;
        }

        public void processDOCTYPE(String root, String publicID, String systemID) {
            if (publicID == null || !publicID.equals(FavoritesView.publicIDString)) {
                this.reportMessage(HelpUtilities.getText("favorites.invalidFavoritesFormat", publicID), false);
            }
        }

        public void processPI(HelpSet hs, String target, String data) {
        }

        public TreeItem createItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            if (tagName == null || !tagName.equals("favoriteitem")) {
                throw new IllegalArgumentException("tagName");
            }
            FavoritesItem item = null;
            String target = null;
            String name = null;
            Object mergeType = null;
            String url = null;
            String hstitle = null;
            if (atts != null) {
                target = (String)atts.get("target");
                FavoritesView.debug("target:" + target);
                name = (String)atts.get("text");
                url = (String)atts.get("url");
                hstitle = (String)atts.get("hstitle");
                item = new FavoritesItem(name, target, url, hstitle, locale);
                if (item.getTarget() == null && item.getURLSpec() == null) {
                    item.setAsFolder();
                }
            } else {
                item = new FavoritesItem();
            }
            return item;
        }

        public TreeItem createItem() {
            FavoritesView.debug("empty item created");
            return new FavoritesItem();
        }

        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode back = node;
            if (!this.validParse) {
                back = null;
                System.err.println("Parsing failed for " + this.source);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    System.err.println(msg);
                }
            }
            return back;
        }
    }
}

