/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;

public class BasicCursorFactory {
    private static Cursor onItemCursor;
    private static Cursor dndCursor;
    private static BasicCursorFactory theFactory;
    private static final boolean debug = false;

    public static Cursor getOnItemCursor() {
        BasicCursorFactory.debug("getOnItemCursor");
        if (theFactory == null) {
            theFactory = new BasicCursorFactory();
        }
        if (onItemCursor == null) {
            onItemCursor = theFactory.createCursor("OnItemCursor");
        }
        return onItemCursor;
    }

    public static Cursor getDnDCursor() {
        BasicCursorFactory.debug("getDnDCursor");
        if (theFactory == null) {
            theFactory = new BasicCursorFactory();
        }
        if (dndCursor == null) {
            dndCursor = theFactory.createCursor("DnDCursor");
        }
        return dndCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor createCursor(String name) {
        String gifFile = null;
        String hotspot = null;
        BasicCursorFactory.debug("CreateCursor for " + name);
        InputStream is = this.getClass().getResourceAsStream("images/" + name + ".properties");
        if (is == null) {
            BasicCursorFactory.debug(this.getClass().getName() + "/images/" + name + ".properties not found.");
            return null;
        }
        try {
            PropertyResourceBundle resource = new PropertyResourceBundle(is);
            gifFile = resource.getString("Cursor.File");
            hotspot = resource.getString("Cursor.HotSpot");
        }
        catch (MissingResourceException e) {
            BasicCursorFactory.debug(this.getClass().getName() + "/images/" + name + ".properties invalid.");
            Cursor cursor = null;
            return cursor;
        }
        catch (IOException e2) {
            BasicCursorFactory.debug(this.getClass().getName() + "/images/" + name + ".properties invalid.");
            Cursor cursor = null;
            return cursor;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] buffer = null;
        try {
            InputStream resource = this.getClass().getResourceAsStream(gifFile);
            if (resource == null) {
                BasicCursorFactory.debug(this.getClass().getName() + "/" + gifFile + " not found.");
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer = new byte[1024];
            try {
                int n;
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
            }
            finally {
                in.close();
            }
            out.flush();
            buffer = out.toByteArray();
            if (buffer.length == 0) {
                BasicCursorFactory.debug("warning: " + gifFile + " is zero-length");
                return null;
            }
        }
        catch (IOException ioe) {
            BasicCursorFactory.debug(ioe.toString());
            return null;
        }
        ImageIcon icon = new ImageIcon(buffer);
        int k = hotspot.indexOf(44);
        Point point = new Point(Integer.parseInt(hotspot.substring(0, k)), Integer.parseInt(hotspot.substring(k + 1)));
        BasicCursorFactory.debug("Toolkit fetching cursor");
        try {
            Image image = icon.getImage();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension d = toolkit.getBestCursorSize(width, height);
            if (d.width > width || d.height > height) {
                try {
                    BufferedImage bimage = new BufferedImage(d.width, d.height, 2);
                    Graphics g = ((Image)bimage).getGraphics();
                    try {
                        g.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
                    }
                    finally {
                        g.dispose();
                    }
                    image = bimage;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return toolkit.createCustomCursor(image, point, name);
        }
        catch (NoSuchMethodError err) {
            return null;
        }
    }

    private static void debug(String str) {
    }
}

