/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.AbstractHelpAction;
import javax.help.BackAction;
import javax.help.FavoritesAction;
import javax.help.ForwardAction;
import javax.help.HelpAction;
import javax.help.HelpHistoryModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.JHelpFavoritesNavigator;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.PrintAction;
import javax.help.PrintSetupAction;
import javax.help.SeparatorAction;
import javax.help.SwingHelpUtilities;
import javax.help.plaf.HelpUI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicHelpUI
extends HelpUI
implements PropertyChangeListener,
Serializable {
    protected JHelp help;
    protected JToolBar toolbar;
    protected JSplitPane splitPane;
    protected JTabbedPane tabbedPane;
    protected Vector navs = new Vector();
    private static Dimension PREF_SIZE = new Dimension(600, 600);
    private static Dimension MIN_SIZE = new Dimension(300, 200);
    static boolean noPageSetup = false;
    private int dividerLocation = 0;
    private final double dividerLocationRatio = 0.3;
    private JHelpFavoritesNavigator favorites = null;
    private static boolean debug;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public static ComponentUI createUI(JComponent x) {
        return new BasicHelpUI((JHelp)x);
    }

    public BasicHelpUI(JHelp b) {
        BasicHelpUI.debug("createUI - sort of");
    }

    public void installUI(JComponent c) {
        BasicHelpUI.debug("installUI");
        this.help = (JHelp)c;
        this.help.setLayout(new BorderLayout());
        this.help.addPropertyChangeListener(this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setVisible(false);
        this.splitPane = new JSplitPane(1, false, this.tabbedPane, this.help.getContentViewer());
        this.splitPane.setOneTouchExpandable(true);
        this.help.add("Center", this.splitPane);
        JHelpNavigator first = null;
        Enumeration e = this.help.getHelpNavigators();
        while (e.hasMoreElements()) {
            JHelpNavigator nav = (JHelpNavigator)e.nextElement();
            if (nav instanceof JHelpFavoritesNavigator) {
                this.favorites = (JHelpFavoritesNavigator)nav;
            }
            this.addNavigator(nav);
            if (first != null) continue;
            first = nav;
        }
        BasicHelpUI.debug("setting the current Navigator");
        if (first != null) {
            this.setCurrentNavigator(first);
        }
        this.toolbar = this.createToolBar(HelpUtilities.getLocale(c));
        if (this.toolbar != null) {
            this.toolbar.setFloatable(false);
            this.help.add("North", this.toolbar);
        }
        this.rebuild();
    }

    protected JToolBar createToolBar(Locale locale) {
        this.toolbar = new JToolBar();
        Enumeration actions = null;
        HelpSet.Presentation hsPres = this.help.getHelpSetPresentation();
        HelpModel model = this.getModel();
        if (hsPres != null && hsPres.isToolbar() && model != null) {
            actions = hsPres.getHelpActions(model.getHelpSet(), this.help);
        }
        if (actions == null || !actions.hasMoreElements()) {
            actions = this.createDefaultActions();
        }
        while (actions.hasMoreElements()) {
            HelpAction action = (HelpAction)actions.nextElement();
            if (action instanceof SeparatorAction) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(new HelpButton(action));
        }
        return this.toolbar;
    }

    private Enumeration createDefaultActions() {
        Vector<AbstractHelpAction> actions = new Vector<AbstractHelpAction>(5);
        actions.add(new BackAction(this.help));
        actions.add(new ForwardAction(this.help));
        actions.add(new SeparatorAction(this.help));
        actions.add(new PrintAction(this.help));
        actions.add(new PrintSetupAction(this.help));
        actions.add(new SeparatorAction(this.help));
        if (this.favorites != null) {
            actions.add(new FavoritesAction(this.help));
        }
        return actions.elements();
    }

    public void uninstallUI(JComponent c) {
        BasicHelpUI.debug("uninstallUI");
        this.help.removePropertyChangeListener(this);
        this.help.setLayout(null);
        this.help.removeAll();
        HelpModel hm = this.getModel();
        if (hm != null) {
            // empty if block
        }
        this.help = null;
        this.toolbar = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void rebuild() {
        HelpModel hm = this.getModel();
        if (hm == null) {
            return;
        }
        HelpHistoryModel historyModel = this.getHistoryModel();
        if (historyModel != null) {
            historyModel.discard();
        }
        try {
            Map.ID currentID = hm.getCurrentID();
            if (currentID == null) {
                HelpSet hs = hm.getHelpSet();
                Map.ID homeID = hs.getHomeID();
                Locale locale = hs.getLocale();
                String string = HelpUtilities.getString(locale, "history.homePage");
                hm.setCurrentID(homeID, string, null);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        BasicHelpUI.debug("propertyChange: " + propertyName);
        if (source == this.help) {
            if (propertyName.equals("helpModel")) {
                this.rebuild();
            } else if (propertyName.equals("font")) {
                BasicHelpUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.help.getContentViewer().setFont(newFont);
                this.help.getContentViewer().invalidate();
                Enumeration entries = this.help.getHelpNavigators();
                while (entries.hasMoreElements()) {
                    JHelpNavigator nav = (JHelpNavigator)entries.nextElement();
                    nav.setFont(newFont);
                }
            } else if (propertyName.equals("navigatorDisplayed")) {
                boolean display = (Boolean)event.getNewValue();
                if (display) {
                    this.help.add("Center", this.splitPane);
                } else {
                    this.help.add("Center", this.help.getContentViewer());
                }
            } else if (propertyName.equals("toolbarDisplayed")) {
                this.toolbar.setVisible((Boolean)event.getNewValue());
            }
        }
    }

    protected HelpModel getModel() {
        if (this.help == null) {
            return null;
        }
        return this.help.getModel();
    }

    protected HelpHistoryModel getHistoryModel() {
        if (this.help == null) {
            return null;
        }
        return this.help.getHistoryModel();
    }

    public void addNavigator(JHelpNavigator nav) {
        BasicHelpUI.debug("addNavigator");
        this.navs.addElement(nav);
        Icon icon = null;
        HelpSet.Presentation hsPres = this.help.getHelpSetPresentation();
        if (hsPres != null) {
            if (hsPres.isViewImagesDisplayed()) {
                icon = nav.getIcon();
            }
        } else {
            icon = nav.getIcon();
        }
        if (icon != null) {
            this.tabbedPane.addTab("", icon, nav, nav.getNavigatorLabel());
        } else {
            String name = nav.getNavigatorLabel();
            if (name == null) {
                name = "<unknown>";
            }
            this.tabbedPane.addTab(name, icon, nav);
        }
        nav.setVisible(false);
        this.tabbedPane.setVisible(this.help.isNavigatorDisplayed());
        this.help.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((double)BasicHelpUI.this.dividerLocation == 0.0) {
                    Dimension dem = BasicHelpUI.this.splitPane.getSize();
                    if (dem.width != 0) {
                        BasicHelpUI.this.splitPane.setDividerLocation((int)((double)(dem.width - BasicHelpUI.this.splitPane.getDividerSize()) * 0.3));
                    }
                    BasicHelpUI.this.dividerLocation = BasicHelpUI.this.splitPane.getDividerLocation();
                }
            }
        });
    }

    public void removeNavigator(JHelpNavigator nav) {
        BasicHelpUI.debug("removeNavigator");
        this.navs.removeElement(nav);
        this.tabbedPane.remove(nav);
        this.help.invalidate();
    }

    public Enumeration getHelpNavigators() {
        return this.navs.elements();
    }

    public void setCurrentNavigator(JHelpNavigator nav) {
        try {
            this.tabbedPane.setSelectedComponent(nav);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("JHelpNavigator must be added first");
        }
    }

    public JHelpNavigator getCurrentNavigator() {
        return (JHelpNavigator)this.tabbedPane.getSelectedComponent();
    }

    private ImageIcon getIcon(String name) {
        return BasicHelpUI.getIcon(BasicHelpUI.class, name);
    }

    public static ImageIcon getIcon(Class klass, String name) {
        ImageIcon ig = null;
        try {
            ig = SwingHelpUtilities.getImageIcon(klass, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug || ig == null) {
            System.err.println("GetIcon");
            System.err.println("  name: " + name);
            System.err.println("  klass: " + klass);
            URL url = klass.getResource(name);
            System.err.println("  URL is " + url);
            System.err.println("  ImageIcon is " + ig);
        }
        return ig;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicHelpUI: " + str);
        }
    }

    static {
        boolean on1dot2 = false;
        try {
            Method m = DataFlavor.class.getMethod("getTextPlainUnicodeFlavor", null);
            on1dot2 = m == null;
        }
        catch (NoSuchMethodException e) {
            on1dot2 = true;
        }
        if (on1dot2) {
            String[] osName = new String[]{""};
            osName[0] = System.getProperty("os.name");
            if (osName[0] != null && (osName[0].indexOf("Solaris") != -1 || osName[0].indexOf("SunOS") != -1 || osName[0].indexOf("Linux") != -1 || osName[0].indexOf("HP-UX") != -1)) {
                noPageSetup = true;
            }
        }
        debug = false;
    }

    private class HelpButton
    extends JButton
    implements PropertyChangeListener {
        HelpButton(HelpAction action) {
            this.setEnabled(action.isEnabled());
            String name = (String)action.getValue("name");
            Icon icon = (Icon)action.getValue("icon");
            if (icon == null) {
                icon = UIManager.getIcon("HelpAction.icon");
            }
            this.setIcon(icon);
            Locale locale = null;
            try {
                locale = BasicHelpUI.this.help.getModel().getHelpSet().getLocale();
            }
            catch (NullPointerException npe) {
                locale = Locale.getDefault();
            }
            String tooltip = (String)action.getValue("tooltip");
            this.setToolTipText(tooltip);
            String access = (String)action.getValue("access");
            this.getAccessibleContext().setAccessibleName(access);
            if (action instanceof MouseListener) {
                this.addMouseListener((MouseListener)((Object)action));
            }
            if (action instanceof ActionListener) {
                this.addActionListener((ActionListener)((Object)action));
            }
            action.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                this.setEnabled((Boolean)evt.getNewValue());
            }
        }

        private boolean createEnablePropertyChangeSupport(HelpAction action) {
            boolean back = false;
            try {
                Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BasicHelpUI.class$("java.lang.String")) : class$java$lang$String, class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BasicHelpUI.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
                Method m = action.getClass().getMethod("addPropertyChangeListener", types);
                Object[] args = new Object[]{"enabled", this};
                m.invoke((Object)action, args);
                back = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return back;
        }

        private boolean createPropertyChangeSupport(HelpAction action) {
            boolean back = false;
            try {
                Class[] types = new Class[]{class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BasicHelpUI.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
                Method m = action.getClass().getMethod("addPropertyChangeListener", types);
                Object[] args = new Object[]{this};
                m.invoke((Object)action, args);
                back = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return back;
        }
    }
}

