/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import com.sun.java.help.impl.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.TreeItem;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicIndexCellRenderer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicIndexNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ActionListener,
ComponentListener,
Serializable {
    protected JHelpIndexNavigator index;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JTextField searchField;
    protected RuleBasedCollator rbc;
    protected String oldText;
    protected DefaultMutableTreeNode currentFindNode;
    private SwingWorker worker = null;
    private static boolean debug = false;

    public static ComponentUI createUI(JComponent x) {
        return new BasicIndexNavigatorUI((JHelpIndexNavigator)x);
    }

    public BasicIndexNavigatorUI(JHelpIndexNavigator b) {
        ImageIcon icon = this.getImageIcon(b.getNavigatorView());
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setIcon(UIManager.getIcon("IndexNav.icon"));
        }
    }

    public void installUI(JComponent c) {
        BasicIndexNavigatorUI.debug("installUI");
        this.index = (JHelpIndexNavigator)c;
        HelpModel model = this.index.getModel();
        this.index.setLayout(new BorderLayout());
        this.index.addPropertyChangeListener(this);
        this.index.addComponentListener(this);
        if (model != null) {
            model.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        JLabel search = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(c), "index.findLabel"));
        this.searchField = new JTextField();
        search.setLabelFor(this.searchField);
        this.searchField.addActionListener(this);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        box.add(search);
        box.add(this.searchField);
        this.index.add("North", box);
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.index.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.index.add("Center", this.sp);
        this.reloadData();
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        tree.setCellRenderer(new BasicIndexCellRenderer());
    }

    public void uninstallUI(JComponent c) {
        BasicIndexNavigatorUI.debug("uninstallUI");
        HelpModel model = this.index.getModel();
        this.index.removeComponentListener(this);
        this.index.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.index.setLayout(null);
        this.index.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.index = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicIndexNavigatorUI.debug("reloadData");
        IndexView view = (IndexView)this.index.getNavigatorView();
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = new NavSwingWorker(view);
        this.worker.start(1);
    }

    private synchronized Object loadData(IndexView view) {
        if (view == null) {
            return Boolean.FALSE;
        }
        this.topNode.removeAllChildren();
        String mergeType = view.getMergeType();
        Locale locale = view.getHelpSet().getLocale();
        DefaultMutableTreeNode node = view.getDataAsTree();
        MergeHelpUtilities.mergeNodeChildren(mergeType, node);
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        this.addSubHelpSets(view.getHelpSet());
        return Boolean.TRUE;
    }

    private void presentData() {
        Map.ID id;
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        if (this.index.getModel() != null && (id = this.index.getModel().getCurrentID()) != null) {
            DefaultMutableTreeNode selectedNode = this.findID(this.topNode, id);
            this.selectNode(selectedNode);
        }
    }

    private void reloadData(HelpModel model) {
        BasicIndexNavigatorUI.debug("reloadData in using new model");
        IndexView indexView = null;
        HelpSet newHelpSet = model.getHelpSet();
        IndexView oldView = (IndexView)this.index.getNavigatorView();
        String oldName = oldView.getName();
        NavigatorView[] navViews = newHelpSet.getNavigatorViews();
        for (int i = 0; i < navViews.length; ++i) {
            NavigatorView tempView;
            if (!navViews[i].getName().equals(oldName) || !((tempView = navViews[i]) instanceof IndexView)) continue;
            indexView = (IndexView)tempView;
            break;
        }
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = new NavSwingWorker(indexView);
        this.worker.start(1);
    }

    protected void addSubHelpSets(HelpSet hs) {
        BasicIndexNavigatorUI.debug("addSubHelpSets");
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                if (!this.index.canMerge(views[i])) continue;
                this.doMerge(views[i]);
            }
            this.addSubHelpSets(ehs);
        }
    }

    private void expand(String target) {
        BasicIndexNavigatorUI.debug("expand called");
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicIndexNavigatorUI.debug("expandPath :" + node);
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                path = new TreePath(child.getPath());
                this.tree.makeVisible(path);
                continue;
            }
            Object[] treeNode = node.getPath();
            path = new TreePath(treeNode);
            this.tree.makeVisible(path);
        }
    }

    private Vector findNodes(String target) {
        Enumeration<TreeNode> nodes = this.topNode.preorderEnumeration();
        DefaultMutableTreeNode node = null;
        Vector<DefaultMutableTreeNode> nodeFound = new Vector<DefaultMutableTreeNode>();
        while (nodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicIndexNavigatorUI.debug(" node :" + node.toString());
            if (node == null) continue;
            IndexItem indexItem = (IndexItem)node.getUserObject();
            if (indexItem == null) {
                BasicIndexNavigatorUI.debug("indexItem is null");
                continue;
            }
            Map.ID id = indexItem.getID();
            if (id == null) continue;
            BasicIndexNavigatorUI.debug("id name :" + id.id);
            BasicIndexNavigatorUI.debug("target :" + target);
            Map.ID itemID = null;
            try {
                itemID = Map.ID.create(target, this.index.getModel().getHelpSet());
            }
            catch (BadIDException exp) {
                System.err.println("Not valid ID :" + target);
                break;
            }
            if (!id.equals(itemID)) continue;
            nodeFound.addElement(node);
        }
        return nodeFound;
    }

    private void collapse(String target) {
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        BasicIndexNavigatorUI.debug("collapse called");
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (node.getChildCount() > 0) {
                Object[] treeNode = node.getPath();
                path = new TreePath(treeNode);
                this.tree.collapsePath(path);
                this.tree.collapseRow(this.tree.getRowForPath(path));
                continue;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            path = new TreePath(parent.getPath());
            this.tree.collapseRow(this.tree.getRowForPath(path));
        }
    }

    public void doMerge(NavigatorView view) {
        BasicIndexNavigatorUI.debug("merging data");
        Merge mergeObject = Merge.DefaultMergeFactory.getMerge(this.index.getNavigatorView(), view);
        if (mergeObject != null) {
            mergeObject.processMerge(this.topNode);
        }
    }

    public void merge(NavigatorView view) {
        BasicIndexNavigatorUI.debug("merge");
        this.doMerge(view);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void remove(NavigatorView view) {
        BasicIndexNavigatorUI.debug("removing " + view);
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        BasicIndexNavigatorUI.debug("remove(" + node + ", " + hs + ")");
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicIndexNavigatorUI.debug("  considering " + child);
            IndexItem item = (IndexItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            BasicIndexNavigatorUI.debug("chs=" + chs + " hs.contains(chs)=" + hs.contains(chs));
            if (chs != null && hs.contains(chs)) {
                if (child.isLeaf()) {
                    BasicIndexNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                this.remove(child, hs);
                if (child.isLeaf()) {
                    BasicIndexNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                DefaultMutableTreeNode childOne = (DefaultMutableTreeNode)child.getFirstChild();
                IndexItem itemOne = (IndexItem)childOne.getUserObject();
                item.setHelpSet(itemOne.getHelpSet());
                BasicIndexNavigatorUI.debug("  orphaned children - changing hs: " + child);
                continue;
            }
            this.remove(child, hs);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            BasicIndexNavigatorUI.debug("  removing " + toRemove.elementAt(i));
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        IndexItem item = (IndexItem)node.getUserObject();
        if (node == this.topNode || item != null && item.getExpansionType() != 0) {
            this.tree.expandPath(new TreePath(node.getPath()));
            if (!node.isLeaf()) {
                int max = node.getChildCount();
                for (int i = 0; i < max; ++i) {
                    this.setVisibility((DefaultMutableTreeNode)node.getChildAt(i));
                }
            }
        }
    }

    public synchronized void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        IndexItem item;
        Object o;
        TreePath s;
        Map.ID id = e.getID();
        HelpModel helpModel = this.index.getModel();
        BasicIndexNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            BasicIndexNavigatorUI.debug("Internal inconsistency!");
            BasicIndexNavigatorUI.debug("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (id == null) {
            id = helpModel.getHelpSet().getCombinedMap().getClosestID(e.getURL());
        }
        if ((s = this.tree.getSelectionPath()) != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (IndexItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        this.selectNode(node);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicIndexNavigatorUI.debug("findID: (" + id + ")");
        BasicIndexNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        IndexItem item = (IndexItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            BasicIndexNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private void selectNode(DefaultMutableTreeNode node) {
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.index;
    }

    public void valueChanged(TreeSelectionEvent e) {
        IndexItem item;
        JHelpNavigator navigator = this.getHelpNavigator();
        HelpModel helpmodel = navigator.getModel();
        BasicIndexNavigatorUI.debug("ValueChanged: " + e);
        BasicIndexNavigatorUI.debug("  model: " + helpmodel);
        TreeItem[] items = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            items = new TreeItem[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                items[i] = (TreeItem)node.getUserObject();
            }
        }
        navigator.setSelectedItems(items);
        if (items != null && items.length == 1 && (item = (IndexItem)items[0]) != null && item.getID() != null) {
            Presentation pres;
            String presentation = item.getPresentation();
            if (presentation == null) {
                try {
                    helpmodel.setCurrentID(item.getID(), item.getName(), navigator);
                }
                catch (InvalidHelpSetContextException ex) {
                    System.err.println("BadID: " + item.getID());
                    return;
                }
            }
            HelpSet hs = helpmodel.getHelpSet();
            Class[] types = new Class[]{HelpSet.class, String.class};
            Object[] args = new Object[]{hs, item.getPresentationName()};
            try {
                ClassLoader loader = hs.getLoader();
                Class<?> klass = loader == null ? Class.forName(presentation) : loader.loadClass(presentation);
                Method m = klass.getMethod("getPresentation", types);
                pres = (Presentation)m.invoke(null, args);
            }
            catch (Exception ex) {
                throw new RuntimeException("error invoking presentation");
            }
            if (pres == null) {
                return;
            }
            if (pres instanceof WindowPresentation) {
                ((WindowPresentation)pres).setActivationObject(this.tree);
            }
            if (pres instanceof Popup) {
                ((Popup)pres).setInvokerInternalBounds(this.tree.getPathBounds(paths[0]));
                ((Popup)pres).setInvoker(this.tree);
            }
            try {
                pres.setCurrentID(item.getID());
            }
            catch (InvalidHelpSetContextException ex) {
                System.err.println("BadID: " + item.getID());
                return;
            }
            pres.setDisplayed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicIndexNavigatorUI.debug("propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.index) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                BasicIndexNavigatorUI.debug("model changed");
                this.reloadData((HelpModel)event.getNewValue());
            } else if (changeName.equals("font")) {
                BasicIndexNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.searchField.setFont(newFont);
                RepaintManager.currentManager(this.searchField).markCompletelyDirty(this.searchField);
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            } else if (changeName.equals("expand")) {
                BasicIndexNavigatorUI.debug("Expand change");
                this.expand((String)event.getNewValue());
            } else if (changeName.equals("collapse")) {
                BasicIndexNavigatorUI.debug("Collapse change");
                this.collapse((String)event.getNewValue());
            }
        }
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.searchField.selectAll();
        this.searchField.requestFocus();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.searchField) {
            this.rbc = (RuleBasedCollator)Collator.getInstance(this.index.getLocale());
            String text = this.searchField.getText();
            if (text != null) {
                text = text.toLowerCase();
            }
            if (this.oldText != null && this.oldText.compareTo(text) != 0) {
                this.currentFindNode = null;
            }
            this.oldText = text;
            DefaultMutableTreeNode node = this.searchName(this.topNode, text);
            if (node == null) {
                this.currentFindNode = null;
                this.index.getToolkit().beep();
                return;
            }
            this.currentFindNode = node;
            TreePath path = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(path);
            this.tree.expandPath(path);
            this.tree.setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode searchName(DefaultMutableTreeNode node, String name) {
        if (this.currentFindNode == null) {
            String itemName;
            IndexItem item = (IndexItem)node.getUserObject();
            if (item != null && (itemName = item.getName()) != null && HelpUtilities.isStringInString(this.rbc, name, itemName = itemName.toLowerCase())) {
                return node;
            }
        } else if (this.currentFindNode == node) {
            this.currentFindNode = null;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.searchName(tmp, name);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicIndexNavigatorUI: " + str);
        }
    }

    private class NavSwingWorker
    extends SwingWorker {
        IndexView view;

        public NavSwingWorker(IndexView view) {
            this.view = view;
        }

        public Object construct() {
            return BasicIndexNavigatorUI.this.loadData(this.view);
        }

        public void finished() {
            if ((Boolean)this.get() == Boolean.TRUE) {
                BasicIndexNavigatorUI.this.presentData();
            }
        }
    }
}

