/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.net.URL;
import java.security.AccessControlException;
import org.jdesktop.jdic.browser.ILinkInterceptionHandler;
import org.jdesktop.jdic.browser.OpenLinkEvent;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class DefaultLinkInterceptionHandler
implements ILinkInterceptionHandler {
    @Override
    public boolean shouldOpenLink(OpenLinkEvent openLinkEvent) {
        URL uRL = openLinkEvent.getURL();
        switch (openLinkEvent.getID()) {
            case 1: {
                if (uRL == null) {
                    return true;
                }
                WebBrowserUtil.trace("URL = " + uRL.toString());
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                    }
                    catch (AccessControlException accessControlException) {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (uRL != null) {
                    WebBrowserUtil.trace("willOpenWindow " + uRL.toString());
                }
                return true;
            }
        }
        throw new IllegalStateException("Unhandled window state");
    }
}

