/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.DefaultLinkInterceptionHandler;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.ILinkInterceptionHandler;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.OpenLinkEvent;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.internal.NativeEventThread;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class WebBrowser
extends Canvas
implements IWebBrowser {
    private static final String FILE_PROTOCOL = "file:///";
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String FTP = "ftp";
    private MyFocusListener focusListener = new MyFocusListener();
    private NativeEventThread eventThread;
    private Vector webBrowserListeners = new Vector();
    private int instanceNum;
    private static int lastInstanceNum = 0;
    private boolean isInitialized = false;
    private boolean isJSClose = false;
    private boolean isBackEnabled = false;
    private boolean isForwardEnabled = false;
    private boolean synchronize = false;
    private String initFailureMessage = "WebBrowser is not initialized.";
    private boolean autoDispose = true;
    private URL urlBeforeDispose = null;
    private ILinkInterceptionHandler linkHandler = new DefaultLinkInterceptionHandler();

    @Override
    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    @Override
    public void setInitFailureMessage(String string) {
        this.initFailureMessage = string;
    }

    public WebBrowser() {
        this(true);
    }

    public WebBrowser(boolean bl) {
        this(null, bl);
    }

    public WebBrowser(URL uRL) {
        this(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBrowser(URL uRL, boolean bl) {
        try {
            this.eventThread = NativeEventThread.getInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.autoDispose = bl;
        Class<WebBrowser> clazz = WebBrowser.class;
        synchronized (WebBrowser.class) {
            this.instanceNum = lastInstanceNum++;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            this.eventThread.attachWebBrowser(this);
            if (null != uRL) {
                this.setURL(uRL);
            }
            this.setFocusable(true);
            this.addFocusListener(this.focusListener);
            return;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isInitialized) {
            this.eventThread.fireNativeEvent(this.instanceNum, 1);
            if (this.urlBeforeDispose != null) {
                this.setURL(this.urlBeforeDispose);
                this.urlBeforeDispose = null;
            }
        }
        if (!this.autoDispose) {
            this.setVisible(true);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setVisible(true);
    }

    @Override
    public void removeNotify() {
        if (this.autoDispose) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isInitialized() && (!this.isJSClose || !WebBrowserUtil.IS_OS_LINUX && !WebBrowserUtil.IS_OS_SUNOS)) {
            this.urlBeforeDispose = this.getURL();
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                this.eventThread.fireNativeEvent(this.instanceNum, 2);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.isJSClose) {
            this.isJSClose = false;
        }
        WebBrowser.super.removeNotify();
        this.setInitialized(false);
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setJSclose(boolean bl) {
        this.isJSClose = bl;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.eventThread.fireNativeEvent(this.instanceNum, 4, new Rectangle(n, n2, n3, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchWebBrowserEvent(WebBrowserEvent webBrowserEvent) {
        Vector vector;
        int n;
        Object object;
        Object object2;
        int n2 = webBrowserEvent.getID();
        WebBrowserUtil.trace("Dispatch event from NativeEventThread: " + n2);
        String string = "@" + this.instanceNum + "," + n2 + ",";
        if (3001 == n2) {
            string = string + (this.linkHandler.shouldOpenLink(new OpenLinkEvent(this, 1, webBrowserEvent.getData())) ? "0" : "1");
            this.eventThread.getMessenger().sendMessage(string);
            return;
        }
        if (3002 == n2) {
            string = string + (this.linkHandler.shouldOpenLink(new OpenLinkEvent(this, 2, webBrowserEvent.getData())) ? "0" : "1");
            this.eventThread.getMessenger().sendMessage(string);
            return;
        }
        if (3022 == n2) {
            String string2 = webBrowserEvent.getData();
            if (string2.startsWith("forward")) {
                this.isForwardEnabled = string2.substring(8).equals("1");
                WebBrowserUtil.trace("Forward State changed = " + this.isForwardEnabled);
            } else if (string2.startsWith("back")) {
                this.isBackEnabled = string2.substring(5).equals("1");
                WebBrowserUtil.trace("Back State changed = " + this.isBackEnabled);
            }
            return;
        }
        if (3043 == n2) {
            WebBrowserUtil.trace("Got event from brower: Focus request.");
            this.requestFocus();
            return;
        }
        if (3044 == n2) {
            WebBrowserUtil.trace("Got event from brower: Destory window succeeds.");
            object2 = this;
            synchronized (object2) {
                this.notify();
            }
        } else if (3034 == n2 && (object2 = webBrowserEvent.getData()) != null) {
            int n3 = 0;
            int n4 = 0;
            object = new StringTokenizer((String)object2, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (string3 == null) continue;
                if (string3.startsWith("CtrlKeyDown=") && WebBrowser.isPressed("CtrlKeyDown=", string3)) {
                    n4 = 2;
                    continue;
                }
                if (string3.startsWith("AltKeyDown=") && WebBrowser.isPressed("AltKeyDown=", string3)) {
                    n4 = 8;
                    continue;
                }
                if (string3.startsWith("ShiftDown=") && WebBrowser.isPressed("ShiftDown=", string3)) {
                    n4 = 1;
                    continue;
                }
                if (!string3.startsWith("KeyCode=")) continue;
                n3 = Integer.parseInt(string3.replaceFirst("KeyCode=", ""));
            }
            WebBrowser.fireMenuKeyEvent(n4, n3);
        }
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            n = this.webBrowserListeners.size();
            if (n == 0) {
                return;
            }
            vector = (Vector)this.webBrowserListeners.clone();
        }
        block18: for (int i = 0; i < n; ++i) {
            object = (WebBrowserListener)vector.elementAt(i);
            switch (n2) {
                case 3042: {
                    object.initializationCompleted(webBrowserEvent);
                    continue block18;
                }
                case 3003: {
                    object.downloadStarted(webBrowserEvent);
                    continue block18;
                }
                case 3004: {
                    object.downloadCompleted(webBrowserEvent);
                    continue block18;
                }
                case 3005: {
                    object.downloadProgress(webBrowserEvent);
                    continue block18;
                }
                case 3006: {
                    object.downloadError(webBrowserEvent);
                    continue block18;
                }
                case 3007: {
                    object.documentCompleted(webBrowserEvent);
                    continue block18;
                }
                case 3023: {
                    object.titleChange(webBrowserEvent);
                    continue block18;
                }
                case 3024: {
                    object.statusTextChange(webBrowserEvent);
                    continue block18;
                }
                case 3037: {
                    this.isJSClose = true;
                    object.windowClose(webBrowserEvent);
                }
            }
        }
    }

    private static boolean isPressed(String string, String string2) {
        return Integer.parseInt(string2.replaceFirst(string, "")) == 1;
    }

    private static void fireMenuKeyEvent(int n, int n2) {
        WebBrowser webBrowser = new WebBrowser();
        KeyEvent keyEvent = null;
        keyEvent = new KeyEvent(webBrowser, 401, System.currentTimeMillis(), n, n2, '\u0000');
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.getSystemEventQueue().postEvent(keyEvent);
    }

    @Override
    public synchronized void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (!this.webBrowserListeners.contains(webBrowserListener)) {
            this.webBrowserListeners.addElement(webBrowserListener);
        }
    }

    @Override
    public synchronized void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (webBrowserListener == null) {
            return;
        }
        this.webBrowserListeners.removeElement(webBrowserListener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return this.webBrowserListeners.toArray(new WebBrowserListener[0]);
    }

    @Override
    public URL getURL() {
        this.eventThread.fireNativeEvent(this.instanceNum, 12);
        if (this.waitForResult()) {
            try {
                return new URL(this.eventThread.getEventRetString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setURL() {
        this.eventThread.fireNativeEvent(this.instanceNum, 5, "about:blank");
    }

    @Override
    public void setURL(URL uRL) {
        this.setURL(uRL, null);
    }

    @Override
    public void setURL(URL uRL, String string) {
        this.setURL(uRL, string, null);
    }

    @Override
    public void setURL(URL uRL, String string, String string2) {
        if (uRL == null) {
            return;
        }
        String string3 = uRL.toString();
        if (uRL.getProtocol().equals(FILE)) {
            String string4 = uRL.getFile();
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            File file = new File(string4);
            try {
                String string5 = file.getCanonicalFile().getAbsolutePath();
                string3 = FILE_PROTOCOL + string5;
            }
            catch (IOException iOException) {
                WebBrowserUtil.error(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (!WebBrowser.isNativeSafe(uRL) && uRL.getProtocol().equals(JAR)) {
            try {
                string3 = WebBrowser.toFileUrl(uRL).toString();
            }
            catch (IOException iOException) {
                WebBrowserUtil.error(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (string == null && string2 == null) {
            this.eventThread.fireNativeEvent(this.instanceNum, 5, string3);
        } else {
            this.eventThread.fireNativeEvent(this.instanceNum, 6, string3 + this.instanceNum + "," + 6 + "," + (string == null ? "" : string) + this.instanceNum + "," + 6 + "," + (string2 == null ? "" : string2));
        }
    }

    private static boolean isNativeSafe(URL uRL) {
        String string = uRL.getProtocol().intern();
        return string.equals(HTTP) || string.equals(HTTPS) || string.equals(FILE) || string.equals(FTP);
    }

    public static URL toFileUrl(URL uRL) throws IOException {
        File file = null;
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        String string = jarURLConnection.getEntryName();
        String string2 = System.getProperty("java.io.tmpdir");
        WebBrowserUtil.trace("using system tmp path " + string2);
        File file2 = new File(string2);
        File file3 = new File(file2.getCanonicalFile().getAbsolutePath() + File.separator + "jartemp");
        if (!WebBrowserUtil.IS_OS_WINDOWS) {
            Runtime.getRuntime().exec("chmod a+wr " + file2);
        }
        if (!file3.exists()) {
            WebBrowserUtil.trace(file3.getAbsolutePath() + " doesn't exist.");
            file3.mkdirs();
            WebBrowserUtil.trace(file3.getAbsolutePath() + " is created.");
        }
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).equals(string)) continue;
            file = new File(file3, string3);
            file.getParentFile().mkdirs();
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            WebBrowserUtil.copyIsToOs(inputStream, fileOutputStream);
        }
        WebBrowserUtil.trace("realFile.getAbsolutePath=" + file.getAbsolutePath());
        WebBrowserUtil.trace("realFile.toURL=" + file.toURI().toURL());
        return file.toURI().toURL();
    }

    public void syncSetURL(URL uRL) throws JdicInitException {
        this.syncSetURL(uRL, null, null);
    }

    public void syncSetURL(URL uRL, String string) throws JdicInitException {
        this.syncSetURL(uRL, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSetURL(URL uRL, String string, String string2) throws JdicInitException {
        try {
            this.synchronize = true;
            if (!this.isInitialized) {
                WebBrowserUtil.error("You can't call this method before WebBrowser is initialized!");
                throw new JdicInitException("You can't call this method before WebBrowser is initialized!");
            }
            this.setURL(uRL, string, string2);
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(exception.getMessage());
                }
            }
        }
        finally {
            this.synchronize = false;
        }
    }

    @Override
    public void back() {
        this.eventThread.fireNativeEvent(this.instanceNum, 8);
    }

    @Override
    public void forward() {
        this.eventThread.fireNativeEvent(this.instanceNum, 9);
    }

    @Override
    public void refresh() {
        this.eventThread.fireNativeEvent(this.instanceNum, 10);
    }

    @Override
    public void stop() {
        this.eventThread.fireNativeEvent(this.instanceNum, 11);
    }

    @Override
    public void shutdown() {
        this.eventThread.fireNativeEvent(this.instanceNum, 3);
    }

    public void print() {
        this.executeScript("window.print();");
    }

    @Override
    public void setContent(String string) {
        this.eventThread.fireNativeEvent(this.instanceNum, 16, string);
    }

    @Override
    public String getContent() {
        this.eventThread.fireNativeEvent(this.instanceNum, 15);
        if (this.waitForResult()) {
            try {
                return this.eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String executeScript(String string) {
        this.eventThread.fireNativeEvent(this.instanceNum, 17, string);
        if (this.waitForResult()) {
            try {
                return this.eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDebug(boolean bl) {
        WebBrowserUtil.enableDebugMessages(bl);
    }

    public static String getBrowserBinary() {
        return BrowserEngineManager.instance().getActiveEngine().getEmbeddedBinaryName();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isBackEnabled() {
        return this.isBackEnabled;
    }

    @Override
    public boolean isForwardEnabled() {
        return this.isForwardEnabled;
    }

    @Override
    public int getInstanceNum() {
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult() {
        if (!this.isInitialized) {
            WebBrowserUtil.trace("You can't call this method before WebBrowser is initialized!");
            return false;
        }
        boolean bl = false;
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            try {
                this.wait();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return bl;
    }

    @Override
    public int getNativeWindow() {
        return this.nativeGetWindow(System.getProperty("java.home"));
    }

    private native int nativeGetWindow(String var1);

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public IBrowserEngine getBrowserEngine() {
        return BrowserEngineManager.instance().getActiveEngine();
    }

    @Override
    public String getInitFailureMessage() {
        return this.initFailureMessage;
    }

    @Override
    public boolean isSynchronize() {
        return this.synchronize;
    }

    @Override
    public void setLinkInterceptionHandler(ILinkInterceptionHandler iLinkInterceptionHandler) {
        if (iLinkInterceptionHandler == null) {
            throw new NullPointerException("handler must not be null");
        }
        this.linkHandler = iLinkInterceptionHandler;
    }

    @Override
    public void setAutoDispose(boolean bl) {
        this.autoDispose = bl;
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusGained\n");
            WebBrowser.this.eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 13);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusLost\n");
            WebBrowser.this.eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 14);
        }
    }
}

