/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.internal.NativeEventData;
import org.jdesktop.jdic.browser.internal.NativeEventThread;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class MsgClient {
    private static final int MAX_RETRY = 30;
    private static final int BUFFERSIZE = 2048;
    private static final String MSG_DELIMITER = "</html><body></html>";
    private static final String MSG_DELIMITER_ = "</html><body></html>_";
    private static final String MSG_DELIMITER_HEAD = "</html><body></html>_head";
    private static final String MSG_DELIMITER_MIDDLE = "</html><body></html>_middle";
    private static final String MSG_DELIMITER_END = "</html><body></html>_end";
    private Selector selector = null;
    private SocketChannel channel = null;
    private int port;
    private InetSocketAddress serverAddr;
    private String charsetName = null;
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private ByteBuffer buffer;
    private CharBuffer charBuffer;
    private String sendBuffer = new String();
    private String recvBuffer = new String();
    private static Set msgPieces = new HashSet();

    public MsgClient() {
        WebBrowserUtil.trace("Msg Client started");
        this.charsetName = BrowserEngineManager.instance().getActiveEngine().getCharsetName();
        Charset charset = Charset.forName(this.charsetName);
        this.decoder = charset.newDecoder();
        this.encoder = charset.newEncoder();
        this.buffer = ByteBuffer.allocateDirect(2048);
        this.charBuffer = CharBuffer.allocate(2048);
        try {
            this.selector = Selector.open();
            this.port = this.findAFreePort();
            this.serverAddr = new InetSocketAddress("localhost", this.port);
            WebBrowserUtil.trace("Found a free socket port: " + this.port);
        }
        catch (Exception exception) {
            WebBrowserUtil.error(exception.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    void connect() throws IOException, InterruptedException {
        int n;
        for (n = 0; n < 30; ++n) {
            WebBrowserUtil.trace("Connecting to native browser ... " + n);
            try {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                this.channel.connect(this.serverAddr);
                this.channel.register(this.selector, 8);
                block5: while (!this.channel.isConnected()) {
                    if (this.selector.select() <= 0) continue;
                    Set<SelectionKey> set = this.selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                        if (!selectionKey.isConnectable()) continue;
                        if (!socketChannel.isConnectionPending()) continue block5;
                        socketChannel.finishConnect();
                        continue block5;
                    }
                }
                break;
            }
            catch (Exception exception) {
                WebBrowserUtil.trace(exception.toString());
                this.channel.close();
                this.channel = null;
                try {
                    Thread.sleep(150L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n == 30) {
            throw new InterruptedException("Maximum retry number reached!");
        }
        WebBrowserUtil.trace("connected");
        this.channel.keyFor(this.selector).interestOps(5);
    }

    public void sendMessage(String string) {
        this.sendBuffer = this.sendBuffer + string + MSG_DELIMITER;
    }

    public String getMessage() {
        int n = this.recvBuffer.indexOf(MSG_DELIMITER);
        if (n < 0) {
            return null;
        }
        String string = this.recvBuffer.substring(0, n);
        if (n != this.recvBuffer.indexOf(MSG_DELIMITER_)) {
            this.recvBuffer = this.recvBuffer.substring(n + new String(MSG_DELIMITER).length());
            WebBrowserUtil.trace("Got a complete short message: " + string);
            return string;
        }
        NativeEventData nativeEventData = NativeEventThread.parseMessageString(string);
        if (n == this.recvBuffer.indexOf(MSG_DELIMITER_HEAD)) {
            msgPieces.add(new NativeEventData(nativeEventData.instance, nativeEventData.type, nativeEventData.stringValue));
            this.recvBuffer = this.recvBuffer.substring(n + new String(MSG_DELIMITER_HEAD).length());
            WebBrowserUtil.trace("Got a head message piece: " + nativeEventData.stringValue);
            return null;
        }
        for (NativeEventData nativeEventData2 : msgPieces) {
            if (nativeEventData2.instance != nativeEventData.instance || nativeEventData2.type != nativeEventData.type) continue;
            if (n == this.recvBuffer.indexOf(MSG_DELIMITER_MIDDLE)) {
                NativeEventData nativeEventData3 = new NativeEventData(nativeEventData.instance, nativeEventData.type, nativeEventData2.stringValue + nativeEventData.stringValue);
                msgPieces.remove(nativeEventData2);
                msgPieces.add(nativeEventData3);
                this.recvBuffer = this.recvBuffer.substring(n + new String(MSG_DELIMITER_MIDDLE).length());
                WebBrowserUtil.trace("Got a middle message piece: " + nativeEventData.stringValue);
                return null;
            }
            if (n != this.recvBuffer.indexOf(MSG_DELIMITER_END)) continue;
            string = nativeEventData.instance + "," + nativeEventData.type + "," + nativeEventData2.stringValue + nativeEventData.stringValue;
            msgPieces.remove(nativeEventData2);
            this.recvBuffer = this.recvBuffer.substring(n + new String(MSG_DELIMITER_END).length());
            WebBrowserUtil.trace("Got an end message piece: " + nativeEventData.stringValue);
            WebBrowserUtil.trace("Got a complete long message: " + nativeEventData2.stringValue + nativeEventData.stringValue);
            return string;
        }
        return null;
    }

    public void portListening() throws IOException, InterruptedException {
        if (this.selector != null && this.selector.select(1L) > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                if (selectionKey.isReadable()) {
                    this.readFromChannel(socketChannel);
                    continue;
                }
                if (!selectionKey.isWritable()) continue;
                this.writeToChannel(socketChannel);
            }
        }
    }

    private void readFromChannel(SocketChannel socketChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2048);
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while (socketChannel.read(byteBuffer) > 0) {
            byteBuffer.flip();
            this.decoder.decode(byteBuffer, charBuffer, false);
            charBuffer.flip();
            this.recvBuffer = this.recvBuffer + charBuffer;
            charBuffer.clear();
            byteBuffer.clear();
            WebBrowserUtil.trace("Read data from socket: " + this.recvBuffer);
        }
    }

    private void writeToChannel(SocketChannel socketChannel) throws IOException {
        if (this.sendBuffer.length() > 0) {
            WebBrowserUtil.trace("Send data to socket: " + this.sendBuffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.sendBuffer.getBytes(this.charsetName));
            socketChannel.write(byteBuffer);
            while (byteBuffer.hasRemaining()) {
                WebBrowserUtil.trace("==there're still contens in write buffer==");
                socketChannel.write(byteBuffer);
            }
            this.sendBuffer = "";
        }
    }

    private int findAFreePort() throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(new InetSocketAddress("localhost", 0));
        int n = serverSocketChannel.socket().getLocalPort();
        serverSocketChannel.close();
        return n;
    }
}

