/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import org.jdesktop.jdic.desktop.internal.BrowserService;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.impl.GnomeUtility;

public class GnomeBrowserService
implements BrowserService {
    private static final String MOZILLA_NAME_PATTERN = "mozilla";
    private static final String[] RESERVED_TARGET_NAMES;

    private String convertTargetName(String string) {
        boolean bl = false;
        for (int i = 0; i < RESERVED_TARGET_NAMES.length; ++i) {
            if (!string.equals(RESERVED_TARGET_NAMES[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        if (string.equals("_blank")) {
            return "new-window";
        }
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(string.length() - i - 1);
        }
        String string2 = new String(cArray);
        String string3 = string2 + "?" + string2 + "?" + string2;
        return string3;
    }

    @Override
    public void show(URL uRL) throws LaunchFailedException {
        if (!this.nativeBrowseURL(uRL.toString())) {
            throw new LaunchFailedException("Failed to launch the default browser.");
        }
    }

    @Override
    public void show(URL uRL, String string) throws LaunchFailedException {
        String string2 = MOZILLA_NAME_PATTERN;
        boolean bl = this.browseURLInMozilla(string2, uRL, string);
        if (!bl) {
            throw new LaunchFailedException("Failed to launch mozilla.");
        }
    }

    public boolean browseURLInMozilla(String string, URL uRL, String string2) {
        String string3 = "1.4";
        String string4 = uRL.toString();
        try {
            String string5 = GnomeUtility.getMozillaVersionNumber(string);
            if (string5 == null || string5.compareToIgnoreCase(string3) <= 0) {
                return false;
            }
            if (!GnomeUtility.isMozillaRunning(string)) {
                return false;
            }
            String string6 = this.convertTargetName(string2);
            Runtime.getRuntime().exec(new String[]{string, "-remote", "openurl(" + string4 + "," + string6 + ")"});
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private native boolean nativeBrowseURL(String var1);

    static {
        Toolkit.getDefaultToolkit();
        System.loadLibrary("jdic");
        RESERVED_TARGET_NAMES = new String[]{"_blank", "new-window", "new-tab"};
    }
}

