/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import org.jdesktop.jdic.tray.internal.TrayAppletService;
import org.jdesktop.jdic.tray.internal.impl.GnomeSystemTrayService;
import sun.awt.EmbeddedFrame;
import sun.awt.motif.MToolkit;

public class GnomeTrayAppletService
implements TrayAppletService {
    static HashMap winMap = new HashMap();
    EmbeddedFrame frame;
    ComponentPeer peer;
    Panel panel;
    int x;
    int y;
    int width;
    int height;
    long window_id;

    public GnomeTrayAppletService() {
        this.init();
    }

    native long createAppletWindow();

    native long getWidget(long var1, int var3, int var4, int var5, int var6);

    native void adjustSizeHints(long var1, int var3, int var4);

    EmbeddedFrame createEmbeddedFrame(long l) {
        String string = null;
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        long l2 = l;
        EmbeddedFrame embeddedFrame = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof MToolkit) {
            l2 = this.getWidget(l, 400, 400, 0, 0);
            string = "sun.awt.motif.MEmbeddedFrame";
        } else {
            string = "sun.awt.X11.XEmbeddedFrame";
        }
        try {
            clazz = Class.forName(string);
            constructor = clazz.getConstructor(Long.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                constructor = clazz.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException2.printStackTrace();
            }
        }
        if (constructor != null) {
            try {
                embeddedFrame = (EmbeddedFrame)constructor.newInstance(new Long(l2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return embeddedFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        this.window_id = this.createAppletWindow();
        HashMap hashMap = winMap;
        synchronized (hashMap) {
            winMap.put(new Long(this.window_id), this);
        }
        this.frame = this.createEmbeddedFrame(this.window_id);
        this.peer = this.frame.getPeer();
        this.width = 40;
        this.height = 46;
        this.frame.setSize(this.width, this.height);
        this.frame.setVisible(true);
    }

    long getWindow() {
        return this.window_id;
    }

    EmbeddedFrame getFrame() {
        return this.frame;
    }

    @Override
    public void add(Component component) {
        this.frame.add(component);
    }

    @Override
    public Graphics getGraphics() {
        return this.frame.getGraphics();
    }

    @Override
    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        this.adjustSizeHints(this.getWindow(), n3, n4);
        this.frame.reshape(n, n2, n3, n4);
    }

    @Override
    public ComponentPeer getPeer() {
        return this.peer;
    }

    void configureWindow(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.frame.setSize(this.width, this.height);
        this.frame.validate();
    }

    public Dimension getAppletSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void configureNotify(long l, int n, int n2, int n3, int n4) {
        GnomeTrayAppletService gnomeTrayAppletService;
        HashMap hashMap = winMap;
        synchronized (hashMap) {
            gnomeTrayAppletService = (GnomeTrayAppletService)winMap.get(new Long(l));
        }
        if (gnomeTrayAppletService != null) {
            gnomeTrayAppletService.configureWindow(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        HashMap hashMap = winMap;
        synchronized (hashMap) {
            winMap.remove(new Long(this.getWindow()));
        }
        this.frame.dispose();
        GnomeTrayAppletService.dispose(this.getWindow());
    }

    static native void dispose(long var0);

    static {
        System.loadLibrary("tray");
        GnomeSystemTrayService.initNative(System.getProperty("java.home"));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Iterator iterator = winMap.keySet().iterator();
                while (iterator.hasNext()) {
                    GnomeTrayAppletService.dispose((Long)iterator.next());
                }
            }
        });
    }
}

