/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxSpline;
import com.mxgraph.util.mxSpline1D;
import com.mxgraph.util.mxUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class mxCurve {
    protected Map<String, mxPoint[]> points;
    protected double minXBounds = 1.0E7;
    protected double maxXBounds = 0.0;
    protected double minYBounds = 1.0E7;
    protected double maxYBounds = 0.0;
    protected Map<String, double[]> intervals;
    protected Map<String, Double> curveLengths;
    public static String CORE_CURVE = "Center_curve";
    public static String LABEL_CURVE = "Label_curve";
    public static mxLine INVALID_POSITION = new mxLine(new mxPoint(0.0, 0.0), new mxPoint(1.0, 0.0));
    protected double labelBuffer = mxConstants.DEFAULT_LABEL_BUFFER;
    public List<mxPoint> guidePoints = new ArrayList<mxPoint>();
    protected boolean valid = false;

    public void setLabelBuffer(double d) {
        this.labelBuffer = d;
    }

    public mxRectangle getBounds() {
        if (!this.valid) {
            this.createCoreCurve();
        }
        return new mxRectangle(this.minXBounds, this.minYBounds, this.maxXBounds - this.minXBounds, this.maxYBounds - this.minYBounds);
    }

    public mxCurve() {
    }

    public mxCurve(List<mxPoint> list) {
        boolean bl = false;
        for (mxPoint mxPoint2 : list) {
            if (mxPoint2 != null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.guidePoints = new ArrayList<mxPoint>(list);
        }
    }

    protected int getLowerIndexOfSegment(String string, double d) {
        double[] dArray = this.getIntervals(string);
        if (dArray == null) {
            return 0;
        }
        int n = dArray.length;
        if (d <= 0.0 || n < 3) {
            return 0;
        }
        if (d >= 1.0) {
            return n - 2;
        }
        int n2 = (int)((double)n * d);
        if (n2 >= n) {
            n2 = n - 1;
        }
        int n3 = -1;
        int n4 = n;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[n2];
            double d3 = 0.5;
            if (d < d2) {
                n4 = Math.min(n4, n2);
                d3 = -0.5;
            } else if (d > d2) {
                n3 = Math.max(n3, n2);
            } else if (n2 == 0) {
                n3 = 0;
                n4 = 1;
            } else {
                n3 = n2 - 1;
                n4 = n2;
            }
            int n5 = n4 - n3;
            if (n5 == 1) break;
            if ((n2 = (int)((double)n2 + (double)n5 * d3)) == n3) {
                n2 = n3 + 1;
            }
            if (n2 != n4) continue;
            n2 = n4 - 1;
        }
        if (n3 != n4 - 1) {
            return -1;
        }
        return n3;
    }

    public mxLine getCurveParallel(String string, double d) {
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        double[] dArray = this.getIntervals(string);
        if (mxPointArray != null && mxPointArray.length > 0 && dArray != null && d >= 0.0 && d <= 1.0) {
            if (mxPointArray.length == 1) {
                mxPoint mxPoint2 = mxPointArray[0];
                return new mxLine(mxPoint2.getX(), mxPoint2.getY(), new mxPoint(1.0, 0.0));
            }
            int n = this.getLowerIndexOfSegment(string, d);
            mxPoint mxPoint3 = mxPointArray[n];
            double d2 = mxPointArray[n + 1].getX() - mxPoint3.getX();
            double d3 = mxPointArray[n + 1].getY() - mxPoint3.getY();
            double d4 = (d - dArray[n]) / (dArray[n + 1] - dArray[n]);
            double d5 = Math.sqrt(d2 * d2 + d3 * d3);
            double d6 = mxPoint3.getX() + d2 * d4;
            double d7 = mxPoint3.getY() + d3 * d4;
            mxPoint mxPoint4 = new mxPoint(d2 / d5, d3 / d5);
            return new mxLine(d6, d7, mxPoint4);
        }
        return INVALID_POSITION;
    }

    public mxPoint[] getCurveSection(String string, double d, double d2) {
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        double[] dArray = this.getIntervals(string);
        if (mxPointArray != null && mxPointArray.length > 0 && dArray != null && d >= 0.0 && d <= 1.0 && d2 >= 0.0 && d2 <= 1.0) {
            Object object;
            if (mxPointArray.length == 1) {
                mxPoint mxPoint2 = mxPointArray[0];
                return new mxPoint[]{new mxPoint(mxPoint2.getX(), mxPoint2.getY())};
            }
            int n = this.getLowerIndexOfSegment(string, d);
            mxPoint mxPoint3 = mxPointArray[n];
            double d3 = mxPointArray[n + 1].getX() - mxPoint3.getX();
            double d4 = mxPointArray[n + 1].getY() - mxPoint3.getY();
            double d5 = (d - dArray[n]) / (dArray[n + 1] - dArray[n]);
            mxPoint mxPoint4 = new mxPoint(mxPoint3.getX() + d3 * d5, mxPoint3.getY() + d4 * d5);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(mxPoint4);
            double d6 = d;
            d6 = dArray[++n];
            while (d6 <= d2) {
                object = mxPointArray[n];
                arrayList.add(object);
                d6 = dArray[++n];
            }
            if (n > 0 && n < mxPointArray.length && d2 > dArray[n - 1]) {
                mxPoint3 = mxPointArray[n - 1];
                d3 = mxPointArray[n].getX() - mxPoint3.getX();
                d4 = mxPointArray[n].getY() - mxPoint3.getY();
                d5 = (d2 - dArray[n - 1]) / (dArray[n] - dArray[n - 1]);
                object = new mxPoint(mxPoint3.getX() + d3 * d5, mxPoint3.getY() + d4 * d5);
                arrayList.add(object);
            }
            object = new mxPoint[arrayList.size()];
            return arrayList.toArray((T[])object);
        }
        return null;
    }

    public boolean intersectsRect(Rectangle rectangle) {
        if (!this.getBounds().getRectangle().intersects(rectangle)) {
            return false;
        }
        mxPoint[] mxPointArray = this.getCurvePoints(CORE_CURVE);
        if (mxPointArray != null && mxPointArray.length > 1) {
            int n;
            mxRectangle mxRectangle2 = new mxRectangle(rectangle);
            for (n = 1; n < mxPointArray.length; ++n) {
                if (!mxRectangle2.contains(mxPointArray[n].getX(), mxPointArray[n].getY()) && !mxRectangle2.contains(mxPointArray[n - 1].getX(), mxPointArray[n - 1].getY())) continue;
                return true;
            }
            for (n = 1; n < mxPointArray.length; ++n) {
                if (mxRectangle2.intersectLine(mxPointArray[n].getX(), mxPointArray[n].getY(), mxPointArray[n - 1].getX(), mxPointArray[n - 1].getY()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public mxPoint intersectsRectPerimeter(String string, mxRectangle mxRectangle2) {
        int n;
        mxPoint mxPoint2 = null;
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        if (mxPointArray != null && mxPointArray.length > 1 && (n = this.intersectRectPerimeterSeg(string, mxRectangle2)) != -1) {
            mxPoint2 = this.intersectRectPerimeterPoint(string, mxRectangle2, n);
        }
        return mxPoint2;
    }

    public double intersectsRectPerimeterDist(String string, mxRectangle mxRectangle2) {
        double d = -1.0;
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        double[] dArray = this.getIntervals(string);
        if (mxPointArray != null && mxPointArray.length > 1) {
            int n = this.intersectRectPerimeterSeg(string, mxRectangle2);
            mxPoint mxPoint2 = null;
            if (n != -1) {
                mxPoint2 = this.intersectRectPerimeterPoint(string, mxRectangle2, n);
            }
            if (mxPoint2 != null && dArray != null) {
                double d2 = mxPointArray[n - 1].getX();
                double d3 = mxPointArray[n - 1].getY();
                double d4 = dArray[n - 1] * this.getCurveLength(string);
                double d5 = mxPoint2.getX() - d2;
                double d6 = mxPoint2.getY() - d3;
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                d = d4 + d7;
            }
        }
        return d;
    }

    public mxPoint collisionMove(String string, mxRectangle mxRectangle2, double d) {
        int n = this.intersectRectPerimeterSeg(string, mxRectangle2);
        if (n == -1) {
            return null;
        }
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        if (mxPointArray == null) {
            return null;
        }
        double d2 = mxPointArray[n - 1].getX();
        double d3 = mxPointArray[n - 1].getY();
        double d4 = mxPointArray[n].getX();
        double d5 = mxPointArray[n].getY();
        double d6 = mxRectangle2.getX();
        double d7 = mxRectangle2.getY();
        double d8 = mxRectangle2.getWidth();
        double d9 = mxRectangle2.getHeight();
        boolean bl = false;
        mxPoint mxPoint2 = mxUtils.intersection(d6, d7, d6 + d8, d7, d2, d3, d4, d5);
        if (mxPoint2 != null) {
            bl = true;
        } else {
            mxPoint2 = mxUtils.intersection(d6 + d8, d7, d6 + d8, d7 + d9, d2, d3, d4, d5);
        }
        if (mxPoint2 == null) {
            mxPoint2 = mxUtils.intersection(d6 + d8, d7 + d9, d6, d7 + d9, d2, d3, d4, d5);
            if (mxPoint2 != null) {
                bl = true;
            } else {
                mxPoint2 = mxUtils.intersection(d6, d7, d6, d7 + d9, d2, d3, d4, d5);
            }
        }
        if (mxPoint2 != null) {
            // empty if block
        }
        return null;
    }

    protected int intersectRectPerimeterSeg(String string, mxRectangle mxRectangle2) {
        return this.intersectRectPerimeterSeg(string, mxRectangle2, 1);
    }

    protected int intersectRectPerimeterSeg(String string, mxRectangle mxRectangle2, int n) {
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        if (mxPointArray != null && mxPointArray.length > 1) {
            for (int i = n; i < mxPointArray.length; ++i) {
                if (mxRectangle2.intersectLine(mxPointArray[i].getX(), mxPointArray[i].getY(), mxPointArray[i - 1].getX(), mxPointArray[i - 1].getY()) == null) continue;
                return i;
            }
        }
        return -1;
    }

    protected mxPoint intersectRectPerimeterPoint(String string, mxRectangle mxRectangle2, int n) {
        mxPoint mxPoint2 = null;
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        if (mxPointArray != null && mxPointArray.length > 1 && n >= 0 && n < mxPointArray.length) {
            double d = mxPointArray[n - 1].getX();
            double d2 = mxPointArray[n - 1].getY();
            double d3 = mxPointArray[n].getX();
            double d4 = mxPointArray[n].getY();
            mxPoint2 = mxRectangle2.intersectLine(d, d2, d3, d4);
        }
        return mxPoint2;
    }

    public mxRectangle getRelativeFromAbsPoint(mxPoint mxPoint2, String string) {
        mxPoint[] mxPointArray = this.getCurvePoints(string);
        double[] dArray = this.getIntervals(string);
        if (mxPointArray == null || dArray == null) {
            throw new IllegalArgumentException("Invalid index: " + string + ",  cannot find CurvePoints and/or Intervals");
        }
        int n = 0;
        double d = 1.0E7;
        mxLine mxLine2 = new mxLine(mxPointArray[0], mxPointArray[1]);
        for (int i = 1; i < mxPointArray.length; ++i) {
            mxLine2.setPoints(mxPointArray[i - 1], mxPointArray[i]);
            double d2 = mxLine2.ptSegDistSq(mxPoint2);
            if (!(d2 < d)) continue;
            d = d2;
            n = i - 1;
        }
        mxPoint mxPoint3 = mxPointArray[n];
        mxPoint mxPoint4 = mxPointArray[n + 1];
        mxLine mxLine3 = new mxLine(mxPoint3, mxPoint4);
        double d3 = mxLine3.ptLineDistSq(mxPoint2);
        double d4 = Math.sqrt(Math.min(d3, d));
        double d5 = mxPoint4.getX() - mxPoint3.getX();
        double d6 = mxPoint4.getY() - mxPoint3.getY();
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = d5 / d7;
        double d9 = d6 / d7;
        double d10 = mxPoint2.getX() - d9 * d4 - mxPoint4.getX();
        double d11 = mxPoint2.getY() + d8 * d4 - mxPoint4.getY();
        double d12 = mxPoint2.getX() + d9 * d4 - mxPoint4.getX();
        double d13 = mxPoint2.getY() - d8 * d4 - mxPoint4.getY();
        double d14 = d10 * d10 + d11 * d11;
        double d15 = d12 * d12 + d13 * d13;
        double d16 = 0.0;
        double d17 = 0.0;
        if (d15 < d14) {
            d4 = -d4;
        }
        d16 = mxPoint2.getX() - d9 * d4;
        d17 = mxPoint2.getY() + d8 * d4;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        if (Math.abs(d - d3) > 1.0E-4) {
            double d21;
            double d22 = Math.abs(d16 - mxPoint3.getX()) + Math.abs(d17 - mxPoint3.getY());
            if (d22 < (d21 = Math.abs(d16 - mxPoint4.getX()) + Math.abs(d17 - mxPoint4.getY()))) {
                d18 = dArray[n];
                d19 = d16 - mxPoint3.getX();
                d20 = d17 - mxPoint3.getY();
            } else {
                d18 = dArray[n + 1];
                d19 = d16 - mxPoint4.getX();
                d20 = d17 - mxPoint4.getY();
            }
        } else {
            double d23 = Math.sqrt((mxPoint4.getX() - mxPoint3.getX()) * (mxPoint4.getX() - mxPoint3.getX()) + (mxPoint4.getY() - mxPoint3.getY()) * (mxPoint4.getY() - mxPoint3.getY()));
            double d24 = Math.sqrt((d16 - mxPoint3.getX()) * (d16 - mxPoint3.getX()) + (d17 - mxPoint3.getY()) * (d17 - mxPoint3.getY()));
            double d25 = d24 / d23;
            double d26 = dArray[n + 1] - dArray[n];
            d18 = dArray[n] + d26 * d25;
        }
        if (d18 > 1.0) {
            d18 = 1.0;
        }
        return new mxRectangle(d18, d4, d19, d20);
    }

    protected void createCoreCurve() {
        Object object;
        this.valid = false;
        if (this.guidePoints == null || this.guidePoints.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.guidePoints.size(); ++i) {
            if (this.guidePoints.get(i) != null) continue;
            return;
        }
        this.minYBounds = 1.0E7;
        this.minXBounds = 1.0E7;
        this.maxYBounds = 0.0;
        this.maxXBounds = 0.0;
        mxSpline mxSpline2 = new mxSpline(this.guidePoints);
        double d = mxSpline2.getLength();
        if (Double.isNaN(d) || !mxSpline2.checkValues() || d < 1.0) {
            return;
        }
        mxSpline1D mxSpline1D2 = mxSpline2.getSplineX();
        mxSpline1D mxSpline1D3 = mxSpline2.getSplineY();
        double d2 = 12.0 / d;
        double d3 = 1.0 / d;
        double d4 = d2;
        double d5 = 0.15;
        double d6 = 0.3;
        double d7 = (d6 + d5) / 2.0;
        double d8 = -1.0;
        double d9 = -1.0;
        double d10 = -1.0;
        double d11 = -1.0;
        double d12 = 1.0;
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        boolean bl = false;
        for (double d13 = 0.0; d13 <= 1.5; d13 += d4) {
            if (d13 > 1.0) {
                d13 = 1.0001;
                object = this.guidePoints.get(this.guidePoints.size() - 1);
                mxPoint object2 = new mxPoint(((mxPoint)object).getX(), ((mxPoint)object).getY());
                arrayList.add(object2);
                arrayList2.add(d13);
                this.updateBounds(((mxPoint)object).getX(), ((mxPoint)object).getY());
                break;
            }
            boolean bl2 = true;
            double d14 = mxSpline1D2.getFastValue(d13);
            double d15 = mxSpline1D3.getFastValue(d13);
            if (d8 != -1.0 && bl && d13 != 1.0001) {
                double d16;
                double d17 = Math.abs((d9 - d8) * d12 + d9 - d14);
                double d18 = Math.abs((d11 - d10) * d12 + d11 - d15);
                if ((d17 > d6 || d18 > d6) && d4 != d3) {
                    d16 = d6 / Math.max(d17, d18);
                    d12 = d4 * d16 <= d3 ? d3 / d4 : d16;
                    d13 -= d4;
                    d4 *= d12;
                    bl2 = false;
                } else if (d17 < d5 && d18 < d5) {
                    d12 = 1.4;
                    d4 *= d12;
                } else {
                    d16 = d7 / Math.max(d17, d18);
                    d12 = d16 / 4.0;
                    d4 *= d12;
                }
                if (bl2) {
                    d8 = d9;
                    d10 = d11;
                    d9 = d14;
                    d11 = d15;
                }
            } else if (d8 == -1.0) {
                d8 = d9 = d14;
                d10 = d11 = d15;
            } else if (d8 == d9 && d10 == d11) {
                d9 = d14;
                d11 = d15;
                bl = true;
            }
            if (!bl2) continue;
            mxPoint mxPoint2 = new mxPoint(d14, d15);
            arrayList.add(mxPoint2);
            arrayList2.add(d13);
            this.updateBounds(d14, d15);
        }
        if (arrayList.size() < 2) {
            return;
        }
        mxPoint[] mxPointArray = new mxPoint[arrayList.size()];
        int n = 0;
        for (mxPoint mxPoint3 : arrayList) {
            mxPointArray[n++] = mxPoint3;
        }
        this.points = new Hashtable<String, mxPoint[]>();
        this.curveLengths = new Hashtable<String, Double>();
        this.points.put(CORE_CURVE, mxPointArray);
        this.curveLengths.put(CORE_CURVE, d);
        object = new double[arrayList2.size()];
        n = 0;
        for (Double d19 : arrayList2) {
            object[n++] = d19;
        }
        this.intervals = new Hashtable<String, double[]>();
        this.intervals.put(CORE_CURVE, (double[])object);
        this.valid = true;
    }

    public boolean isLabelReversed() {
        double d;
        mxPoint[] mxPointArray;
        return this.valid && (mxPointArray = this.getCurvePoints(CORE_CURVE)) != null && (d = mxPointArray[mxPointArray.length - 1].getX() - mxPointArray[0].getX()) < 0.0;
    }

    protected void createLabelCurve() {
        mxPoint[] mxPointArray = this.getBaseLabelCurve();
        if (mxPointArray == null) {
            return;
        }
        boolean bl = this.isLabelReversed();
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        for (int i = 1; i < mxPointArray.length; ++i) {
            int n = i;
            int n2 = i - 1;
            if (bl) {
                n = mxPointArray.length - i - 1;
                n2 = mxPointArray.length - i;
            }
            mxPoint mxPoint2 = mxPointArray[n];
            mxPoint mxPoint3 = mxPointArray[n2];
            double d = mxPoint3.getX() - mxPoint2.getX();
            double d2 = mxPoint3.getY() - mxPoint2.getY();
            double d3 = Math.sqrt(d * d + d2 * d2);
            double d4 = d / d3;
            double d5 = d2 / d3;
            double d6 = (mxPoint3.getX() + mxPoint2.getX()) / 2.0;
            double d7 = (mxPoint3.getY() + mxPoint2.getY()) / 2.0;
            if (i == 1) {
                mxPoint mxPoint4 = new mxPoint(mxPoint3.getX() - d5 * this.labelBuffer, mxPoint3.getY() + d4 * this.labelBuffer);
                arrayList.add(mxPoint4);
                this.updateBounds(mxPoint4.getX(), mxPoint4.getY());
            }
            double d8 = d6 - d5 * this.labelBuffer;
            double d9 = d7 + d4 * this.labelBuffer;
            mxPoint mxPoint5 = new mxPoint(d8, d9);
            this.updateBounds(d8, d9);
            arrayList.add(mxPoint5);
            if (i != mxPointArray.length - 1) continue;
            mxPoint mxPoint6 = new mxPoint(mxPoint2.getX() - d5 * this.labelBuffer, mxPoint2.getY() + d4 * this.labelBuffer);
            arrayList.add(mxPoint6);
            this.updateBounds(mxPoint6.getX(), mxPoint6.getY());
        }
        mxPoint[] mxPointArray2 = new mxPoint[arrayList.size()];
        this.points.put(LABEL_CURVE, arrayList.toArray(mxPointArray2));
        this.populateIntervals(LABEL_CURVE);
    }

    protected mxPoint[] getBaseLabelCurve() {
        return this.getCurvePoints(CORE_CURVE);
    }

    protected void populateIntervals(String string) {
        int n;
        mxPoint[] mxPointArray = this.points.get(string);
        if (mxPointArray == null) {
            return;
        }
        double[] dArray = new double[mxPointArray.length];
        double d = 0.0;
        dArray[0] = 0.0;
        for (n = 0; n < mxPointArray.length - 1; ++n) {
            double d2 = mxPointArray[n + 1].getX() - mxPointArray[n].getX();
            double d3 = mxPointArray[n + 1].getY() - mxPointArray[n].getY();
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray[n + 1] = d += d4;
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = n == dArray.length - 1 ? 1.0001 : dArray[n] / d;
        }
        this.intervals.put(string, dArray);
        this.curveLengths.put(string, d);
    }

    public void updateCurve(List<mxPoint> list) {
        boolean bl = false;
        for (mxPoint mxPoint2 : list) {
            if (mxPoint2 != null) continue;
            return;
        }
        if (list.size() != this.guidePoints.size()) {
            bl = true;
        } else if (list.size() == this.guidePoints.size() && list.size() > 1 && this.guidePoints.size() > 1) {
            boolean bl2 = true;
            boolean bl3 = true;
            mxPoint mxPoint3 = list.get(0);
            mxPoint mxPoint4 = this.guidePoints.get(0);
            double d = mxPoint3.getX() - mxPoint4.getX();
            double d2 = mxPoint3.getY() - mxPoint4.getY();
            if (Math.abs(d) > 0.01 || Math.abs(d2) > 0.01) {
                bl3 = false;
            }
            for (int i = 1; i < list.size(); ++i) {
                double d3 = list.get(i).getX() - this.guidePoints.get(i).getX();
                double d4 = list.get(i).getY() - this.guidePoints.get(i).getY();
                if (Math.abs(d - d3) > 0.01 || Math.abs(d2 - d4) > 0.01) {
                    bl2 = false;
                }
                if (!(Math.abs(d3) > 0.01) && !(Math.abs(d4) > 0.01)) continue;
                bl3 = false;
            }
            if (bl3) {
                bl = false;
            } else if (bl2) {
                bl = false;
                Collection<mxPoint[]> collection = this.points.values();
                for (mxPoint[] mxPointArray : collection) {
                    for (int i = 0; i < mxPointArray.length; ++i) {
                        mxPointArray[i].setX(mxPointArray[i].getX() + d);
                        mxPointArray[i].setY(mxPointArray[i].getY() + d2);
                    }
                }
                this.guidePoints = new ArrayList<mxPoint>(list);
                this.minXBounds += d;
                this.minYBounds += d2;
                this.maxXBounds += d;
                this.maxYBounds += d2;
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.guidePoints = new ArrayList<mxPoint>(list);
            this.points = new Hashtable<String, mxPoint[]>();
            this.valid = false;
        }
    }

    public mxPoint[] getCurvePoints(String string) {
        if (this.validateCurve()) {
            if (this.points.get(LABEL_CURVE) == null && string == LABEL_CURVE) {
                this.createLabelCurve();
            }
            return this.points.get(string);
        }
        return null;
    }

    public double[] getIntervals(String string) {
        if (this.validateCurve()) {
            if (this.points.get(LABEL_CURVE) == null && string == LABEL_CURVE) {
                this.createLabelCurve();
            }
            return this.intervals.get(string);
        }
        return null;
    }

    public double getCurveLength(String string) {
        if (this.validateCurve()) {
            if (this.intervals.get(string) == null) {
                this.createLabelCurve();
            }
            return this.curveLengths.get(string);
        }
        return 0.0;
    }

    protected boolean validateCurve() {
        if (!this.valid) {
            this.createCoreCurve();
        }
        return this.valid;
    }

    protected void updateBounds(double d, double d2) {
        this.minXBounds = Math.min(this.minXBounds, d);
        this.maxXBounds = Math.max(this.maxXBounds, d);
        this.minYBounds = Math.min(this.minYBounds, d2);
        this.maxYBounds = Math.max(this.maxYBounds, d2);
    }

    public List<mxPoint> getGuidePoints() {
        return this.guidePoints;
    }
}

