/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.Chart3DChangeEvent;
import com.orsoncharts.Chart3DChangeListener;
import com.orsoncharts.ChartBox3D;
import com.orsoncharts.RectanglePainter;
import com.orsoncharts.StandardRectanglePainter;
import com.orsoncharts.TitleAnchor;
import com.orsoncharts.TitleUtils;
import com.orsoncharts.axis.Axis3D;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Drawable3D;
import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.graphics3d.ZOrderComparator;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.legend.LegendBuilder;
import com.orsoncharts.legend.StandardLegendBuilder;
import com.orsoncharts.plot.AbstractPlot3D;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.PiePlot3D;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.plot.Plot3DChangeEvent;
import com.orsoncharts.plot.Plot3DChangeListener;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.RefPt2D;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;

public class Chart3D
implements Drawable3D,
Plot3DChangeListener,
Serializable {
    private RectanglePainter background;
    private TableElement title;
    private Anchor2D titleAnchor;
    private LegendBuilder legendBuilder;
    private Anchor2D legendAnchor;
    private Plot3D plot;
    private ViewPoint3D viewPoint;
    private Color chartBoxColor;
    private Offset2D translate2D;
    private transient EventListenerList listenerList;
    private boolean notify;

    public Chart3D(String title, String subtitle, Plot3D plot) {
        ArgChecks.nullNotPermitted(plot, "plot");
        this.background = new StandardRectanglePainter(Color.WHITE);
        if (title != null) {
            this.title = TitleUtils.createTitle(title, subtitle);
        }
        this.titleAnchor = TitleAnchor.TOP_LEFT;
        this.legendBuilder = new StandardLegendBuilder();
        this.legendAnchor = LegendAnchor.BOTTOM_RIGHT;
        this.plot = plot;
        this.plot.addChangeListener(this);
        Dimension3D dim = this.plot.getDimensions();
        float distance = (float)dim.getDiagonalLength() * 3.0f;
        this.viewPoint = ViewPoint3D.createAboveViewPoint(distance);
        this.chartBoxColor = Color.WHITE;
        this.translate2D = new Offset2D();
        this.notify = true;
        this.listenerList = new EventListenerList();
    }

    public RectanglePainter getBackground() {
        return this.background;
    }

    public void setBackground(RectanglePainter background) {
        this.background = background;
        this.fireChangeEvent();
    }

    public TableElement getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            this.setTitle((TableElement)null);
        } else {
            this.setTitle(title, TitleUtils.DEFAULT_TITLE_FONT, TitleUtils.DEFAULT_TITLE_PAINT);
        }
    }

    public void setTitle(String title, Font font, Paint paint) {
        ArgChecks.nullNotPermitted(font, "font");
        ArgChecks.nullNotPermitted(paint, "paint");
        TextElement te = new TextElement(title);
        te.setFont(font);
        te.setForegroundPaint(paint);
        this.setTitle(te);
    }

    public void setTitle(TableElement title) {
        this.title = title;
        this.fireChangeEvent();
    }

    public Anchor2D getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(Anchor2D anchor) {
        ArgChecks.nullNotPermitted(anchor, "anchor");
        this.titleAnchor = anchor;
        this.fireChangeEvent();
    }

    public Plot3D getPlot() {
        return this.plot;
    }

    public Color getChartBoxColor() {
        return this.chartBoxColor;
    }

    public void setChartBoxColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.chartBoxColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Dimension3D getDimensions() {
        return this.plot.getDimensions();
    }

    @Override
    public ViewPoint3D getViewPoint() {
        return this.viewPoint;
    }

    @Override
    public void setViewPoint(ViewPoint3D viewPoint) {
        ArgChecks.nullNotPermitted(viewPoint, "viewPoint");
        this.viewPoint = viewPoint;
        this.fireChangeEvent();
    }

    @Override
    public Offset2D getTranslate2D() {
        return this.translate2D;
    }

    @Override
    public void setTranslate2D(Offset2D offset) {
        ArgChecks.nullNotPermitted(offset, "offset");
        this.translate2D = offset;
        this.fireChangeEvent();
    }

    public LegendBuilder getLegendBuilder() {
        return this.legendBuilder;
    }

    public void setLegendBuilder(LegendBuilder legendBuilder) {
        this.legendBuilder = legendBuilder;
        this.fireChangeEvent();
    }

    public Anchor2D getLegendAnchor() {
        return this.legendAnchor;
    }

    public void setLegendAnchor(Anchor2D anchor) {
        ArgChecks.nullNotPermitted(anchor, "anchor");
        this.legendAnchor = anchor;
        this.fireChangeEvent();
    }

    private World createWorld(ChartBox3D chartBox) {
        World world = new World();
        Dimension3D dim = this.plot.getDimensions();
        double w = dim.getWidth();
        double h = dim.getHeight();
        double d = dim.getDepth();
        if (chartBox != null) {
            world.add(chartBox.getObject3D());
        }
        this.plot.compose(world, -w / 2.0, -h / 2.0, -d / 2.0);
        return world;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.2f, 1, 1, 1.0f));
        Dimension3D dim3D = this.plot.getDimensions();
        double w = dim3D.getWidth();
        double h = dim3D.getHeight();
        double depth = dim3D.getDepth();
        ChartBox3D chartBox = null;
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, this.chartBoxColor);
            double[] tickUnits = this.findAxisTickUnits(g2, w, h, depth);
            List<TickData> xTicks = this.fetchXTickData(this.plot, tickUnits[0]);
            List<TickData> yTicks = this.fetchYTickData(this.plot, tickUnits[1]);
            List<TickData> zTicks = this.fetchZTickData(this.plot, tickUnits[2]);
            chartBox.configureTicks(xTicks, yTicks, zTicks);
        }
        World world = this.createWorld(chartBox);
        if (this.background != null) {
            this.background.fill(g2, bounds);
        }
        AffineTransform saved = g2.getTransform();
        g2.translate(bounds.getWidth() / 2.0 + this.translate2D.getDX(), bounds.getHeight() / 2.0 + this.translate2D.getDY());
        Point3D[] eyePts = world.calculateEyeCoordinates(this.viewPoint);
        Point2D[] pts = world.calculateProjectedPoints(this.viewPoint, 1000.0f);
        ArrayList<Face> facesInPaintOrder = new ArrayList<Face>(world.getFaces());
        Collections.sort(facesInPaintOrder, new ZOrderComparator(eyePts));
        for (Face f : facesInPaintOrder) {
            boolean drawOutline = f.getOutline();
            GeneralPath p = new GeneralPath();
            for (int v = 0; v < f.getVertexCount(); ++v) {
                if (v == 0) {
                    p.moveTo(pts[f.getVertexIndex(v)].getX(), pts[f.getVertexIndex(v)].getY());
                    continue;
                }
                p.lineTo(pts[f.getVertexIndex(v)].getX(), pts[f.getVertexIndex(v)].getY());
            }
            p.closePath();
            double[] plane = f.calculateNormal(eyePts);
            double inprod = plane[0] * world.getSunX() + plane[1] * world.getSunY() + plane[2] * world.getSunZ();
            double shade = (inprod + 1.0) / 2.0;
            if (!(Utils2D.area2(pts[f.getVertexIndex(0)], pts[f.getVertexIndex(1)], pts[f.getVertexIndex(2)]) > 0.0)) continue;
            Color c = f.getColor();
            if (c != null) {
                g2.setPaint(new Color((int)((double)c.getRed() * shade), (int)((double)c.getGreen() * shade), (int)((double)c.getBlue() * shade), c.getAlpha()));
                g2.fill(p);
                if (drawOutline) {
                    g2.draw(p);
                }
            }
            if (!(f instanceof ChartBox3D.CBFace) || !(this.plot instanceof CategoryPlot3D) && !(this.plot instanceof XYZPlot)) continue;
            Stroke savedStroke = g2.getStroke();
            ChartBox3D.CBFace cbf = (ChartBox3D.CBFace)f;
            this.drawGridlines(g2, cbf, pts);
            g2.setStroke(savedStroke);
        }
        if (this.plot instanceof PiePlot3D) {
            this.drawPieLabels(g2, w, h, depth);
        }
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            this.drawAxes(g2, chartBox, pts);
        }
        g2.setTransform(saved);
        if (this.legendBuilder != null) {
            TableElement legend = this.legendBuilder.createLegend(this.plot);
            GridElement legend2 = new GridElement();
            legend2.setElement(legend, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
            TextElement te = new TextElement("Orson Charts (evaluation) (c) 2013, by Object Refinery Limited", new Font("Dialog", 0, 10));
            te.setHorizontalAligment(HAlign.RIGHT);
            legend2.setElement(te, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
            legend = legend2;
            Dimension2D legendSize = legend.preferredSize(g2, bounds);
            Rectangle2D legendArea = this.calculateDrawArea(legendSize, this.legendAnchor, bounds);
            legend.draw(g2, legendArea);
        }
        if (this.title != null) {
            Dimension2D titleSize = this.title.preferredSize(g2, bounds);
            Rectangle2D titleArea = this.calculateDrawArea(titleSize, this.titleAnchor, bounds);
            this.title.draw(g2, titleArea);
        }
    }

    private List<TickData> fetchXTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getColumnAxis().generateTickData();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getXAxis().generateTickData(tickUnit);
        }
        return new ArrayList<TickData>();
    }

    private List<TickData> fetchYTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getValueAxis().generateTickData(tickUnit);
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getYAxis().generateTickData(tickUnit);
        }
        return new ArrayList<TickData>();
    }

    private List<TickData> fetchZTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getRowAxis().generateTickData();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getZAxis().generateTickData(tickUnit);
        }
        return new ArrayList<TickData>();
    }

    private void drawGridlines(Graphics2D g2, ChartBox3D.CBFace face, Point2D[] pts) {
        Line2D.Double line;
        int i;
        if (this.isGridlinesVisibleForX(this.plot)) {
            List<TickData> xA = face.getXTicksA();
            List<TickData> xB = face.getXTicksB();
            for (i = 0; i < xA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + xA.get(i).getVertexIndex()], pts[face.getOffset() + xB.get(i).getVertexIndex()]);
                g2.setPaint(this.fetchGridlinePaintX(this.plot));
                g2.setStroke(this.fetchGridlineStrokeX(this.plot));
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForY(this.plot)) {
            List<TickData> yA = face.getYTicksA();
            List<TickData> yB = face.getYTicksB();
            for (i = 0; i < yA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + yA.get(i).getVertexIndex()], pts[face.getOffset() + yB.get(i).getVertexIndex()]);
                g2.setPaint(this.fetchGridlinePaintY(this.plot));
                g2.setStroke(this.fetchGridlineStrokeY(this.plot));
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForZ(this.plot)) {
            List<TickData> zA = face.getZTicksA();
            List<TickData> zB = face.getZTicksB();
            for (i = 0; i < zA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + zA.get(i).getVertexIndex()], pts[face.getOffset() + zB.get(i).getVertexIndex()]);
                g2.setPaint(this.fetchGridlinePaintZ(this.plot));
                g2.setStroke(this.fetchGridlineStrokeZ(this.plot));
                g2.draw(line);
            }
        }
    }

    private boolean isGridlinesVisibleForX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleX();
        }
        return false;
    }

    private boolean isGridlinesVisibleForY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleY();
        }
        return false;
    }

    private boolean isGridlinesVisibleForZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleZ();
        }
        return false;
    }

    private Paint fetchGridlinePaintX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintX();
        }
        return null;
    }

    private Paint fetchGridlinePaintY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintY();
        }
        return null;
    }

    private Paint fetchGridlinePaintZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintZ();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeX();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeY();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeZ();
        }
        return null;
    }

    private void drawPieLabels(Graphics2D g2, double w, double h, double depth) {
        PiePlot3D p = (PiePlot3D)this.plot;
        World labelOverlay = new World();
        List<Object3D> objs = p.getLabelFaces(-w / 2.0, -h / 2.0, -depth / 2.0);
        for (Object3D obj : objs) {
            labelOverlay.add(obj);
        }
        Point2D[] ppts = labelOverlay.calculateProjectedPoints(this.viewPoint, 1000.0f);
        for (int i = 0; i < p.getDataset().getItemCount() * 2; ++i) {
            Face f = labelOverlay.getFaces().get(i);
            if (!(Utils2D.area2(ppts[f.getVertexIndex(0)], ppts[f.getVertexIndex(1)], ppts[f.getVertexIndex(2)]) > 0.0)) continue;
            Comparable key = p.getDataset().getKey(i / 2);
            g2.setColor(p.getSectionLabelColorSource().getColor(key));
            g2.setFont(p.getSectionLabelFontSource().getFont(key));
            Point2D pt = Utils2D.centerPoint(ppts[f.getVertexIndex(0)], ppts[f.getVertexIndex(1)], ppts[f.getVertexIndex(2)], ppts[f.getVertexIndex(3)]);
            TextUtils.drawAlignedString(key.toString(), g2, (float)pt.getX(), (float)pt.getY(), TextAnchor.CENTER);
        }
    }

    private double[] findAxisTickUnits(Graphics2D g2, double w, double h, double depth) {
        AbstractPlot3D pp;
        World axisOverlay = new World();
        ChartBox3D chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, Color.WHITE);
        axisOverlay.add(chartBox.getObject3D());
        Point2D[] axisPts2D = axisOverlay.calculateProjectedPoints(this.viewPoint, 1000.0f);
        Point2D v0 = axisPts2D[0];
        Point2D v1 = axisPts2D[1];
        Point2D v2 = axisPts2D[2];
        Point2D v3 = axisPts2D[3];
        Point2D v4 = axisPts2D[4];
        Point2D v5 = axisPts2D[5];
        Point2D v6 = axisPts2D[6];
        Point2D v7 = axisPts2D[7];
        boolean a = chartBox.faceA().isFrontFacing(axisPts2D);
        boolean b = chartBox.faceB().isFrontFacing(axisPts2D);
        boolean c = chartBox.faceC().isFrontFacing(axisPts2D);
        boolean d = chartBox.faceD().isFrontFacing(axisPts2D);
        boolean e = chartBox.faceE().isFrontFacing(axisPts2D);
        boolean f = chartBox.faceF().isFrontFacing(axisPts2D);
        double xtick = 0.0;
        double ytick = 0.0;
        double ztick = 0.0;
        Axis3D xAxis = null;
        ValueAxis3D yAxis = null;
        Axis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = ((XYZPlot)pp).getXAxis();
            yAxis = ((XYZPlot)pp).getYAxis();
            zAxis = ((XYZPlot)pp).getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = ((CategoryPlot3D)pp).getColumnAxis();
            yAxis = ((CategoryPlot3D)pp).getValueAxis();
            zAxis = ((CategoryPlot3D)pp).getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            double ce;
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double d2 = ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            if (this.count(a, b) == 1 && this.longest(ab, bc, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v0, v1, v7);
            }
            if (this.count(b, c) == 1 && this.longest(bc, ab, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v3, v2, v6);
            }
            if (this.count(c, d) == 1 && this.longest(cd, ab, bc, da) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v4, v7, v1);
            }
            if (this.count(d, a) == 1 && this.longest(da, ab, bc, cd) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v5, v6, v3);
            }
            if (this.count(b, e) == 1 && this.longest(be, bf, df, de)) {
                ytick = yAxis.selectTick(g2, v0, v3, v7);
            }
            if (this.count(b, f) == 1 && this.longest(bf, be, df, de)) {
                ytick = yAxis.selectTick(g2, v1, v2, v4);
            }
            if (this.count(d, f) == 1 && this.longest(df, be, bf, de)) {
                ytick = yAxis.selectTick(g2, v6, v7, v0);
            }
            if (this.count(d, e) == 1 && this.longest(de, be, bf, df)) {
                ytick = yAxis.selectTick(g2, v5, v4, v1);
            }
            if (this.count(a, e) == 1 && this.longest(ae, af, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v0, v5, v2);
            }
            if (this.count(a, f) == 1 && this.longest(af, ae, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v1, v6, v3);
            }
            if (this.count(c, f) == 1 && this.longest(cf, ae, af, ce) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v2, v7, v5);
            }
            if (this.count(c, e) == 1 && this.longest(ce, ae, af, cf) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v3, v4, v6);
            }
        }
        return new double[]{xtick, ytick, ztick};
    }

    private void populateAnchorPoints(List<TickData> tickData, Point2D[] pts) {
        for (TickData t : tickData) {
            t.setAnchorPt(pts[t.getVertexIndex()]);
        }
    }

    private void drawAxes(Graphics2D g2, ChartBox3D chartBox, Point2D[] pts) {
        AbstractPlot3D pp;
        Point2D v0 = pts[0];
        Point2D v1 = pts[1];
        Point2D v2 = pts[2];
        Point2D v3 = pts[3];
        Point2D v4 = pts[4];
        Point2D v5 = pts[5];
        Point2D v6 = pts[6];
        Point2D v7 = pts[7];
        boolean a = chartBox.faceA().isFrontFacing(pts);
        boolean b = chartBox.faceB().isFrontFacing(pts);
        boolean c = chartBox.faceC().isFrontFacing(pts);
        boolean d = chartBox.faceD().isFrontFacing(pts);
        boolean e = chartBox.faceE().isFrontFacing(pts);
        boolean f = chartBox.faceF().isFrontFacing(pts);
        Axis3D xAxis = null;
        ValueAxis3D yAxis = null;
        Axis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = ((XYZPlot)pp).getXAxis();
            yAxis = ((XYZPlot)pp).getYAxis();
            zAxis = ((XYZPlot)pp).getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = ((CategoryPlot3D)pp).getColumnAxis();
            yAxis = ((CategoryPlot3D)pp).getValueAxis();
            zAxis = ((CategoryPlot3D)pp).getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            List<TickData> ticks;
            double ce;
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double d2 = ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            if (this.count(a, b) == 1 && this.longest(ab, bc, cd, da)) {
                ticks = chartBox.faceA().getXTicksA();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v0, v1, v7, true, ticks);
            }
            if (this.count(b, c) == 1 && this.longest(bc, ab, cd, da)) {
                ticks = chartBox.faceB().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v3, v2, v6, true, ticks);
            }
            if (this.count(c, d) == 1 && this.longest(cd, ab, bc, da)) {
                ticks = chartBox.faceC().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v4, v7, v1, true, ticks);
            }
            if (this.count(d, a) == 1 && this.longest(da, ab, bc, cd)) {
                ticks = chartBox.faceA().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v5, v6, v3, true, ticks);
            }
            if (this.count(b, e) == 1 && this.longest(be, bf, df, de)) {
                ticks = chartBox.faceB().getYTicksA();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v0, v3, v7, true, ticks);
            }
            if (this.count(b, f) == 1 && this.longest(bf, be, df, de)) {
                ticks = chartBox.faceB().getYTicksB();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v1, v2, v4, true, ticks);
            }
            if (this.count(d, f) == 1 && this.longest(df, be, bf, de)) {
                ticks = chartBox.faceD().getYTicksA();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v6, v7, v0, true, ticks);
            }
            if (this.count(d, e) == 1 && this.longest(de, be, bf, df)) {
                ticks = chartBox.faceD().getYTicksB();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v5, v4, v1, true, ticks);
            }
            if (this.count(a, e) == 1 && this.longest(ae, af, cf, ce)) {
                ticks = chartBox.faceA().getZTicksA();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v0, v5, v2, true, ticks);
            }
            if (this.count(a, f) == 1 && this.longest(af, ae, cf, ce)) {
                ticks = chartBox.faceA().getZTicksB();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v1, v6, v3, true, ticks);
            }
            if (this.count(c, f) == 1 && this.longest(cf, ae, af, ce)) {
                ticks = chartBox.faceC().getZTicksB();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v2, v7, v5, true, ticks);
            }
            if (this.count(c, e) == 1 && this.longest(ce, ae, af, cf)) {
                ticks = chartBox.faceC().getZTicksA();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v3, v4, v6, true, ticks);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chart3D)) {
            return false;
        }
        Chart3D that = (Chart3D)obj;
        if (!ObjectUtils.equals(this.background, that.background)) {
            return false;
        }
        if (!ObjectUtils.equals(this.title, that.title)) {
            return false;
        }
        if (!this.titleAnchor.equals(that.titleAnchor)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.chartBoxColor, that.chartBoxColor)) {
            return false;
        }
        return ObjectUtils.equals(this.legendBuilder, that.legendBuilder);
    }

    private Rectangle2D calculateDrawArea(Dimension2D dim, Anchor2D anchor, Rectangle2D bounds) {
        double y;
        double x;
        ArgChecks.nullNotPermitted(dim, "dim");
        ArgChecks.nullNotPermitted(anchor, "anchor");
        ArgChecks.nullNotPermitted(bounds, "bounds");
        double w = Math.min(dim.getWidth(), bounds.getWidth());
        double h = Math.min(dim.getHeight(), bounds.getHeight());
        if (anchor.getRefPt().equals((Object)RefPt2D.CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else {
            x = 0.0;
            y = 0.0;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    private boolean longest(double x, double a, double b, double c) {
        return x >= a && x >= b && x >= c;
    }

    private int count(boolean a, boolean b) {
        int result = 0;
        if (a) {
            ++result;
        }
        if (b) {
            ++result;
        }
        return result;
    }

    @Override
    public void plotChanged(Plot3DChangeEvent event) {
        this.notifyListeners(new Chart3DChangeEvent(event, this));
    }

    public void addChangeListener(Chart3DChangeListener listener) {
        this.listenerList.add(Chart3DChangeListener.class, listener);
    }

    public void removeChangeListener(Chart3DChangeListener listener) {
        this.listenerList.remove(Chart3DChangeListener.class, listener);
    }

    public void notifyListeners(Chart3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Chart3DChangeListener.class) continue;
            ((Chart3DChangeListener)listeners[i + 1]).chartChanged(event);
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Chart3DChangeEvent(this, this));
    }
}

