/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.axis.TickData;
import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Point3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ChartBox3D {
    private double xLength;
    private double yLength;
    private double zLength;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private List<TickData> xTicks;
    private List<TickData> yTicks;
    private List<TickData> zTicks;
    private Color color;
    private CBFace faceA;
    private CBFace faceB;
    private CBFace faceC;
    private CBFace faceD;
    private CBFace faceE;
    private CBFace faceF;

    public ChartBox3D(double xLength, double yLength, double zLength, double xOffset, double yOffset, double zOffset, Color color) {
        this.xLength = xLength;
        this.yLength = yLength;
        this.zLength = zLength;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.color = color;
        this.xTicks = new ArrayList<TickData>();
        this.yTicks = new ArrayList<TickData>();
        this.zTicks = new ArrayList<TickData>();
    }

    public void configureTicks(List<TickData> xTicks, List<TickData> yTicks, List<TickData> zTicks) {
        this.xTicks = xTicks;
        this.yTicks = yTicks;
        this.zTicks = zTicks;
    }

    public Object3D getObject3D() {
        return this.createObject3D();
    }

    public CBFace faceA() {
        return this.faceA;
    }

    public CBFace faceB() {
        return this.faceB;
    }

    public CBFace faceC() {
        return this.faceC;
    }

    public CBFace faceD() {
        return this.faceD;
    }

    public CBFace faceE() {
        return this.faceE;
    }

    public CBFace faceF() {
        return this.faceF;
    }

    private Object3D createObject3D() {
        TickData td3;
        TickData td2;
        TickData td1;
        TickData td0;
        Object3D box = new Object3D();
        Point3D v0 = new Point3D(this.xOffset, this.yOffset, this.zOffset);
        Point3D v1 = new Point3D(this.xLength + this.xOffset, this.yOffset, this.zOffset);
        Point3D v2 = new Point3D(this.xLength + this.xOffset, this.yLength + this.yOffset, this.zOffset);
        Point3D v3 = new Point3D(this.xOffset, this.yLength + this.yOffset, this.zOffset);
        Point3D v4 = new Point3D(this.xOffset, this.yLength + this.yOffset, this.zLength + this.zOffset);
        Point3D v5 = new Point3D(this.xOffset, this.yOffset, this.zLength + this.zOffset);
        Point3D v6 = new Point3D(this.xLength + this.xOffset, this.yOffset, this.zLength + this.zOffset);
        Point3D v7 = new Point3D(this.xLength + this.xOffset, this.yLength + this.yOffset, this.zLength + this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        box.addVertex(v4);
        box.addVertex(v5);
        box.addVertex(v6);
        box.addVertex(v7);
        this.faceA = new CBFace(new int[]{0, 5, 6, 1}, this.color);
        this.faceB = new CBFace(new int[]{0, 1, 2, 3}, this.color);
        this.faceC = new CBFace(new int[]{7, 4, 3, 2}, this.color);
        this.faceD = new CBFace(new int[]{5, 4, 7, 6}, this.color);
        this.faceE = new CBFace(new int[]{0, 3, 4, 5}, this.color);
        this.faceF = new CBFace(new int[]{6, 7, 2, 1}, this.color);
        box.addFace(this.faceA);
        box.addFace(this.faceB);
        box.addFace(this.faceC);
        box.addFace(this.faceD);
        box.addFace(this.faceE);
        box.addFace(this.faceF);
        int base = 8;
        for (TickData t : this.xTicks) {
            double xx = this.xOffset + this.xLength * t.getPos();
            box.addVertex(xx, this.yOffset, this.zOffset);
            box.addVertex(xx, this.yOffset, this.zOffset + this.zLength);
            box.addVertex(xx, this.yOffset + this.yLength, this.zOffset + this.zLength);
            box.addVertex(xx, this.yOffset + this.yLength, this.zOffset);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceA.addXTicks(td0, td1);
            this.faceB.addXTicks(td0, td3);
            this.faceC.addXTicks(td3, td2);
            this.faceD.addXTicks(td2, td1);
            base += 4;
        }
        for (TickData t : this.yTicks) {
            double yy = this.yOffset + this.yLength * t.getPos();
            box.addVertex(this.xOffset, yy, this.zOffset);
            box.addVertex(this.xOffset + this.xLength, yy, this.zOffset);
            box.addVertex(this.xOffset + this.xLength, yy, this.zOffset + this.zLength);
            box.addVertex(this.xOffset, yy, this.zOffset + this.zLength);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceB.addYTicks(td0, td1);
            this.faceD.addYTicks(td2, td3);
            this.faceE.addYTicks(td0, td3);
            this.faceF.addYTicks(td1, td2);
            base += 4;
        }
        for (TickData t : this.zTicks) {
            double zz = this.zOffset + this.zLength * t.getPos();
            box.addVertex(this.xOffset, this.yOffset, zz);
            box.addVertex(this.xOffset + this.xLength, this.yOffset, zz);
            box.addVertex(this.xOffset + this.xLength, this.yOffset + this.yLength, zz);
            box.addVertex(this.xOffset, this.yOffset + this.yLength, zz);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceA.addZTicks(td0, td1);
            this.faceC.addZTicks(td3, td2);
            this.faceE.addZTicks(td0, td3);
            this.faceF.addZTicks(td1, td2);
            base += 4;
        }
        return box;
    }

    public static final class CBFace
    extends Face {
        private List<TickData> xTicksA = new ArrayList<TickData>();
        private List<TickData> xTicksB = new ArrayList<TickData>();
        private List<TickData> yTicksA = new ArrayList<TickData>();
        private List<TickData> yTicksB = new ArrayList<TickData>();
        private List<TickData> zTicksA = new ArrayList<TickData>();
        private List<TickData> zTicksB = new ArrayList<TickData>();

        public CBFace(int[] vertices, Color color) {
            super(vertices, color, false);
        }

        public void clearXTicks() {
            this.xTicksA.clear();
            this.xTicksB.clear();
        }

        public List<TickData> getXTicksA() {
            return this.xTicksA;
        }

        public void addXTicks(TickData a, TickData b) {
            this.xTicksA.add(a);
            this.xTicksB.add(b);
        }

        public List<TickData> getXTicksB() {
            return this.xTicksB;
        }

        public void addYTicks(TickData a, TickData b) {
            this.yTicksA.add(a);
            this.yTicksB.add(b);
        }

        public List<TickData> getYTicksA() {
            return this.yTicksA;
        }

        public List<TickData> getYTicksB() {
            return this.yTicksB;
        }

        public List<TickData> getZTicksA() {
            return this.zTicksA;
        }

        public List<TickData> getZTicksB() {
            return this.zTicksB;
        }

        public void addZTicks(TickData a, TickData b) {
            this.zTicksA.add(a);
            this.zTicksB.add(b);
        }

        @Override
        public float calculateAverageZValue(Point3D[] points) {
            return -123456.0f;
        }
    }
}

