/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues2D;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DefaultKeyedValues2D<T>
implements KeyedValues2D,
Serializable {
    List<Comparable> xKeys;
    List<Comparable> yKeys;
    List<DefaultKeyedValues<T>> data;

    public DefaultKeyedValues2D() {
        this(new ArrayList<Comparable>(), new ArrayList<Comparable>());
    }

    public DefaultKeyedValues2D(List<Comparable> xKeys, List<Comparable> yKeys) {
        ArgChecks.nullNotPermitted(xKeys, "xKeys");
        ArgChecks.nullNotPermitted(yKeys, "yKeys");
        this.xKeys = new ArrayList<Comparable>(xKeys);
        this.yKeys = new ArrayList<Comparable>(yKeys);
        this.data = new ArrayList<DefaultKeyedValues<T>>();
        for (Comparable c : xKeys) {
            this.data.add(new DefaultKeyedValues(yKeys));
        }
    }

    @Override
    public Comparable getXKey(int xIndex) {
        return this.xKeys.get(xIndex);
    }

    @Override
    public Comparable getYKey(int yIndex) {
        return this.yKeys.get(yIndex);
    }

    @Override
    public int getXIndex(Comparable xkey) {
        ArgChecks.nullNotPermitted(xkey, "xkey");
        return this.xKeys.indexOf(xkey);
    }

    @Override
    public int getYIndex(Comparable ykey) {
        ArgChecks.nullNotPermitted(ykey, "ykey");
        return this.yKeys.indexOf(ykey);
    }

    @Override
    public List<Comparable> getXKeys() {
        return new ArrayList<Comparable>(this.xKeys);
    }

    @Override
    public List<Comparable> getYKeys() {
        return new ArrayList<Comparable>(this.yKeys);
    }

    @Override
    public int getXCount() {
        return this.xKeys.size();
    }

    @Override
    public int getYCount() {
        return this.yKeys.size();
    }

    @Override
    public T getValue(Comparable xKey, Comparable yKey) {
        int xIndex = this.getXIndex(xKey);
        int yIndex = this.getYIndex(yKey);
        return this.getValue(xIndex, yIndex);
    }

    @Override
    public T getValue(int xIndex, int yIndex) {
        return this.data.get(xIndex).getValue(yIndex);
    }

    @Override
    public double getDoubleValue(int xIndex, int yIndex) {
        T n = this.getValue(xIndex, yIndex);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public void setValue(T n, Comparable xKey, Comparable yKey) {
        ArgChecks.nullNotPermitted(xKey, "xKey");
        ArgChecks.nullNotPermitted(yKey, "yKey");
        if (this.data.isEmpty()) {
            this.xKeys.add(xKey);
            this.yKeys.add(yKey);
            DefaultKeyedValues<T> dkvs = new DefaultKeyedValues<T>();
            dkvs.put(yKey, n);
            this.data.add(dkvs);
        } else {
            int xIndex = this.getXIndex(xKey);
            int yIndex = this.getYIndex(yKey);
            if (xIndex >= 0) {
                DefaultKeyedValues<T> dkvs = this.data.get(xIndex);
                if (yIndex >= 0) {
                    dkvs.put(yKey, n);
                } else {
                    this.yKeys.add(yKey);
                    for (DefaultKeyedValues<Object> defaultKeyedValues : this.data) {
                        defaultKeyedValues.put(yKey, null);
                    }
                    dkvs.put(yKey, n);
                }
            } else if (yIndex >= 0) {
                this.xKeys.add(xKey);
                DefaultKeyedValues<T> d = new DefaultKeyedValues<T>(this.yKeys);
                d.put(yKey, n);
                this.data.add(d);
            } else {
                this.xKeys.add(xKey);
                this.yKeys.add(yKey);
                for (DefaultKeyedValues<Object> defaultKeyedValues : this.data) {
                    defaultKeyedValues.put(yKey, null);
                }
                DefaultKeyedValues<T> d = new DefaultKeyedValues<T>(this.yKeys);
                d.put(yKey, n);
                this.data.add(d);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues2D)) {
            return false;
        }
        DefaultKeyedValues2D that = (DefaultKeyedValues2D)obj;
        if (!this.xKeys.equals(that.xKeys)) {
            return false;
        }
        if (!this.yKeys.equals(that.yKeys)) {
            return false;
        }
        return this.data.equals(that.data);
    }
}

