/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportToSVGAction
extends AbstractAction {
    private Panel3D panel;

    public ExportToSVGAction(Panel3D panel) {
        super("SVG...");
        ArgChecks.nullNotPermitted(panel, "Name");
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("SVG Files", "svg");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showSaveDialog(this.panel);
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (!filename.endsWith(".svg")) {
                filename = filename + ".svg";
            }
            this.panel.writeAsSVG(new File(filename), this.panel.getWidth(), this.panel.getHeight());
        }
    }
}

