/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.AbstractCategoryRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class LineRenderer3D
extends AbstractCategoryRenderer3D
implements Serializable {
    private double lineWidth = 0.4;
    private double lineHeight = 0.2;
    private CategoryColorSource clipColorSource = new StandardCategoryColorSource(Color.RED);

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double width) {
        this.lineWidth = width;
        this.fireChangeEvent();
    }

    public double getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(double height) {
        this.lineHeight = height;
        this.fireChangeEvent();
    }

    public CategoryColorSource getClipColorSource() {
        return this.clipColorSource;
    }

    public void setClipColorSource(CategoryColorSource source) {
        this.clipColorSource = source;
        this.fireChangeEvent();
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        double value = dataset.getDoubleValue(series, row, column);
        if (Double.isNaN(value)) {
            return;
        }
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Range r = valueAxis.getRange();
        Comparable rowKey = dataset.getRowKey(row);
        Comparable columnKey = dataset.getColumnKey(column);
        double rowValue = rowAxis.getCategoryValue(rowKey);
        double columnValue = columnAxis.getCategoryValue(columnKey);
        double ww = dimensions.getWidth();
        double hh = dimensions.getHeight();
        double dd = dimensions.getDepth();
        if (column < dataset.getColumnCount() - 1) {
            Color c;
            Color color;
            double wdelta = this.lineWidth / 2.0;
            double x0 = columnAxis.translateToWorld(columnValue, ww) + xOffset;
            double y0 = valueAxis.translateToWorld(value, hh) + yOffset;
            double z0 = rowAxis.translateToWorld(rowValue, dd) + zOffset;
            double zf = z0 - wdelta;
            double zb = z0 + wdelta;
            double wmin = valueAxis.translateToWorld(r.getMin(), hh) + yOffset;
            double wmax = valueAxis.translateToWorld(r.getMax(), hh) + yOffset;
            Comparable nextColumnKey = dataset.getColumnKey(column + 1);
            double nextColumnValue = columnAxis.getCategoryValue(nextColumnKey);
            double x1 = columnAxis.translateToWorld(nextColumnValue, ww) + xOffset;
            double value1 = dataset.getDoubleValue(series, row, column + 1);
            double y1 = valueAxis.translateToWorld(value1, hh) + yOffset;
            Color clipColor = color = this.getColorSource().getColor(series, row, column);
            if (this.getClipColorSource() != null && (c = this.getClipColorSource().getColor(series, row, column)) != null) {
                clipColor = c;
            }
            boolean closingFace = column == dataset.getColumnCount() - 2;
            boolean openingFace = column == 0;
            Object3D obj = new Object3D();
            if (this.lineHeight > 0.0) {
                double hdelta = this.lineHeight / 2.0;
                double y0b = y0 - hdelta;
                double y0t = y0 + hdelta;
                double y1b = y1 - hdelta;
                double y1t = y1 + hdelta;
                double[] xpts = this.calcCrossPoints(x0, x1, y0b, y0t, y1b, y1t, wmin, wmax);
                Object3D seg = null;
                if (y0b >= wmax) {
                    seg = this.createSegmentA(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, false, closingFace);
                } else if (y0t > wmax && y0b > wmin) {
                    seg = this.createSegmentB(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, openingFace, closingFace);
                } else if (y0t > wmax && y0b <= wmin) {
                    seg = this.createSegmentC(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, openingFace, closingFace);
                } else if (y0t > wmin && y0b >= wmin) {
                    seg = this.createSegmentD(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, openingFace, closingFace);
                } else if (y0t > wmin && y0b < wmin) {
                    seg = this.createSegmentE(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, openingFace, closingFace);
                } else if (y0t <= wmin) {
                    seg = this.createSegmentF(x0, x1, xpts, y0b, y0t, y1b, y1t, wmin, wmax, zf, zb, color, clipColor, false, closingFace);
                }
                if (seg != null) {
                    world.add(seg);
                }
            } else {
                obj.addVertex(x0, y0, z0 - wdelta);
                obj.addVertex(x0, y0, z0 + wdelta);
                obj.addVertex(x1, y1, z0 + wdelta);
                obj.addVertex(x1, y1, z0 - wdelta);
                obj.addFace(new int[]{0, 1, 2, 3}, color, true);
                obj.addFace(new int[]{3, 2, 1, 0}, color, true);
            }
            world.add(obj);
        }
    }

    private double[] calcCrossPoints(double x0, double x1, double y0b, double y0t, double y1b, double y1t, double ymin, double ymax) {
        double[] xpts = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        double factor = (y0b - ymin) / (y0b - y1b);
        xpts[0] = x0 + factor * (x1 - x0);
        factor = (y0t - ymin) / (y0t - y1t);
        xpts[1] = x0 + factor * (x1 - x0);
        factor = (y0b - ymax) / (y0b - y1b);
        xpts[2] = x0 + factor * (x1 - x0);
        factor = (y0t - ymax) / (y0t - y1t);
        xpts[3] = x0 + factor * (x1 - x0);
        return xpts;
    }

    private Object3D createSegmentA(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            return null;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(xpts[2], wmax, zf);
                seg.addVertex(xpts[2], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4}, color, true);
                seg.addFace(new int[]{1, 5, 3}, color, true);
                seg.addFace(new int[]{0, 1, 3, 2}, clipColor, true);
                seg.addFace(new int[]{4, 5, 1, 0}, color, true);
                if (closingFace) {
                    seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                }
                return seg;
            }
            return null;
        }
        if (y1t >= wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(xpts[2], wmax, zf);
                seg.addVertex(xpts[2], wmax, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6}, color, true);
                seg.addFace(new int[]{1, 7, 5, 3}, color, true);
                seg.addFace(new int[]{0, 1, 3, 2}, clipColor, true);
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                seg.addFace(new int[]{6, 7, 1, 0}, color, true);
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                }
                return seg;
            }
            Object3D seg = new Object3D();
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
            seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, color, true);
            seg.addFace(new int[]{0, 1, 3, 2}, clipColor, true);
            seg.addFace(new int[]{6, 7, 9, 8}, clipColor, true);
            seg.addFace(new int[]{8, 9, 1, 0}, color, true);
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6}, color, true);
            }
            return seg;
        }
        Object3D seg = new Object3D();
        seg.addVertex(xpts[2], wmax, zf);
        seg.addVertex(xpts[2], wmax, zb);
        seg.addVertex(xpts[3], wmax, zf);
        seg.addVertex(xpts[3], wmax, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6}, color, true);
        seg.addFace(new int[]{1, 7, 5, 3}, color, true);
        seg.addFace(new int[]{4, 2, 3, 5}, color, true);
        seg.addFace(new int[]{0, 6, 7, 1}, color, true);
        seg.addFace(new int[]{0, 1, 3, 2}, clipColor, true);
        seg.addFace(new int[]{4, 5, 7, 6}, clipColor, true);
        return seg;
    }

    private Object3D createSegmentB(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b >= wmax) {
            Object3D seg = new Object3D();
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, wmax, zf);
            seg.addVertex(x0, wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addFace(new int[]{0, 2, 4}, color, true);
            seg.addFace(new int[]{1, 5, 3}, color, true);
            seg.addFace(new int[]{0, 4, 5, 1}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, wmax, zf);
                seg.addVertex(x0, wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6}, color, true);
                seg.addFace(new int[]{1, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
                seg.addFace(new int[]{0, 6, 7, 1}, color, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                }
                return seg;
            }
            return null;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, wmax, zf);
                seg.addVertex(x0, wmax, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
                seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
                seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                seg.addFace(new int[]{0, 8, 9, 1}, color, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8}, color, true);
                }
                return seg;
            }
            Object3D seg = new Object3D();
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, wmax, zf);
            seg.addVertex(x0, wmax, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8, 10}, color, true);
            seg.addFace(new int[]{1, 11, 9, 7, 5, 3}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
            seg.addFace(new int[]{4, 5, 7, 6}, color, true);
            seg.addFace(new int[]{8, 9, 11, 10}, clipColor, true);
            seg.addFace(new int[]{10, 11, 1, 0}, color, true);
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            if (closingFace) {
                seg.addFace(new int[]{6, 7, 9, 8}, color, true);
            }
            return seg;
        }
        Object3D seg = new Object3D();
        seg.addVertex(x0, y0b, zf);
        seg.addVertex(x0, y0b, zb);
        seg.addVertex(x0, wmax, zf);
        seg.addVertex(x0, wmax, zb);
        seg.addVertex(xpts[3], wmax, zf);
        seg.addVertex(xpts[3], wmax, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
        seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
        seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
        seg.addFace(new int[]{4, 5, 7, 6}, color, true);
        seg.addFace(new int[]{6, 7, 9, 8}, clipColor, true);
        seg.addFace(new int[]{8, 9, 1, 0}, color, true);
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2}, color, true);
        }
        return seg;
    }

    private Object3D createSegmentC(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        return null;
    }

    private Object3D createSegmentD(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b >= wmax) {
            Object3D seg = new Object3D();
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addFace(new int[]{0, 2, 4, 6}, color, true);
            seg.addFace(new int[]{1, 7, 5, 3}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, color, true);
            seg.addFace(new int[]{4, 5, 7, 6}, clipColor, true);
            seg.addFace(new int[]{0, 6, 7, 1}, color, true);
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
                seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                seg.addFace(new int[]{4, 5, 7, 6}, clipColor, true);
                seg.addFace(new int[]{0, 8, 9, 1}, color, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8}, color, true);
                }
                return seg;
            }
            return null;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6}, color, true);
                seg.addFace(new int[]{1, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                seg.addFace(new int[]{0, 6, 7, 1}, color, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                }
                return seg;
            }
            Object3D seg = new Object3D();
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
            seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, color, true);
            seg.addFace(new int[]{0, 8, 9, 1}, color, true);
            seg.addFace(new int[]{6, 7, 9, 8}, clipColor, true);
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6}, color, true);
            }
            return seg;
        }
        Object3D seg = new Object3D();
        seg.addVertex(x0, y0b, zf);
        seg.addVertex(x0, y0b, zb);
        seg.addVertex(x0, y0t, zf);
        seg.addVertex(x0, y0t, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6}, color, true);
        seg.addFace(new int[]{1, 7, 5, 3}, color, true);
        seg.addFace(new int[]{2, 3, 5, 4}, color, true);
        seg.addFace(new int[]{0, 6, 7, 1}, color, true);
        seg.addFace(new int[]{4, 5, 7, 6}, clipColor, true);
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2}, color, true);
        }
        return seg;
    }

    private Object3D createSegmentE(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            Object3D seg = new Object3D();
            seg.addVertex(x0, wmin, zf);
            seg.addVertex(x0, wmin, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
            seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, color, true);
            seg.addFace(new int[]{4, 5, 7, 6}, clipColor, true);
            seg.addFace(new int[]{6, 7, 9, 8}, color, true);
            seg.addFace(new int[]{0, 8, 9, 1}, clipColor, true);
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, wmin, zf);
                seg.addVertex(x0, wmin, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8, 10}, color, true);
                seg.addFace(new int[]{1, 11, 9, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                seg.addFace(new int[]{5, 7, 6, 4}, clipColor, true);
                seg.addFace(new int[]{8, 9, 11, 10}, color, true);
                seg.addFace(new int[]{1, 0, 10, 11}, clipColor, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8}, color, true);
                }
                return seg;
            }
            return null;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(x0, wmin, zf);
                seg.addVertex(x0, wmin, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
                seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                seg.addFace(new int[]{6, 7, 9, 8}, color, true);
                seg.addFace(new int[]{0, 8, 9, 1}, clipColor, true);
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                }
                return seg;
            }
            return null;
        }
        Object3D seg = new Object3D();
        seg.addVertex(x0, wmin, zf);
        seg.addVertex(x0, wmin, zb);
        seg.addVertex(x0, y0t, zf);
        seg.addVertex(x0, y0t, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addFace(new int[]{0, 2, 4}, color, true);
        seg.addFace(new int[]{1, 5, 3}, color, true);
        seg.addFace(new int[]{2, 3, 5, 4}, color, true);
        seg.addFace(new int[]{0, 4, 5, 1}, clipColor, true);
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2}, color, true);
        }
        return seg;
    }

    private Object3D createSegmentF(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            Object3D seg = new Object3D();
            seg.addVertex(xpts[1], wmin, zf);
            seg.addVertex(xpts[1], wmin, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6}, color, true);
            seg.addFace(new int[]{1, 7, 5, 3}, color, true);
            seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
            seg.addFace(new int[]{4, 5, 7, 6}, color, true);
            seg.addFace(new int[]{0, 6, 7, 1}, clipColor, true);
            return seg;
        }
        if (y1t > wmax) {
            if (y1b > wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(xpts[1], wmin, zf);
                seg.addVertex(xpts[1], wmin, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
                seg.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
                seg.addFace(new int[]{2, 3, 5, 4}, clipColor, true);
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                seg.addFace(new int[]{0, 8, 9, 1}, clipColor, true);
                seg.addFace(new int[]{6, 7, 9, 8}, color, true);
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                }
                return seg;
            }
            return null;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D();
                seg.addVertex(xpts[1], wmin, zf);
                seg.addVertex(xpts[1], wmin, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6}, color, true);
                seg.addFace(new int[]{1, 7, 5, 3}, color, true);
                seg.addFace(new int[]{0, 1, 3, 2}, color, true);
                seg.addFace(new int[]{4, 5, 7, 6}, color, true);
                seg.addFace(new int[]{0, 6, 7, 1}, clipColor, true);
                if (closingFace) {
                    seg.addFace(new int[]{2, 3, 5, 4}, color, true);
                }
                return seg;
            }
            Object3D seg = new Object3D();
            seg.addVertex(xpts[1], wmin, zf);
            seg.addVertex(xpts[1], wmin, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4}, color, true);
            seg.addFace(new int[]{1, 5, 3}, color, true);
            seg.addFace(new int[]{0, 1, 3, 2}, color, true);
            seg.addFace(new int[]{0, 4, 5, 1}, clipColor, true);
            if (closingFace) {
                seg.addFace(new int[]{2, 3, 5, 4}, color, true);
            }
            return seg;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineRenderer3D)) {
            return false;
        }
        LineRenderer3D that = (LineRenderer3D)obj;
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        if (this.lineHeight != that.lineHeight) {
            return false;
        }
        if (!ObjectUtils.equals(this.clipColorSource, that.clipColorSource)) {
            return false;
        }
        return super.equals(obj);
    }
}

