/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.Range;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.AbstractRenderer3D;
import com.orsoncharts.renderer.xyz.StandardXYZColorSource;
import com.orsoncharts.renderer.xyz.XYZColorSource;
import com.orsoncharts.util.ArgChecks;

public class AbstractXYZRenderer
extends AbstractRenderer3D {
    private XYZPlot plot;
    private XYZColorSource colorSource = new StandardXYZColorSource();

    protected AbstractXYZRenderer() {
    }

    public XYZPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYZPlot plot) {
        this.plot = plot;
    }

    public XYZColorSource getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(XYZColorSource colorSource) {
        ArgChecks.nullNotPermitted(colorSource, "colorSource");
        this.colorSource = colorSource;
        this.fireChangeEvent();
    }

    public Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset);
    }

    public Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset);
    }

    public Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractXYZRenderer)) {
            return false;
        }
        AbstractXYZRenderer that = (AbstractXYZRenderer)obj;
        return this.colorSource.equals(that.colorSource);
    }
}

